/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio;

import java.util.Iterator;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import vavi.util.Debug;

public class IIOUtil {
    private static boolean ignoreErrors = true;

    private IIOUtil() {
    }

    public static void setIgnoreErrors(boolean ignoreErrors) {
        IIOUtil.ignoreErrors = ignoreErrors;
    }

    public static <T> void setOrder(Class<T> pt, String p1, String p2) {
        IIOUtil.list(pt, p1, p2);
        for (int retry = 0; !IIOUtil.verify(pt, p1, p2) && retry < 10; ++retry) {
            IIOUtil.setOrderInternal(pt, p1, p2);
        }
        IIOUtil.list(pt, p1, p2);
    }

    static <T> void list(Class<T> pt, String p1, String p2) {
        IIORegistry iioRegistry = IIORegistry.getDefaultInstance();
        Iterator<T> i = iioRegistry.getServiceProviders(pt, true);
        System.out.println("---------");
        while (i.hasNext()) {
            T p = i.next();
            if (p1.equals(p.getClass().getName())) {
                System.out.println(p.getClass().getName() + " (I)");
                continue;
            }
            if (!p2.equals(p.getClass().getName())) continue;
            System.out.println(p.getClass().getName() + " (II)");
        }
    }

    private static <T> boolean verify(Class<T> pt, String p1, String p2) {
        IIORegistry iioRegistry = IIORegistry.getDefaultInstance();
        Iterator<T> i = iioRegistry.getServiceProviders(pt, true);
        int pos1 = 0;
        int pos2 = 0;
        int pos = 0;
        while (i.hasNext()) {
            T p = i.next();
            if (p1.equals(p.getClass().getName())) {
                pos1 = pos;
            } else if (p2.equals(p.getClass().getName())) {
                pos2 = pos;
            }
            ++pos;
        }
        return pos1 < pos2;
    }

    private static <T> void setOrderInternal(Class<T> pt, String p1, String p2) {
        IIORegistry iioRegistry = IIORegistry.getDefaultInstance();
        Object sp1 = null;
        Object sp2 = null;
        Iterator<T> i = iioRegistry.getServiceProviders(pt, true);
        while (i.hasNext()) {
            T p = i.next();
            if (p1.equals(p.getClass().getName())) {
                sp1 = p;
                continue;
            }
            if (!p2.equals(p.getClass().getName())) continue;
            sp2 = p;
        }
        if (sp1 == null || sp2 == null) {
            if (!ignoreErrors) {
                throw new IllegalArgumentException(p1 + " or " + p2 + " not found");
            }
            Debug.println((Object)(p1 + " or " + p2 + " not found"));
        }
        iioRegistry.setOrdering(pt, sp1, sp2);
    }

    public static <T> void deregister(Class<T> pt, String p0) {
        IIORegistry iioRegistry = IIORegistry.getDefaultInstance();
        Object sp = null;
        Iterator<T> i = iioRegistry.getServiceProviders(pt, true);
        while (i.hasNext()) {
            T p = i.next();
            if (!p0.equals(p.getClass().getName())) continue;
            sp = p;
        }
        if (sp == null) {
            if (!ignoreErrors) {
                throw new IllegalArgumentException(p0 + " not found");
            }
            Debug.println((Object)(p0 + " not found"));
        }
        iioRegistry.deregisterServiceProvider(sp, pt);
    }

    public static ImageWriter getImageWriter(String type, String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("no such ImageWriter: " + className);
        }
        Iterator<ImageWriter> iws = ImageIO.getImageWritersByFormatName(type);
        while (iws.hasNext()) {
            ImageWriter iw = iws.next();
            if (!clazz.isInstance(iw)) continue;
            Debug.println((Level)Level.FINEST, (Object)("ImageWriter: " + iw.getClass()));
            return iw;
        }
        throw new IllegalStateException("no suitable ImageWriter: " + type);
    }

    public static ImageReader getImageReader(String type, String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("no such ImageReader: " + className);
        }
        Iterator<ImageReader> irs = ImageIO.getImageReadersByFormatName(type);
        while (irs.hasNext()) {
            ImageReader ir = irs.next();
            if (!clazz.isInstance(ir)) continue;
            Debug.println((Level)Level.FINEST, (Object)("ImageReader: " + ir.getClass().getName()));
            return ir;
        }
        throw new IllegalStateException("no suitable ImageReader: " + type);
    }
}

