/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.zim;

import java.io.IOException;
import vavi.io.SeekableDataInput;

public class ZimStream {
    byte[] flags1 = new byte[1];
    byte[] flags2 = new byte[8];
    private SeekableDataInput<?> sdi;

    public ZimStream(SeekableDataInput<?> sdi) {
        this.sdi = sdi;
    }

    private int readUnpacked(byte[] flags, int unpackedOffset) throws IOException {
        return ((flags[unpackedOffset >> 3] & 0xFF) >> (~unpackedOffset & 7) & 1) != 0 ? this.readByte() : 0;
    }

    boolean unpack(byte[] flags, byte[] unpacked, int unpackedLength) throws IOException {
        boolean enough = true;
        for (int unpackedOffset = 0; unpackedOffset < unpackedLength; ++unpackedOffset) {
            int b = this.readUnpacked(flags, unpackedOffset);
            if (b < 0) {
                enough = false;
                b = 0;
            }
            unpacked[unpackedOffset] = (byte)b;
        }
        return enough;
    }

    boolean unpackFlags2() throws IOException {
        int b = this.readByte();
        if (b < 0) {
            return false;
        }
        this.flags1[0] = (byte)b;
        return this.unpack(this.flags1, this.flags2, 8);
    }

    public int readByte() throws IOException {
        return this.sdi.readByte() & 0xFF;
    }

    public int readUnsignedShort() throws IOException {
        return this.sdi.readUnsignedShort();
    }

    public int skipBytes(int n) throws IOException {
        return this.sdi.skipBytes(n);
    }
}

