/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.resample;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.logging.Level;
import org.scijava.nativelib.NativeLoader;
import vavi.util.Debug;

public class FfmpegResampleOp
implements BufferedImageOp {
    private Hint hint;
    private double sx;
    private double sy;

    public FfmpegResampleOp(double sx, double sy) {
        this(sx, sy, Hint.AREA);
    }

    public FfmpegResampleOp(double sx, double sy, Hint hint) {
        this.sx = sx;
        this.sy = sy;
        this.hint = hint;
    }

    private native void filterInternal(Object var1, int var2, int var3, int var4, int var5, int var6, Object var7, int var8, int var9, int var10, int var11, int var12, int var13);

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        Object[] destBuffer;
        Object[] srcBuffer;
        if (src.getColorModel() instanceof IndexColorModel) {
            throw new IllegalArgumentException("Resampling cannot be performed on an indexed image");
        }
        if (dest == null) {
            dest = this.createCompatibleDestImage(src, src.getColorModel());
        }
        int srcPxelFormat = src.getType();
        int destPxelFormat = dest.getType();
        Debug.println((Level)Level.FINE, (Object)("src pixel format: " + src.getType()));
        Debug.println((Level)Level.FINE, (Object)("dest pixel format: " + dest.getType()));
        int srcPixelSize = src.getColorModel().getPixelSize();
        int destPixelSize = dest.getColorModel().getPixelSize();
        Debug.println((Level)Level.FINE, (Object)("src pixel size: " + src.getColorModel().getPixelSize()));
        Debug.println((Level)Level.FINE, (Object)("dest pixel size: " + dest.getColorModel().getPixelSize()));
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int resizedWidth = dest.getWidth();
        int resizedHeight = dest.getHeight();
        int srcDataType = src.getRaster().getDataBuffer().getDataType();
        int destDataType = dest.getRaster().getDataBuffer().getDataType();
        Debug.println((Level)Level.FINE, (Object)("src data type: " + src.getRaster().getDataBuffer().getDataType()));
        Debug.println((Level)Level.FINE, (Object)("dest data type: " + dest.getRaster().getDataBuffer().getDataType()));
        if (srcDataType == 0) {
            srcBuffer = ((DataBufferByte)src.getRaster().getDataBuffer()).getData();
        } else {
            srcBuffer = ((DataBufferInt)src.getRaster().getDataBuffer()).getData();
            srcPixelSize = 32;
        }
        if (destDataType == 0) {
            destBuffer = ((DataBufferByte)dest.getRaster().getDataBuffer()).getData();
        } else {
            destBuffer = ((DataBufferInt)dest.getRaster().getDataBuffer()).getData();
            destPixelSize = 32;
        }
        this.filterInternal(srcBuffer, srcDataType, srcPxelFormat, srcPixelSize, srcWidth, srcHeight, destBuffer, destDataType, destPxelFormat, destPixelSize, resizedWidth, resizedHeight, this.hint.value);
        return dest;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        Rectangle2D destBounds = this.getBounds2D(src);
        return new BufferedImage(destCM, destCM.createCompatibleWritableRaster((int)destBounds.getWidth(), (int)destBounds.getHeight()), destCM.isAlphaPremultiplied(), null);
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(0, 0, (int)((double)src.getWidth() * this.sx), (int)((double)src.getHeight() * this.sy));
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Double();
        }
        dstPt.setLocation(srcPt.getX() * this.sx, srcPt.getY() * this.sy);
        return dstPt;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    static {
        try {
            NativeLoader.loadLibrary((String)"FfmpegResampleOpWrapper", (String[])new String[0]);
        }
        catch (IOException e) {
            Debug.printStackTrace((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public static enum Hint {
        NONE(0),
        FAST_BILINEAR(1),
        BILINEAR(2),
        BICUBIC(4),
        X(8),
        POINT(16),
        AREA(32),
        BICUBLIN(64),
        GAUSS(128),
        SINC(256),
        LANCZOS(512),
        SPLINE(1024);

        int value;

        private Hint(int value) {
            this.value = value;
        }
    }
}

