/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.resample;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;

public class AwtResampleOp
implements BufferedImageOp {
    private double sx;
    private double sy;
    private int hint;

    public AwtResampleOp(double sx, double sy) {
        this(sx, sy, 16);
    }

    public AwtResampleOp(double sx, double sy, int hint) {
        this.sx = sx;
        this.sy = sy;
        this.hint = hint;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        Rectangle destBounds = (Rectangle)this.getBounds2D(src);
        Image tmpImage = src.getScaledInstance(destBounds.width, destBounds.height, this.hint);
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, src.getColorModel());
        }
        Graphics2D g = dst.createGraphics();
        g.drawImage(tmpImage, 0, 0, null);
        return dst;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        Rectangle destBounds = (Rectangle)this.getBounds2D(src);
        if (destCM != null) {
            return new BufferedImage(destCM, destCM.createCompatibleWritableRaster(destBounds.width, destBounds.height), destCM.isAlphaPremultiplied(), null);
        }
        return new BufferedImage(destBounds.width, destBounds.height, src.getType());
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(0, 0, (int)((double)src.getWidth() * this.sx), (int)((double)src.getHeight() * this.sy));
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Double();
        }
        dstPt.setLocation(srcPt.getX() * this.sx, srcPt.getY() * this.sy);
        return dstPt;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }
}

