/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.quantization;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;

public class NeuralNetQuantizer {
    public static final int nCycles = 100;
    public int netSize = 256;
    public static final int specials = 3;
    public static final int bgColour = 2;
    public int cutNetSize;
    public int maxNetPos;
    public int initRad;
    public static final int radiusBiasShift = 6;
    public static final int radiusBias = 64;
    public int initBiasRadius;
    public static final int radiusDec = 30;
    public static final int alphaBiasShift = 10;
    public static final int initAlpha = 1024;
    public static final double gamma = 1024.0;
    public static final double beta = 9.765625E-4;
    public static final double betaGamma = 1.0;
    private double[][] network;
    protected int[][] colorMap;
    private int[] netIndex;
    private double[] bias;
    private double[] freq;
    public static final int prime1 = 499;
    public static final int prime2 = 491;
    public static final int prime3 = 487;
    public static final int prime4 = 503;
    public static final int maxPrime = 503;
    protected int[] pixels = null;
    private int sampleFac;

    public NeuralNetQuantizer(Image image, int w, int h, int netSize) throws IOException {
        this(1);
        this.init0();
        this.setPixels(image, w, h);
        this.setUpArrays();
        this.netSize = netSize;
        this.init();
    }

    public NeuralNetQuantizer(Image image, int w, int h) throws IOException {
        this(1);
        this.init0();
        this.setPixels(image, w, h);
        this.setUpArrays();
        this.init();
    }

    public NeuralNetQuantizer(int sample, Image image, int w, int h) throws IOException {
        this(sample);
        this.init0();
        this.setPixels(image, w, h);
        this.setUpArrays();
        this.init();
    }

    public NeuralNetQuantizer(Image image, ImageObserver observer) throws IOException {
        this(1);
        this.init0();
        this.setPixels(image, observer);
        this.setUpArrays();
        this.init();
    }

    private NeuralNetQuantizer(int sample) throws IOException {
        if (sample < 1 || sample > 30) {
            throw new IllegalArgumentException("Sample must be 1..30");
        }
        this.sampleFac = sample;
    }

    public NeuralNetQuantizer(int sample, Image image, ImageObserver observer) throws IOException {
        this(sample);
        this.init0();
        this.setPixels(image, observer);
        this.setUpArrays();
        this.init();
    }

    public int getColorCount() {
        return this.netSize;
    }

    public Color getColor(int i) {
        if (i < 0 || i >= this.netSize) {
            return null;
        }
        int bb = this.colorMap[i][0];
        int gg = this.colorMap[i][1];
        int rr = this.colorMap[i][2];
        return new Color(rr, gg, bb);
    }

    public int writeColourMap(boolean rgb, OutputStream out) throws IOException {
        for (int i = 0; i < this.netSize; ++i) {
            int bb = this.colorMap[i][0];
            int gg = this.colorMap[i][1];
            int rr = this.colorMap[i][2];
            out.write(rgb ? rr : bb);
            out.write(gg);
            out.write(rgb ? bb : rr);
        }
        return this.netSize;
    }

    protected void setUpArrays() {
        int i;
        this.network[0][0] = 0.0;
        this.network[0][1] = 0.0;
        this.network[0][2] = 0.0;
        this.network[1][0] = 1.0;
        this.network[1][1] = 1.0;
        this.network[1][2] = 1.0;
        for (i = 0; i < 3; ++i) {
            this.freq[i] = 1.0 / (double)this.netSize;
            this.bias[i] = 0.0;
        }
        for (i = 3; i < this.netSize; ++i) {
            double[] p = this.network[i];
            p[0] = 256.0 * (double)(i - 3) / (double)this.cutNetSize;
            p[1] = 256.0 * (double)(i - 3) / (double)this.cutNetSize;
            p[2] = 256.0 * (double)(i - 3) / (double)this.cutNetSize;
            this.freq[i] = 1.0 / (double)this.netSize;
            this.bias[i] = 0.0;
        }
    }

    private void setPixels(Image image, ImageObserver observer) throws IOException {
        if (image == null) {
            throw new IllegalArgumentException("Image is null");
        }
        int w = image.getWidth(observer);
        int h = image.getHeight(observer);
        this.setPixels(image, w, h);
    }

    private void setPixels(Image image, int w, int h) throws IOException {
        if (w * h < 503) {
            throw new IllegalArgumentException("Image is too small");
        }
        this.pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, w, h, this.pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if ((pg.getStatus() & 0x80) != 0) {
            throw new IOException("Image pixel grab aborted or errored");
        }
    }

    private void init() {
        this.learn();
        this.fix();
        this.inxBuild();
    }

    private void init0() {
        this.cutNetSize = this.netSize - 3;
        this.maxNetPos = this.netSize - 1;
        this.initRad = this.netSize / 8;
        this.initBiasRadius = this.initRad * 64;
        this.network = new double[this.netSize][3];
        this.colorMap = new int[this.netSize][4];
        this.netIndex = new int[this.netSize];
        this.bias = new double[this.netSize];
        this.freq = new double[this.netSize];
    }

    private void alterSingle(double alpha, int i, double b, double g, double r) {
        double[] n = this.network[i];
        n[0] = n[0] - alpha * (n[0] - b);
        n[1] = n[1] - alpha * (n[1] - g);
        n[2] = n[2] - alpha * (n[2] - r);
    }

    private void alterNeigh(double alpha, int rad, int i, double b, double g, double r) {
        int hi;
        int lo = i - rad;
        if (lo < 2) {
            lo = 2;
        }
        if ((hi = i + rad) > this.netSize) {
            hi = this.netSize;
        }
        int j = i + 1;
        int k = i - 1;
        int q = 0;
        while (j < hi || k > lo) {
            double[] p;
            double a = alpha * (double)(rad * rad - q * q) / (double)(rad * rad);
            ++q;
            if (j < hi) {
                p = this.network[j];
                p[0] = p[0] - a * (p[0] - b);
                p[1] = p[1] - a * (p[1] - g);
                p[2] = p[2] - a * (p[2] - r);
                ++j;
            }
            if (k <= lo) continue;
            p = this.network[k];
            p[0] = p[0] - a * (p[0] - b);
            p[1] = p[1] - a * (p[1] - g);
            p[2] = p[2] - a * (p[2] - r);
            --k;
        }
    }

    private int contest(double b, double g, double r) {
        int bestPos;
        double bestD;
        double bestBiasd = bestD = 3.4028234663852886E38;
        int bestBiasPos = bestPos = -1;
        for (int i = 3; i < this.netSize; ++i) {
            double biasDist;
            double a;
            double[] n = this.network[i];
            double dist = n[0] - b;
            if (dist < 0.0) {
                dist = -dist;
            }
            if ((a = n[1] - g) < 0.0) {
                a = -a;
            }
            dist += a;
            a = n[2] - r;
            if (a < 0.0) {
                a = -a;
            }
            if ((dist += a) < bestD) {
                bestD = dist;
                bestPos = i;
            }
            if ((biasDist = dist - this.bias[i]) < bestBiasd) {
                bestBiasd = biasDist;
                bestBiasPos = i;
            }
            int n2 = i;
            this.freq[n2] = this.freq[n2] - 9.765625E-4 * this.freq[i];
            int n3 = i;
            this.bias[n3] = this.bias[n3] + 1.0 * this.freq[i];
        }
        int n = bestPos;
        this.freq[n] = this.freq[n] + 9.765625E-4;
        int n4 = bestPos;
        this.bias[n4] = this.bias[n4] - 1.0;
        return bestBiasPos;
    }

    private int specialFind(double b, double g, double r) {
        for (int i = 0; i < 3; ++i) {
            double[] n = this.network[i];
            if (n[0] != b || n[1] != g || n[2] != r) continue;
            return i;
        }
        return -1;
    }

    private void learn() {
        int biasRadius = this.initBiasRadius;
        int alphaDec = 30 + (this.sampleFac - 1) / 3;
        int lengthCount = this.pixels.length;
        int samplePixels = lengthCount / this.sampleFac;
        int delta = samplePixels / 100;
        int alpha = 1024;
        int rad = biasRadius >> 6;
        if (rad <= 1) {
            rad = 0;
        }
        int pos = 0;
        int step = lengthCount % 499 != 0 ? 499 : (lengthCount % 491 != 0 ? 491 : (lengthCount % 487 != 0 ? 487 : 503));
        int i = 0;
        while (i < samplePixels) {
            int j;
            int p = this.pixels[pos];
            int red = p >> 16 & 0xFF;
            int green = p >> 8 & 0xFF;
            int blue = p & 0xFF;
            double b = blue;
            double g = green;
            double r = red;
            if (i == 0) {
                this.network[2][0] = blue;
                this.network[2][1] = green;
                this.network[2][2] = red;
            }
            int n = j = (j = this.specialFind(b, g, r)) < 0 ? this.contest(b, g, r) : j;
            if (j >= 3) {
                double a = 1.0 * (double)alpha / 1024.0;
                this.alterSingle(a, j, b, g, r);
                if (rad > 0) {
                    this.alterNeigh(a, rad, j, b, g, r);
                }
            }
            pos += step;
            while (pos >= lengthCount) {
                pos -= lengthCount;
            }
            if (++i % delta != 0) continue;
            alpha -= alpha / alphaDec;
            if ((rad = (biasRadius -= biasRadius / 30) >> 6) > 1) continue;
            rad = 0;
        }
    }

    private void fix() {
        for (int i = 0; i < this.netSize; ++i) {
            for (int j = 0; j < 3; ++j) {
                int x = (int)(0.5 + this.network[i][j]);
                if (x < 0) {
                    x = 0;
                }
                if (x > 255) {
                    x = 255;
                }
                this.colorMap[i][j] = x;
            }
            this.colorMap[i][3] = i;
        }
    }

    private void inxBuild() {
        int previousCol = 0;
        int startPos = 0;
        for (int i = 0; i < this.netSize; ++i) {
            int[] q;
            int j;
            int[] p = this.colorMap[i];
            int smallPos = i;
            int smallVal = p[1];
            for (j = i + 1; j < this.netSize; ++j) {
                q = this.colorMap[j];
                if (q[1] >= smallVal) continue;
                smallPos = j;
                smallVal = q[1];
            }
            q = this.colorMap[smallPos];
            if (i != smallPos) {
                j = q[0];
                q[0] = p[0];
                p[0] = j;
                j = q[1];
                q[1] = p[1];
                p[1] = j;
                j = q[2];
                q[2] = p[2];
                p[2] = j;
                j = q[3];
                q[3] = p[3];
                p[3] = j;
            }
            if (smallVal == previousCol) continue;
            this.netIndex[previousCol] = startPos + i >> 1;
            for (j = previousCol + 1; j < smallVal; ++j) {
                this.netIndex[j] = i;
            }
            previousCol = smallVal;
            startPos = i;
        }
        this.netIndex[previousCol] = startPos + this.maxNetPos >> 1;
        for (int j = previousCol + 1; j < 256; ++j) {
            this.netIndex[j] = this.maxNetPos;
        }
    }

    public int convert(int pixel) {
        int alfa = pixel >> 24 & 0xFF;
        int r = pixel >> 16 & 0xFF;
        int g = pixel >> 8 & 0xFF;
        int b = pixel & 0xFF;
        int i = this.inxSearch(b, g, r);
        int bb = this.colorMap[i][0];
        int gg = this.colorMap[i][1];
        int rr = this.colorMap[i][2];
        return alfa << 24 | rr << 16 | gg << 8 | bb;
    }

    public int lookup(int pixel) {
        int r = pixel >> 16 & 0xFF;
        int g = pixel >> 8 & 0xFF;
        int b = pixel & 0xFF;
        return this.inxSearch(b, g, r);
    }

    public int lookup(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return this.inxSearch(b, g, r);
    }

    public int lookup(boolean rgb, int x, int g, int y) {
        return rgb ? this.inxSearch(y, g, x) : this.inxSearch(x, g, y);
    }

    protected int inxSearch(int b, int g, int r) {
        int bestD = 1000;
        int best = -1;
        int i = this.netIndex[g];
        int j = i - 1;
        while (i < this.netSize || j >= 0) {
            int a;
            int dist;
            int[] p;
            if (i < this.netSize) {
                p = this.colorMap[i];
                dist = p[1] - g;
                if (dist >= bestD) {
                    i = this.netSize;
                } else {
                    if (dist < 0) {
                        dist = -dist;
                    }
                    if ((a = p[0] - b) < 0) {
                        a = -a;
                    }
                    if ((dist += a) < bestD) {
                        a = p[2] - r;
                        if (a < 0) {
                            a = -a;
                        }
                        if ((dist += a) < bestD) {
                            bestD = dist;
                            best = i;
                        }
                    }
                    ++i;
                }
            }
            if (j < 0) continue;
            p = this.colorMap[j];
            dist = g - p[1];
            if (dist >= bestD) {
                j = -1;
                continue;
            }
            if (dist < 0) {
                dist = -dist;
            }
            if ((a = p[0] - b) < 0) {
                a = -a;
            }
            if ((dist += a) < bestD) {
                a = p[2] - r;
                if (a < 0) {
                    a = -a;
                }
                if ((dist += a) < bestD) {
                    bestD = dist;
                    best = j;
                }
            }
            --j;
        }
        return best;
    }
}

