/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.quantization;

public class ImageMagickQuantizer {
    private static final boolean QUICK = true;
    private static final int MAX_RGB = 255;
    private static final int MAX_NODES = 266817;
    private static final int MAX_TREE_DEPTH = 8;
    private static int[] SQUARES;
    private static int[] SHIFT;

    public static int[] quantizeImage(int[][] pixels, int maxColors) {
        Cube cube = new Cube(pixels, maxColors);
        cube.classification();
        cube.reduction();
        cube.assignment();
        return cube.colorMap;
    }

    static {
        int i;
        SQUARES = new int[511];
        for (i = -255; i <= 255; ++i) {
            ImageMagickQuantizer.SQUARES[i + 255] = i * i;
        }
        SHIFT = new int[9];
        for (i = 0; i < 9; ++i) {
            ImageMagickQuantizer.SHIFT[i] = 1 << 15 - i;
        }
    }

    private static class Cube {
        int[][] pixels;
        int maxColors;
        int[] colorMap;
        Node root;
        int depth;
        int colors;
        int nodes;

        Cube(int[][] pixels, int maxColors) {
            this.pixels = pixels;
            this.maxColors = maxColors;
            int i = maxColors;
            this.depth = 1;
            while (i != 0) {
                i /= 4;
                ++this.depth;
            }
            if (this.depth > 1) {
                --this.depth;
            }
            if (this.depth > 8) {
                this.depth = 8;
            } else if (this.depth < 2) {
                this.depth = 2;
            }
            this.root = new Node(this);
        }

        void classification() {
            int[][] pixels = this.pixels;
            int width = pixels.length;
            int height = pixels[0].length;
            int x = width;
            while (x-- > 0) {
                int y = height;
                while (y-- > 0) {
                    int pixel = pixels[x][y];
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel >> 0 & 0xFF;
                    if (this.nodes > 266817) {
                        System.out.println("pruning");
                        this.root.pruneLevel();
                        --this.depth;
                    }
                    Node node = this.root;
                    for (int level = 1; level <= this.depth; ++level) {
                        int id = (red > node.midRed ? 1 : 0) << 0 | (green > node.midGreen ? 1 : 0) << 1 | (blue > node.midBlue ? 1 : 0) << 2;
                        if (node.child[id] == null) {
                            new Node(node, id, level);
                        }
                        node = node.child[id];
                        node.number_pixels += SHIFT[level];
                    }
                    ++node.unique;
                    node.totalRed += red;
                    node.totalGreen += green;
                    node.totalBlue += blue;
                }
            }
        }

        void reduction() {
            int threshold = 1;
            while (this.colors > this.maxColors) {
                this.colors = 0;
                threshold = this.root.reduce(threshold, Integer.MAX_VALUE);
            }
        }

        void assignment() {
            this.colorMap = new int[this.colors];
            this.colors = 0;
            this.root.colormap();
            int[][] pixels = this.pixels;
            int width = pixels.length;
            int height = pixels[0].length;
            Search search = new Search();
            int x = width;
            while (x-- > 0) {
                int y = height;
                while (y-- > 0) {
                    int id;
                    int pixel = pixels[x][y];
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel >> 0 & 0xFF;
                    Node node = this.root;
                    while (node.child[id = (red > node.midRed ? 1 : 0) << 0 | (green > node.midGreen ? 1 : 0) << 1 | (blue > node.midBlue ? 1 : 0) << 2] != null) {
                        node = node.child[id];
                    }
                    pixels[x][y] = node.colorNumber;
                }
            }
        }

        static class Node {
            Cube cube;
            Node parent;
            Node[] child;
            int nChild;
            int id;
            int level;
            int midRed;
            int midGreen;
            int midBlue;
            int number_pixels;
            int unique;
            int totalRed;
            int totalGreen;
            int totalBlue;
            int colorNumber;

            Node(Cube cube) {
                this.cube = cube;
                this.parent = this;
                this.child = new Node[8];
                this.id = 0;
                this.level = 0;
                this.number_pixels = Integer.MAX_VALUE;
                this.midRed = 128;
                this.midGreen = 128;
                this.midBlue = 128;
            }

            Node(Node parent, int id, int level) {
                this.cube = parent.cube;
                this.parent = parent;
                this.child = new Node[8];
                this.id = id;
                this.level = level;
                ++this.cube.nodes;
                if (level == this.cube.depth) {
                    ++this.cube.colors;
                }
                ++parent.nChild;
                parent.child[id] = this;
                int bi = 1 << 8 - level >> 1;
                this.midRed = parent.midRed + ((id & 1) > 0 ? bi : -bi);
                this.midGreen = parent.midGreen + ((id & 2) > 0 ? bi : -bi);
                this.midBlue = parent.midBlue + ((id & 4) > 0 ? bi : -bi);
            }

            void pruneChild() {
                --this.parent.nChild;
                this.parent.unique += this.unique;
                this.parent.totalRed += this.totalRed;
                this.parent.totalGreen += this.totalGreen;
                this.parent.totalBlue += this.totalBlue;
                this.parent.child[this.id] = null;
                --this.cube.nodes;
                this.cube = null;
                this.parent = null;
            }

            void pruneLevel() {
                if (this.nChild != 0) {
                    for (int id = 0; id < 8; ++id) {
                        if (this.child[id] == null) continue;
                        this.child[id].pruneLevel();
                    }
                }
                if (this.level == this.cube.depth) {
                    this.pruneChild();
                }
            }

            int reduce(int threshold, int next_threshold) {
                if (this.nChild != 0) {
                    for (int id = 0; id < 8; ++id) {
                        if (this.child[id] == null) continue;
                        next_threshold = this.child[id].reduce(threshold, next_threshold);
                    }
                }
                if (this.number_pixels <= threshold) {
                    this.pruneChild();
                } else {
                    if (this.unique != 0) {
                        ++this.cube.colors;
                    }
                    if (this.number_pixels < next_threshold) {
                        next_threshold = this.number_pixels;
                    }
                }
                return next_threshold;
            }

            void colormap() {
                if (this.nChild != 0) {
                    for (int id = 0; id < 8; ++id) {
                        if (this.child[id] == null) continue;
                        this.child[id].colormap();
                    }
                }
                if (this.unique != 0) {
                    int r = (this.totalRed + (this.unique >> 1)) / this.unique;
                    int g = (this.totalGreen + (this.unique >> 1)) / this.unique;
                    int b = (this.totalBlue + (this.unique >> 1)) / this.unique;
                    this.cube.colorMap[this.cube.colors] = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
                    this.colorNumber = this.cube.colors++;
                }
            }

            void closestColor(int red, int green, int blue, Search search) {
                int color;
                int distance;
                if (this.nChild != 0) {
                    for (int id = 0; id < 8; ++id) {
                        if (this.child[id] == null) continue;
                        this.child[id].closestColor(red, green, blue, search);
                    }
                }
                if (this.unique != 0 && (distance = Node.distance(color = this.cube.colorMap[this.colorNumber], red, green, blue)) < search.distance) {
                    search.distance = distance;
                    search.colorNumber = this.colorNumber;
                }
            }

            static int distance(int color, int r, int g, int b) {
                return SQUARES[(color >> 16 & 0xFF) - r + 255] + SQUARES[(color >> 8 & 0xFF) - g + 255] + SQUARES[(color >> 0 & 0xFF) - b + 255];
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                if (this.parent == this) {
                    sb.append("root");
                } else {
                    sb.append("node");
                }
                sb.append(' ');
                sb.append(this.level);
                sb.append(" [");
                sb.append(this.midRed);
                sb.append(',');
                sb.append(this.midGreen);
                sb.append(',');
                sb.append(this.midBlue);
                sb.append(']');
                return sb.toString();
            }
        }

        static class Search {
            int distance;
            int colorNumber;

            Search() {
            }
        }
    }
}

