/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.quantization;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import vavi.awt.image.BasicBufferedImageOp;
import vavi.awt.image.quantization.ImageMagickQuantizer;

public class ImageMagickQuantizeOp
extends BasicBufferedImageOp {
    private int colors;

    public ImageMagickQuantizeOp(int colors) {
        this.colors = colors;
    }

    @Override
    protected int[] filterPixels(int width, int height, int[] inPixels) {
        int[][] pixels2D = new int[width][height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                pixels2D[x][y] = inPixels[y * width + x];
            }
        }
        int[] palette = ImageMagickQuantizer.quantizeImage(pixels2D, this.colors);
        int[] outPixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                outPixels[y * width + x] = palette[pixels2D[x][y]];
            }
        }
        return outPixels;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(0, 0, src.getWidth(), src.getHeight());
    }

    public static void main(String[] args) throws Exception {
        String file = args[0];
        BufferedImage inImage = ImageIO.read(new File(file));
        ImageMagickQuantizeOp filter = new ImageMagickQuantizeOp(256);
        BufferedImage outImage = filter.createCompatibleDestImage(inImage, null);
        filter.filter(inImage, outImage);
    }
}

