/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.pic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import vavi.util.ByteUtil;
import vavi.util.Debug;

public class RetroPic {
    private Object[][] pixels;
    private int width;
    private int height;
    private String comment;
    private float xScale;
    private float yScale;
    int platform;

    public BufferedImage mainProcess(InputStream is) throws IOException {
        int b;
        StringBuilder sb = new StringBuilder();
        while ((b = is.read()) != -1) {
            String s = "00000000" + Integer.toBinaryString(b);
            sb.append(s.substring(s.length() - 8));
        }
        this.comment = "";
        this.xScale = 1.0f;
        this.yScale = 1.0f;
        if (!RetroPic.isPic(sb.substring(0, 64))) {
            throw new IllegalArgumentException("unsupported type");
        }
        this.loadPic(sb.toString());
        return this.drawImage();
    }

    private void loadPic(String data) {
        String s;
        int pos = 16;
        ArrayList<Byte> commentBuffer = new ArrayList<Byte>();
        boolean hasHdExtension = false;
        int len = data.length();
        while ((pos += 8) <= len && !(s = data.substring(pos, pos + 8)).equals("00011010")) {
            commentBuffer.add((byte)Integer.parseInt(s, 2));
        }
        if (commentBuffer.size() != 0) {
            this.comment = RetroPic.comment(ByteUtil.toByteArray(commentBuffer));
            if (this.comment.startsWith("/MM/")) {
                if (this.comment.contains("XSS/")) {
                    this.xScale = 1.0f;
                }
                this.comment = this.comment.substring(this.comment.indexOf(":") + 1);
            }
            Debug.println((Level)Level.FINE, (Object)("COMMENT:\n" + this.comment));
        }
        while ((pos += 8) <= len) {
            if (!data.startsWith("00000000", pos)) continue;
            pos += 16;
            break;
        }
        s = data.substring(pos, pos + 4);
        int mode = Integer.parseInt(s, 2);
        s = data.substring(pos + 4, pos + 8);
        this.platform = Integer.parseInt(s, 2);
        Debug.printf((Level)Level.FINE, (String)"platform: %d, mode: %d", (Object[])new Object[]{this.platform, mode});
        switch (this.platform) {
            case 0: {
                this.xScale = 1.5f;
                break;
            }
            case 1: {
                boolean isHR = (mode & 1) != 0;
                boolean pseudo256 = (mode & 2) != 0;
                Debug.printf((Level)Level.FINE, (String)"isHR: %s, pseudo256: %s", (Object[])new Object[]{isHR, pseudo256});
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 15: {
                hasHdExtension = true;
                if (mode != 0) break;
                this.xScale = 1.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown platform: " + s);
            }
        }
        int depth = Integer.parseInt(data.substring(pos += 8, pos + 16), 2);
        Debug.println((Level)Level.FINE, (Object)("depth: " + depth));
        if (depth != 15 && depth != 16) {
            throw new IllegalArgumentException("unsupported color depth: " + depth);
        }
        this.width = Integer.parseInt(data.substring(pos += 16, pos + 16), 2);
        this.height = Integer.parseInt(data.substring(pos += 16, pos + 16), 2);
        pos += 16;
        Debug.printf((Level)Level.FINE, (String)"size: %dx%d", (Object[])new Object[]{this.width, this.height});
        int pixels = this.width * this.height;
        if (pixels == 0) {
            throw new IllegalArgumentException("no pixels");
        }
        if (this.platform == 1 && this.height == 200) {
            Debug.printf((Level)Level.FINE, (String)"set height 400", (Object[])new Object[0]);
            this.height = 400;
        }
        if (hasHdExtension) {
            Debug.printf((Level)Level.FINE, (String)"has extension", (Object[])new Object[0]);
            pos += 48;
        }
        this.ensureBuffer();
        String[] colorPalette = new String[128];
        int[] colorSub = new int[128];
        for (int i = 0; i < 128; ++i) {
            colorPalette[i] = "";
            colorSub[i] = 0;
        }
        colorPalette[0] = "000000000000000";
        Color color = null;
        Color color2 = null;
        int length = -1;
        StringBuilder lngs = new StringBuilder();
        int colnew = 0;
        ArrayList<Integer> chains = new ArrayList<Integer>();
        int state = 0;
        while (pos < len - 1) {
            String one = data.substring(pos, pos + 1);
            ++pos;
            switch (state) {
                case 0: {
                    lngs.append(one);
                    if (!one.equals("0")) break;
                    int lt = 0;
                    int ll = lngs.length();
                    for (int i = 0; i < ll; ++i) {
                        lt += (int)Math.pow(2.0, i);
                    }
                    length += (lt += Integer.parseInt(data.substring(pos, pos + ll), 2));
                    pos += ll;
                    lngs.setLength(0);
                    state = 1;
                    break;
                }
                case 1: {
                    String col;
                    ++colnew;
                    if (one.equals("0")) {
                        int c;
                        col = data.substring(pos, pos + depth);
                        int colold = colorSub[0];
                        for (c = 0; c < 128; ++c) {
                            if (colorPalette[c].isEmpty()) {
                                colorSub[c] = colnew;
                                colorPalette[c] = col;
                                break;
                            }
                            if (colorSub[c] >= colold) continue;
                            colold = colorSub[c];
                        }
                        if (c == 128) {
                            for (c = 0; c < 128; ++c) {
                                if (colorSub[c] != colold) continue;
                                colorSub[c] = colnew;
                                colorPalette[c] = col;
                                break;
                            }
                        }
                        pos += depth;
                    } else {
                        col = data.substring(pos, pos + 7);
                        colorSub[Integer.parseInt((String)col, (int)2)] = colnew;
                        col = colorPalette[Integer.parseInt(col, 2)];
                        pos += 7;
                    }
                    switch (depth) {
                        case 15: {
                            int r = RetroPic.convertColor(col.substring(5, 10), depth);
                            int g = RetroPic.convertColor(col.substring(0, 5), depth);
                            int b = RetroPic.convertColor(col.substring(10, 15), depth);
                            color = new Color(r, g, b);
                            break;
                        }
                        case 16: {
                            if (this.platform == 1) {
                                color = RetroPic.getG3R3B2Color(Integer.parseInt(col.substring(0, 8), 2));
                                color2 = RetroPic.getG3R3B2Color(Integer.parseInt(col.substring(8, 16), 2));
                                break;
                            }
                            int r = RetroPic.convertColor(col.substring(5, 10) + col.substring(15), depth);
                            int g = RetroPic.convertColor(col.substring(0, 5) + col.substring(15), depth);
                            int b = RetroPic.convertColor(col.substring(10, 15) + col.substring(15), depth);
                            color = new Color(r, g, b);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("depth: " + depth);
                        }
                    }
                    state = 2;
                    break;
                }
                case 2: {
                    if (one.equals("1")) {
                        int i = 0;
                        while (pos <= len) {
                            one = data.substring(pos, pos + 2);
                            pos += 2;
                            switch (one) {
                                case "01": {
                                    RetroPic.set(chains, i, -1);
                                    break;
                                }
                                case "10": {
                                    RetroPic.set(chains, i, 0);
                                    break;
                                }
                                case "11": {
                                    RetroPic.set(chains, i, 1);
                                    break;
                                }
                                case "00": {
                                    one = data.substring(pos, pos + 1);
                                    ++pos;
                                    if (one.equals("1")) {
                                        switch (data.substring(pos, pos + 1)) {
                                            case "0": {
                                                RetroPic.set(chains, i, -2);
                                                break;
                                            }
                                            case "1": {
                                                RetroPic.set(chains, i, 2);
                                            }
                                        }
                                        ++pos;
                                        break;
                                    }
                                    i = -1;
                                }
                            }
                            if (i == -1) break;
                            ++i;
                        }
                    }
                    int x = length % this.width;
                    int y = (int)Math.floor((float)length / (float)this.width);
                    this.pixels[x][y] = this.platform == 1 ? new Color[]{color, color2} : color;
                    Iterator iterator = chains.iterator();
                    while (iterator.hasNext()) {
                        int chain = (Integer)iterator.next();
                        x += chain;
                        ++y;
                        if (this.platform == 1) {
                            this.pixels[x][y] = new Color[]{color, color2};
                            continue;
                        }
                        this.pixels[x][y] = color;
                    }
                    chains.clear();
                    state = 0;
                }
            }
            if (length < pixels) continue;
            break;
        }
        Object prevColor = null;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.pixels[x][y] == null) {
                    this.pixels[x][y] = prevColor;
                    continue;
                }
                prevColor = this.pixels[x][y];
            }
        }
    }

    private static void set(List<Integer> l, int index, int value) {
        if (index < l.size()) {
            l.set(index, value);
        } else {
            for (int i = l.size(); i < index; ++i) {
                l.add(i, null);
            }
            l.add(index, value);
        }
    }

    private static int convertColor(String data, int colorDepth) {
        switch (colorDepth) {
            case 15: {
                return (int)Math.round((double)Integer.parseInt(data, 2) * 8.22);
            }
            case 16: {
                return (int)Math.round((double)Integer.parseInt(data, 2) * 4.04);
            }
        }
        throw new IllegalArgumentException(String.valueOf(colorDepth));
    }

    private static Color getG3R3B2Color(int c) {
        return new Color((c & 0x1C) * 73 >> 3 << 16 | (c >> 5) * 73 >> 1 << 8 | (c & 3) * 85);
    }

    private static String comment(byte[] ba) {
        int p = ByteUtil.indexOf((byte[])ba, (byte)0);
        return new String(ba, 0, p == -1 ? ba.length : p, Charset.forName("Shift_JIS"));
    }

    private BufferedImage drawImage() {
        BufferedImage image = new BufferedImage((int)((float)this.width * this.xScale), (int)((float)this.height * this.yScale), 1);
        Debug.printf((Level)Level.FINE, (String)"image: %dx%d (%dx%d)", (Object[])new Object[]{this.width, this.height, image.getWidth(), image.getHeight()});
        Graphics2D g2d = image.createGraphics();
        g2d.scale(this.xScale, this.yScale);
        if (this.platform == 1) {
            for (int y = 0; y < this.height / 2; ++y) {
                int x;
                for (x = 0; x < this.width / 2; ++x) {
                    g2d.setColor(((Color[])this.pixels[x][y])[1]);
                    g2d.fillRect(x * 2, y * 2, 1, 1);
                    g2d.setColor(((Color[])this.pixels[x][y])[0]);
                    g2d.fillRect(x * 2 + 1, y * 2, 1, 1);
                }
                for (x = 0; x < this.width / 2; ++x) {
                    g2d.setColor(((Color[])this.pixels[this.width / 2 + x][y])[1]);
                    g2d.fillRect(x * 2, y * 2 + 1, 1, 1);
                    g2d.setColor(((Color[])this.pixels[this.width / 2 + x][y])[0]);
                    g2d.fillRect(x * 2 + 1, y * 2 + 1, 1, 1);
                }
            }
        } else {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    if (this.pixels[x][y] == null) continue;
                    g2d.setColor((Color)this.pixels[x][y]);
                    g2d.fillRect(x, y, 1, 1);
                }
            }
        }
        return image;
    }

    private void ensureBuffer() {
        this.pixels = new Object[this.width][];
        for (int x = 0; x < this.width; ++x) {
            this.pixels[x] = new Object[this.height];
        }
    }

    private static boolean isPic(String s) {
        if (s.startsWith("01010000")) {
            return s.startsWith("0100100101000011", 8);
        }
        return false;
    }
}

