/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.pi;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Level;
import vavi.util.ByteUtil;
import vavi.util.Debug;

public class RetroPi {
    private Color[][] pixels;
    private int width;
    private int height;
    private String comment;
    private float xScale;
    private float yScale;

    public BufferedImage mainProcess(InputStream is) throws IOException {
        int b;
        StringBuilder sb = new StringBuilder();
        while ((b = is.read()) != -1) {
            String s = "00000000" + Integer.toBinaryString(b);
            sb.append(s.substring(s.length() - 8));
        }
        this.comment = "";
        this.xScale = 1.0f;
        this.yScale = 1.0f;
        if (!RetroPi.isPi(sb.substring(0, 64))) {
            throw new IllegalArgumentException("unsupported type");
        }
        this.loadPi(sb.toString());
        return this.drawImage();
    }

    private void loadPi(String data) {
        String b;
        int[] pos = new int[]{8};
        ArrayList<Byte> commentBuffer = new ArrayList<Byte>();
        int len = data.length();
        while ((pos[0] = pos[0] + 8) <= len && !(b = data.substring(pos[0], pos[0] + 8)).equals("00011010")) {
            commentBuffer.add((byte)Integer.parseInt(b, 2));
        }
        if (commentBuffer.size() != 0) {
            this.comment = RetroPi.comment(ByteUtil.toByteArray(commentBuffer));
            Debug.println((Level)Level.FINE, (Object)("COMMENT:\n" + this.comment));
        }
        while ((pos[0] = pos[0] + 8) <= len && !data.startsWith("00000000", pos[0])) {
        }
        pos[0] = pos[0] + 8;
        String platform = data.substring(pos[0], pos[0] + 1);
        pos[0] = pos[0] + 8;
        String buf = data.substring(pos[0], pos[0] + 16);
        if (!buf.equals("0000000000000000") && !buf.equals("0000000100000001")) {
            throw new IllegalArgumentException("wrong xScale ratio: " + buf);
        }
        pos[0] = pos[0] + 16;
        buf = data.substring(pos[0], pos[0] + 8);
        if (!buf.equals("00000100")) {
            throw new IllegalArgumentException("wrong plane number: " + buf);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            pos[0] = pos[0] + 8;
            sb.append((char)Integer.parseInt(data.substring(pos[0], pos[0] + 8), 2));
        }
        this.comment = sb + this.comment;
        Debug.println((Level)Level.FINE, (Object)("SAVER:\n" + this.comment));
        pos[0] = pos[0] + 8;
        int l = Integer.parseInt(data.substring(pos[0], pos[0] + 16), 2);
        pos[0] = pos[0] + 8;
        for (int i = 0; i < l; ++i) {
            pos[0] = pos[0] + 8;
        }
        pos[0] = pos[0] + 8;
        this.width = Integer.parseInt(data.substring(pos[0], pos[0] + 16), 2);
        pos[0] = pos[0] + 16;
        this.height = Integer.parseInt(data.substring(pos[0], pos[0] + 16), 2);
        if (this.width <= 2) {
            throw new IllegalArgumentException("wrong x size");
        }
        int xxCount = this.width * this.height;
        if (xxCount == 0) {
            throw new IllegalArgumentException("wrong y size");
        }
        this.height += 2;
        this.ensureBuffer();
        Color[] colorPalette = new Color[16];
        int[][] colorSub = new int[16][];
        for (int i = 0; i < 16; ++i) {
            int t = i;
            colorSub[i] = new int[16];
            for (int j = 0; j < 16; ++j) {
                colorSub[i][j] = t--;
                if (t != -1) continue;
                t = 15;
            }
        }
        if (platform.equals("0")) {
            pos[0] = pos[0] + 8;
            for (int c = 0; c < 16; ++c) {
                pos[0] = pos[0] + 8;
                int r = Integer.parseInt(data.substring(pos[0], pos[0] + 4), 2) * 17;
                pos[0] = pos[0] + 8;
                int g = Integer.parseInt(data.substring(pos[0], pos[0] + 4), 2) * 17;
                pos[0] = pos[0] + 8;
                int b2 = Integer.parseInt(data.substring(pos[0], pos[0] + 4), 2) * 17;
                colorPalette[c] = new Color(r, g, b2);
            }
            pos[0] = pos[0] + 8;
        } else {
            pos[0] = pos[0] + 16;
            colorPalette[0] = new Color(0, 0, 0);
            colorPalette[1] = new Color(0, 0, 112);
            colorPalette[2] = new Color(112, 0, 0);
            colorPalette[3] = new Color(112, 0, 112);
            colorPalette[4] = new Color(0, 112, 0);
            colorPalette[5] = new Color(0, 112, 112);
            colorPalette[6] = new Color(12, 112, 0);
            colorPalette[7] = new Color(112, 112, 112);
            colorPalette[8] = new Color(0, 0, 0);
            colorPalette[9] = new Color(0, 0, 240);
            colorPalette[10] = new Color(240, 0, 0);
            colorPalette[11] = new Color(240, 0, 240);
            colorPalette[12] = new Color(0, 240, 0);
            colorPalette[13] = new Color(0, 240, 240);
            colorPalette[14] = new Color(240, 240, 0);
            colorPalette[15] = new Color(240, 240, 240);
        }
        int[][] fieldBuffer = new int[this.width][this.height];
        int xx = this.width * 2;
        xxCount += xx;
        StringBuilder lngs = new StringBuilder();
        int[] col = new int[2];
        int[] o00ck = new int[2];
        Object prevPos = "";
        int state = 0;
        int[] prevColor = new int[1];
        for (int i = 0; i < 2; ++i) {
            col[i] = o00ck[i] = RetroPi.getPalette(data, pos, prevColor, colorSub);
            if (col[i] != -1) continue;
            throw new IllegalStateException("wrong color");
        }
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < this.width; x += 2) {
                fieldBuffer[x][y] = col[0];
                fieldBuffer[x + 1][y] = col[1];
            }
        }
        Object position = null;
        while (pos[0] <= len) {
            switch (state) {
                case 0: {
                    position = data.substring(pos[0], pos[0] + 2);
                    pos[0] = pos[0] + 2;
                    if (((String)position).equals("11")) {
                        position = (String)position + data.substring(pos[0], pos[0] + 1);
                        pos[0] = pos[0] + 1;
                    }
                    if (!((String)position).equals(prevPos)) {
                        state = 1;
                        break;
                    }
                    state = 2;
                    break;
                }
                case 1: {
                    int length;
                    String b3 = data.substring(pos[0], pos[0] + 1);
                    pos[0] = pos[0] + 1;
                    lngs.append(b3);
                    if (!b3.equals("0")) break;
                    if (lngs.toString().equals("0")) {
                        length = 1;
                    } else {
                        int ll = lngs.length() - 1;
                        length = (int)Math.pow(2.0, ll);
                        length += Integer.parseInt(data.substring(pos[0], pos[0] + ll), 2);
                        pos[0] = pos[0] + ll;
                    }
                    int offset = 0;
                    switch (position) {
                        case "00": {
                            if (o00ck[0] == o00ck[1]) {
                                offset = -2;
                                break;
                            }
                            offset = -4;
                            break;
                        }
                        case "01": {
                            offset = -this.width;
                            break;
                        }
                        case "10": {
                            offset = -this.width * 2;
                            break;
                        }
                        case "110": {
                            offset = -this.width + 1;
                            break;
                        }
                        case "111": {
                            offset = -this.width - 1;
                        }
                    }
                    for (int i = 0; i < length * 2; ++i) {
                        int x = (xx + i) % this.width;
                        int y = (int)Math.floor((float)(xx + i) / (float)this.width);
                        int ox = (xx + i + offset) % this.width;
                        int oy = (int)Math.floor((float)(xx + i + offset) / (float)this.width);
                        fieldBuffer[x][y] = fieldBuffer[ox][oy];
                        prevColor[0] = fieldBuffer[x][y];
                        o00ck[0] = o00ck[1];
                        o00ck[1] = fieldBuffer[x][y];
                    }
                    xx += length * 2;
                    lngs = new StringBuilder();
                    prevPos = position;
                    state = 0;
                    break;
                }
                case 2: {
                    for (int i = 0; i < 2; ++i) {
                        col[i] = o00ck[i] = RetroPi.getPalette(data, pos, prevColor, colorSub);
                        if (col[i] == -1) {
                            throw new IllegalStateException("wring color");
                        }
                        int x = xx % this.width;
                        int y = (int)Math.floor((float)xx / (float)this.width);
                        fieldBuffer[x][y] = col[i];
                        ++xx;
                    }
                    prevPos = "";
                    state = 3;
                    break;
                }
                case 3: {
                    String b3 = data.substring(pos[0], pos[0] + 1);
                    pos[0] = pos[0] + 1;
                    state = b3.equals("0") ? 0 : 2;
                }
            }
            if (xx < xxCount) continue;
        }
        this.height -= 2;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.pixels[x][y] = colorPalette[fieldBuffer[x][y + 2]];
            }
        }
    }

    private static int getPalette(String data, int[] pos, int[] prevColor, int[][] colorSub) {
        int palette;
        String two = data.substring(pos[0], pos[0] + 2);
        pos[0] = pos[0] + 2;
        switch (two) {
            case "10": {
                palette = 0;
                break;
            }
            case "11": {
                palette = 1;
                break;
            }
            case "00": {
                String b = data.substring(pos[0], pos[0] + 1);
                pos[0] = pos[0] + 1;
                if (b.equals("0")) {
                    palette = 2;
                    break;
                }
                palette = 3;
                break;
            }
            case "01": {
                String b = data.substring(pos[0], pos[0] + 1);
                pos[0] = pos[0] + 1;
                if (b.equals("0")) {
                    palette = Integer.parseInt(data.substring(pos[0], pos[0] + 2), 2) + 4;
                    pos[0] = pos[0] + 2;
                    break;
                }
                palette = Integer.parseInt(data.substring(pos[0], pos[0] + 3), 2) + 8;
                pos[0] = pos[0] + 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("never happen");
            }
        }
        int prev = colorSub[prevColor[0]][palette];
        colorSub[prevColor[0]] = RetroPi.splice(colorSub[prevColor[0]], palette, 1);
        colorSub[prevColor[0]] = RetroPi.unshift(colorSub[prevColor[0]], prev);
        prevColor[0] = prev;
        return prev;
    }

    private static int[] splice(int[] a, int start, int deleteCount) {
        int[] n = new int[a.length - deleteCount];
        System.arraycopy(a, 0, n, 0, start);
        System.arraycopy(a, start + deleteCount, n, start, a.length - (start + deleteCount));
        return n;
    }

    private static int[] unshift(int[] a, int v) {
        int[] n = new int[a.length + 1];
        System.arraycopy(a, 0, n, 1, a.length);
        n[0] = v;
        return n;
    }

    private static String comment(byte[] ba) {
        int p = ByteUtil.indexOf((byte[])ba, (byte)0);
        return new String(ba, 0, p == -1 ? ba.length : p, Charset.forName("Shift_JIS"));
    }

    private BufferedImage drawImage() {
        BufferedImage image = new BufferedImage((int)((float)this.width * this.xScale), (int)((float)this.height * this.yScale), 1);
        Debug.printf((Level)Level.FINE, (String)"image: %dx%d (%dx%d)", (Object[])new Object[]{this.width, this.height, image.getWidth(), image.getHeight()});
        Graphics2D g2d = image.createGraphics();
        g2d.scale(this.xScale, this.yScale);
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.pixels[x][y] == null) continue;
                g2d.setColor(this.pixels[x][y]);
                g2d.fillRect(x, y, 1, 1);
            }
        }
        return image;
    }

    private void ensureBuffer() {
        this.pixels = new Color[this.width][];
        for (int x = 0; x < this.width; ++x) {
            this.pixels[x] = new Color[this.height];
        }
    }

    private static boolean isPi(String s) {
        if (s.startsWith("01010000")) {
            return s.startsWith("01101001", 8);
        }
        return false;
    }
}

