/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.maki;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Level;
import vavi.util.ByteUtil;
import vavi.util.Debug;

public class RetroMaki {
    private Color[][] pixels;
    private int width;
    private int height;
    private String comment;
    private float xScale;
    private float yScale;

    public BufferedImage mainProcess(InputStream is) throws IOException {
        int b;
        StringBuilder sb = new StringBuilder();
        while ((b = is.read()) != -1) {
            String s = "00000000" + Integer.toBinaryString(b);
            sb.append(s.substring(s.length() - 8));
        }
        this.comment = "";
        this.xScale = 1.0f;
        this.yScale = 1.0f;
        if (!RetroMaki.isMaki(sb.substring(0, 64))) {
            throw new IllegalArgumentException("unsupported type");
        }
        this.loadMaki(sb.toString());
        return this.drawImage();
    }

    private static String comment(byte[] ba) {
        int p = ByteUtil.indexOf((byte[])ba, (byte)0);
        return new String(ba, 0, p == -1 ? ba.length : p, Charset.forName("Shift_JIS"));
    }

    private void loadMaki(String data) {
        String b;
        int pos;
        int xorLine = data.startsWith("01000001", 48) ? 2 : 4;
        ArrayList<Byte> commentBuffer = new ArrayList<Byte>();
        for (pos = 64; pos < 256 && !(b = data.substring(pos, pos + 8)).equals("00011010"); pos += 8) {
            commentBuffer.add((byte)Integer.parseInt(b, 2));
        }
        if (commentBuffer.size() != 0) {
            this.comment = "SAVER/USER:\n" + RetroMaki.comment(ByteUtil.toByteArray(commentBuffer));
            Debug.println((Level)Level.FINE, (Object)("\n" + this.comment));
        }
        int flagB = 8768;
        int pixel = flagB + Integer.parseInt(data.substring(256, 272), 2) * 8;
        if (data.charAt(319) != '0') {
            throw new IllegalStateException("wrong 319-320");
        }
        if (!data.startsWith("00000000000000000000000000000000", 320)) {
            throw new IllegalStateException("wrong 320-336");
        }
        if (!data.startsWith("00000010100000000000000110010000", 352)) {
            throw new IllegalStateException("wrong 352-382");
        }
        this.width = 640;
        this.height = 400;
        this.ensureBuffer();
        Color[] colorPalette = new Color[16];
        pos = 384;
        for (int i = 0; i < 16; ++i) {
            int r = Integer.parseInt(data.substring(pos + 8, pos + 12), 2) * 17;
            int g = Integer.parseInt(data.substring(pos, pos + 4), 2) * 17;
            int b2 = Integer.parseInt(data.substring(pos + 16, pos + 20), 2) * 17;
            colorPalette[i] = new Color(r, g, b2);
            pos += 24;
        }
        String[][] fieldBuffer = new String[this.width][this.height];
        String[] lines = new String[]{"", "", "", ""};
        int x = 0;
        int y = 0;
        for (int i = 768; i < 8768; ++i) {
            int l;
            if (data.charAt(i) == '0') {
                l = 0;
                while (l < 4) {
                    int n = l++;
                    lines[n] = lines[n] + "0000";
                }
            } else {
                l = 0;
                while (l < 4) {
                    int n = l++;
                    lines[n] = lines[n] + data.substring(flagB, flagB + 4);
                    flagB += 4;
                }
            }
            if (lines[0].length() != 320) continue;
            for (l = 0; l < 4; ++l) {
                for (int p = 0; p < 320; ++p) {
                    if (lines[l].charAt(p) == '0') {
                        fieldBuffer[x + 1][y + l] = "0000";
                        fieldBuffer[x][y + l] = "0000";
                    } else {
                        fieldBuffer[x][y + l] = data.substring(pixel, pixel + 4);
                        fieldBuffer[x + 1][y + l] = data.substring(pixel += 4, pixel + 4);
                        pixel += 4;
                    }
                    x += 2;
                }
                x = 0;
            }
            y += 4;
            lines = new String[]{"", "", "", ""};
        }
        for (y = xorLine; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                int xorBuf = Integer.parseInt(fieldBuffer[x][y], 2) ^ Integer.parseInt(fieldBuffer[x][y - xorLine], 2);
                String s = "0000" + Integer.toBinaryString(xorBuf);
                fieldBuffer[x][y] = s.substring(s.length() - 4);
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                this.pixels[x][y] = colorPalette[Integer.parseInt(fieldBuffer[x][y], 2)];
            }
        }
    }

    private BufferedImage drawImage() {
        BufferedImage image = new BufferedImage((int)((float)this.width * this.xScale), (int)((float)this.height * this.yScale), 1);
        Debug.printf((Level)Level.FINE, (String)"image: %dx%d (%dx%d)", (Object[])new Object[]{this.width, this.height, image.getWidth(), image.getHeight()});
        Graphics2D g2d = image.createGraphics();
        g2d.scale(this.xScale, this.yScale);
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.pixels[x][y] == null) continue;
                g2d.setColor(this.pixels[x][y]);
                g2d.fillRect(x, y, 1, 1);
            }
        }
        return image;
    }

    private void ensureBuffer() {
        this.pixels = new Color[this.width][];
        for (int x = 0; x < this.width; ++x) {
            this.pixels[x] = new Color[this.height];
        }
    }

    private static boolean isMaki(String s) {
        if (s.startsWith("01001101") && s.startsWith("01000001010010110100100100110000", 8)) {
            String sub = s.substring(40, 64);
            return sub.equals("001100010100000100100000") || sub.equals("001100010100001000100000");
        }
        return false;
    }
}

