/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.mag;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import vavi.io.SeekableDataInput;
import vavi.util.Debug;

public class Mag {
    private Mag() {
    }

    private static int pack(int r, int g, int b) {
        return 0xFF000000 | g << 16 | r << 8 | b;
    }

    public static BufferedImage load(SeekableDataInput<?> sdi) throws IOException {
        byte[] maki02 = new byte[8];
        sdi.readFully(maki02);
        if (!Arrays.equals(maki02, "MAKI02  ".getBytes())) {
            throw new IllegalArgumentException(" is Not MAG Format.");
        }
        int headerOffset = 30;
        sdi.position((long)headerOffset);
        while (26 != sdi.readByte()) {
            ++headerOffset;
        }
        Debug.println((Level)Level.FINE, (Object)("headerOffset: " + ++headerOffset));
        sdi.position((long)headerOffset);
        class MagInfo {
            int top;
            int platform;
            int flags;
            int mode;
            int sx;
            int sy;
            int ex;
            int ey;
            int flagAOffset;
            int flagBOffset;
            int flagBSize;
            int pixelOffset;
            int pixelSize;
            int flagASize;
            int colors;
            int pixelUnitLog;
            int width;
            int height;
            int flagSize;

            MagInfo() {
            }

            void init() {
                this.flagASize = this.flagBOffset - this.flagAOffset;
                this.colors = (this.mode & 0x80) != 0 ? 256 : 16;
                this.pixelUnitLog = (this.mode & 0x80) != 0 ? 1 : 2;
                this.width = (this.ex & 0xFFF8 | 7) - (this.sx & 0xFFF8) + 1;
                this.height = this.ey - this.sy + 1;
                this.flagSize = this.width >> this.pixelUnitLog + 1;
            }

            public String toString() {
                return "MagInfo{top=" + this.top + ", platform=" + this.platform + ", flags=" + this.flags + ", mode=" + this.mode + ", sx=" + this.sx + ", sy=" + this.sy + ", ex=" + this.ex + ", ey=" + this.ey + ", flagAOffset=" + this.flagAOffset + ", flagBOffset=" + this.flagBOffset + ", flagBSize=" + this.flagBSize + ", pixelOffset=" + this.pixelOffset + ", pixelSize=" + this.pixelSize + ", flagASize=" + this.flagASize + ", colors=" + this.colors + ", pixelUnitLog=" + this.pixelUnitLog + ", width=" + this.width + ", height=" + this.height + ", flagSize=" + this.flagSize + "}";
            }
        }
        MagInfo mag = new MagInfo();
        mag.top = sdi.readUnsignedByte();
        mag.platform = sdi.readUnsignedByte();
        mag.flags = sdi.readUnsignedByte();
        mag.mode = sdi.readUnsignedByte();
        mag.sx = sdi.readUnsignedShort();
        mag.sy = sdi.readUnsignedShort();
        mag.ex = sdi.readUnsignedShort();
        mag.ey = sdi.readUnsignedShort();
        mag.flagAOffset = sdi.readInt();
        mag.flagBOffset = sdi.readInt();
        mag.flagBSize = sdi.readInt();
        mag.pixelOffset = sdi.readInt();
        mag.pixelSize = sdi.readInt();
        mag.init();
        Debug.println((Level)Level.FINE, (Object)mag);
        byte[] data = new byte[mag.width * 16];
        byte[] palette = new byte[mag.colors * 3];
        sdi.readFully(palette, 0, mag.colors * 3);
        Debug.printf((Level)Level.FINE, (String)"palette: pos: %d, len: %d", (Object[])new Object[]{headerOffset + 32, mag.colors * 3});
        byte[] flagABuf = new byte[mag.flagASize];
        sdi.position((long)(headerOffset + mag.flagAOffset));
        sdi.readFully(flagABuf, 0, mag.flagASize);
        Debug.printf((Level)Level.FINE, (String)"flagA: pos: %d, len: %d", (Object[])new Object[]{headerOffset + mag.flagAOffset, mag.flagASize});
        byte[] flagBBuf = new byte[mag.flagBSize];
        sdi.position((long)(headerOffset + mag.flagBOffset));
        sdi.readFully(flagBBuf, 0, mag.flagBSize);
        Debug.printf((Level)Level.FINE, (String)"flagB: pos: %d, len: %d", (Object[])new Object[]{headerOffset + mag.flagBOffset, mag.flagBSize});
        byte[] flagBuf = new byte[mag.flagSize];
        int pixelBufSize = 4096;
        int halfBufSize = 2048;
        byte[] pixel = new byte[4096];
        sdi.position((long)(headerOffset + mag.pixelOffset));
        int src = 0;
        sdi.readFully(pixel, src, 4096 - src);
        Debug.printf((Level)Level.FINE, (String)"pixel: pos: %d, len: %d", (Object[])new Object[]{headerOffset + mag.pixelOffset, 4096 - src});
        int flagAPos = 0;
        int flagBPos = 0;
        int dest = 0;
        int[] copyX = new int[]{0, 1, 2, 4, 0, 1, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0};
        int[] copyY = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 2, 4, 4, 4, 8, 8, 8, 16};
        int[] copyPos = new int[16];
        for (int i = 0; i < 16; ++i) {
            copyPos[i] = -(copyY[i] * mag.width + (copyX[i] << mag.pixelUnitLog));
        }
        int copySize = 1 << mag.pixelUnitLog;
        int mask = 128;
        Debug.printf((Level)Level.FINE, (String)"width: %d, height: %d", (Object[])new Object[]{mag.width, mag.height});
        int destDiff = 0;
        BufferedImage image = new BufferedImage(mag.width, mag.height, 2);
        int[] buf = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < mag.height; ++y) {
            if (0 != dest && 0 == (y & 1)) {
                int dy = y - 2 & 0xF;
                for (int x = 0; x < mag.width >> 1 && x * 2 + 1 + (dy + 1) * mag.width <= dest; ++x) {
                    int c1 = (data[x * 2 + dy * mag.width] & 0xFF) * 3;
                    int c2 = (data[x * 2 + 1 + dy * mag.width] & 0xFF) * 3;
                    int c3 = (data[x * 2 + (dy + 1) * mag.width] & 0xFF) * 3;
                    int c4 = (data[x * 2 + 1 + (dy + 1) * mag.width] & 0xFF) * 3;
                    buf[x * 2 + y * mag.width] = Mag.pack(palette[c1] & 0xFF, palette[c1 + 1] & 0xFF, palette[c1 + 2] & 0xFF);
                    buf[x * 2 + 1 + y * mag.width] = Mag.pack(palette[c2] & 0xFF, palette[c2 + 1] & 0xFF, palette[c2 + 2] & 0xFF);
                    buf[x * 2 + (y + 1) * mag.width] = Mag.pack(palette[c3] & 0xFF, palette[c3 + 1] & 0xFF, palette[c3 + 2] & 0xFF);
                    buf[x * 2 + 1 + (y + 1) * mag.width] = Mag.pack(palette[c4] & 0xFF, palette[c4 + 1] & 0xFF, palette[c4 + 2] & 0xFF);
                }
                if ((y & 0xF) == 0) {
                    destDiff = dest;
                    dest = 0;
                }
            }
            int x = 0;
            int xEnd = mag.flagSize;
            do {
                if ((flagABuf[flagAPos] & mask) != 0) {
                    flagBuf[x] = (byte)(flagBuf[x] ^ flagBBuf[flagBPos++]);
                }
                if ((mask >>= 1) != 0) continue;
                mask = 128;
                ++flagAPos;
            } while (++x < xEnd);
            x = 0;
            xEnd <<= 1;
            do {
                int v = flagBuf[x >> 1] & 0xFF;
                v = (x & 1) != 0 ? (v &= 0xF) : (v >>= 4);
                if (v == 0) {
                    if (src == 4096) {
                        sdi.readFully(pixel, 0, 4096);
                        src = 0;
                    }
                    if (mag.colors == 16) {
                        byte tmp = pixel[src];
                        data[dest + 0] = (byte)(tmp >> 4 & 0xF);
                        data[dest + 1] = (byte)(tmp & 0xF);
                        tmp = pixel[src + 1];
                        data[dest + 2] = (byte)(tmp >> 4 & 0xF);
                        data[dest + 3] = (byte)(tmp & 0xF);
                        dest += 4;
                        src += 2;
                        continue;
                    }
                    System.arraycopy(pixel, src, data, dest, 2);
                    dest += 2;
                    src += 2;
                    continue;
                }
                int copySrc = dest + copyPos[v];
                if (copySrc < 0) {
                    copySrc += destDiff;
                }
                System.arraycopy(data, copySrc, data, dest, copySize);
                dest += copySize;
            } while (++x < xEnd);
        }
        return image;
    }
}

