/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.ico;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import vavi.awt.image.bmp.WindowsBitmap;
import vavi.awt.image.bmp.WindowsBitmapImageSource;
import vavi.awt.image.ico.WindowsIcon;
import vavi.awt.image.ico.WindowsIconDevice;

public class WindowsIconImageSource
implements ImageProducer {
    private WindowsBitmapImageSource bitmap;
    private WindowsIcon[] icons;
    private int deviceId = 0;
    private BufferedImage image;
    private ImageConsumer ic;
    private Map<String, WindowsBitmapImageSource> bitmapCache = new HashMap<String, WindowsBitmapImageSource>();

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        if (this.bitmap != null) {
            this.bitmap.addConsumer(ic);
        } else {
            this.ic = ic;
            if (this.ic != null) {
                int width = this.image.getWidth();
                int height = this.image.getHeight();
                ColorModel cm = this.image.getColorModel();
                ic.setDimensions(width, height);
                ic.setProperties(new Hashtable());
                ic.setColorModel(cm);
                ic.setHints(30);
                int[] buf = this.image.getRGB(0, 0, width, height, null, 0, width);
                ic.setPixels(0, 0, width, height, ColorModel.getRGBdefault(), buf, 0, width);
                ic.imageComplete(3);
            }
            this.ic = null;
        }
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        if (this.bitmap != null) {
            this.bitmap.addConsumer(ic);
        } else {
            this.addConsumer(ic);
        }
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        if (this.bitmap != null) {
            return this.bitmap.isConsumer(ic);
        }
        return ic == this.ic;
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        if (this.bitmap != null) {
            this.bitmap.removeConsumer(ic);
        } else if (this.ic == ic) {
            this.ic = null;
        }
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getDeviceCount() {
        return this.icons.length;
    }

    public void changeDevice(WindowsIconDevice device) {
        for (int i = 0; i < this.icons.length; ++i) {
            if (this.icons[i].getDevice().getWidth() != device.getWidth() || this.icons[i].getDevice().getHeight() != device.getHeight() || this.icons[i].getDevice().getColors() != device.getColors()) continue;
            this.changeDevice(i);
        }
        throw new NoSuchElementException(String.valueOf(device));
    }

    public void changeDevice(int id) {
        if (id >= 0 && id < this.icons.length) {
            this.deviceId = id;
            if (this.bitmapCache.containsKey(String.valueOf(id))) {
                this.bitmap = this.bitmapCache.get(String.valueOf(id));
            } else if (this.icons[id].getBitmap() == null) {
                this.image = this.icons[id].getImage();
            } else {
                this.bitmap = new WindowsBitmapImageSource(this.icons[id].getBitmap());
                this.bitmapCache.put(String.valueOf(id), this.bitmap);
            }
        } else {
            throw new IndexOutOfBoundsException(String.valueOf(id));
        }
    }

    public WindowsIconImageSource(InputStream in) throws IOException {
        this.icons = WindowsIcon.readFrom(in);
        this.changeDevice(0);
    }

    public WindowsBitmap getWindowsBitmap() {
        return this.bitmap.getWindowsBitmap();
    }
}

