/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.ico;

import java.awt.Point;
import java.io.IOException;
import vavi.io.LittleEndianDataInputStream;
import vavi.util.Debug;

public class WindowsIconDevice {
    private int width;
    private int height;
    private int colors;
    private int hotspotX;
    private int hotspotY;
    private int size;
    private int offset;

    private WindowsIconDevice() {
    }

    public WindowsIconDevice(int width, int height, int colors) {
        this.width = width;
        this.height = height;
        this.colors = colors;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getColors() {
        return this.colors;
    }

    public void setColors(int colors) {
        this.colors = colors;
    }

    public int getSize() {
        return this.size;
    }

    public int getOffset() {
        return this.offset;
    }

    public Point getHotspot() {
        return new Point(this.hotspotX, this.hotspotY);
    }

    public String toString() {
        return " width: " + this.width + ", height: " + this.height + ", colors: " + this.colors + ", hotspot x: " + this.hotspotX + ", hotspot y: " + this.hotspotY + ", size: " + this.size + ", offset: " + this.offset;
    }

    public static WindowsIconDevice[] readFrom(LittleEndianDataInputStream lin, int number) throws IOException {
        WindowsIconDevice[] iconDevices = new WindowsIconDevice[number];
        for (int i = 0; i < number; ++i) {
            iconDevices[i] = new WindowsIconDevice();
            iconDevices[i].width = lin.read();
            iconDevices[i].height = lin.read();
            iconDevices[i].colors = lin.read();
            lin.readByte();
            iconDevices[i].hotspotX = lin.readShort();
            iconDevices[i].hotspotY = lin.readShort();
            iconDevices[i].size = lin.readInt();
            iconDevices[i].offset = lin.readInt();
            Debug.println((Object)iconDevices[i]);
        }
        return iconDevices;
    }
}

