/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.ico;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import vavi.awt.image.bmp.WindowsBitmap;
import vavi.awt.image.ico.WindowsIconDevice;
import vavi.io.LittleEndianDataInputStream;
import vavi.util.Debug;

public class WindowsIcon {
    private WindowsIconDevice device;
    private WindowsBitmap bitmap;
    private BufferedImage image;
    private byte[] mask;

    public WindowsIcon(WindowsIconDevice device, WindowsBitmap bitmap) {
        this.device = device;
        this.bitmap = bitmap;
        this.createMask();
    }

    public WindowsIcon(WindowsIconDevice device, BufferedImage image) {
        this.device = device;
        this.image = image;
    }

    public WindowsIconDevice getDevice() {
        return this.device;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public WindowsBitmap getBitmap() {
        return this.bitmap;
    }

    public byte[] getMask() {
        return this.mask;
    }

    private void createMask() {
        int off = this.bitmap.getImageSize() + this.bitmap.getOffset();
        int size = this.bitmap.getSize() - off;
        byte[] buf = new byte[size];
        for (int i = 0; i < size; ++i) {
            buf[i] = this.bitmap.getBitmap()[this.bitmap.getImageSize() + i];
        }
        this.mask = new byte[this.bitmap.getWidth() / 8 * this.bitmap.getHeight()];
        int m = (this.bitmap.getWidth() / 8 + 3) / 4 * 4;
        int i = 0;
        block1: for (int y = this.bitmap.getHeight() - 1; y >= 0; --y) {
            for (int x = 0; x < m; ++x) {
                if (x >= this.bitmap.getWidth() / 8) continue;
                if (i >= size) break block1;
                this.mask[i++] = buf[y * m + x];
            }
        }
    }

    private static WindowsIcon readIcon(LittleEndianDataInputStream lin, WindowsIconDevice iconDevice) throws IOException {
        int offset = iconDevice.getOffset();
        int size = iconDevice.getSize();
        if (iconDevice.getWidth() == 0 && iconDevice.getHeight() == 0) {
            byte[] buf = new byte[size];
            DataInputStream dis = new DataInputStream((InputStream)lin);
            dis.readFully(buf);
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            BufferedImage image = ImageIO.read(bais);
            Debug.println((Object)image);
            return new WindowsIcon(iconDevice, image);
        }
        return new WindowsIcon(iconDevice, WindowsBitmap.readFrom(lin, offset, size));
    }

    public static WindowsIcon[] readFrom(InputStream in) throws IOException {
        LittleEndianDataInputStream lin = new LittleEndianDataInputStream(in);
        Header h = Header.readFrom(lin);
        Debug.println((Object)h);
        WindowsIcon[] icons = new WindowsIcon[h.number];
        WindowsIconDevice[] iconDevices = WindowsIconDevice.readFrom(lin, h.number);
        for (int i = 0; i < h.number; ++i) {
            icons[i] = WindowsIcon.readIcon(lin, iconDevices[i]);
        }
        return icons;
    }

    private static final class Header {
        int type;
        int number;

        private Header() {
        }

        static Header readFrom(LittleEndianDataInputStream lin) throws IOException {
            Header h = new Header();
            byte dummy = lin.readByte();
            dummy = lin.readByte();
            h.type = lin.readShort();
            h.number = lin.readShort();
            return h;
        }

        public String toString() {
            return "type: " + this.type + ", has: " + this.number;
        }
    }
}

