/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.gif;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import vavi.awt.image.gif.NonLzwGifDecoder;
import vavi.io.LittleEndianDataInputStream;
import vavi.util.Debug;

public class GifImage {
    private static NonLzwGifDecoder decoder = new NonLzwGifDecoder();
    private GifHeader header;
    private GifRGB[] globalColorTable;
    private List<InternalImage> images = new ArrayList<InternalImage>();
    private List<Map<Integer, ExtentionBlock>> extentionBlocks = new ArrayList<Map<Integer, ExtentionBlock>>();

    private static GifRGB[] readColorTable(LittleEndianDataInputStream dis, int sizeOfColorTable) throws IOException {
        int size = (int)Math.pow(2.0, sizeOfColorTable + 1);
        GifRGB[] colorTable = new GifRGB[size];
        for (int i = 0; i < size; ++i) {
            colorTable[i] = GifRGB.readFrom(dis);
        }
        return colorTable;
    }

    public GraphicControlExtension getGraphicControlExtension(int index) {
        if (this.extentionBlocks.get(index).containsKey(249)) {
            ExtentionBlock extentionBlock = this.extentionBlocks.get(index).get(249);
            GraphicControlExtension extention = new GraphicControlExtension();
            byte[] data = extentionBlock.subBlocks.get(0);
            extention.packedFields = data[0] & 0xFF;
            extention.delayTime = data[1] & 0xFF | data[2] << 8 & 0xFF00;
            extention.transparentColorIndex = data[3] & 0xFF;
            return extention;
        }
        return null;
    }

    public int getWidth(int index) {
        return this.images.get((int)index).imageDescriptor.width;
    }

    public int getHeight(int index) {
        return this.images.get((int)index).imageDescriptor.height;
    }

    public ColorModel getColorModel(int index) {
        InternalImage image = this.images.get(index);
        int bits = image.sizeOfColorTable + 1;
        int usedColor = (int)Math.pow(2.0, bits);
        byte[] reds = new byte[usedColor];
        byte[] greens = new byte[usedColor];
        byte[] blues = new byte[usedColor];
        for (int i = 0; i < usedColor; ++i) {
            blues[i] = image.localColorTable[i].blue;
            greens[i] = image.localColorTable[i].green;
            reds[i] = image.localColorTable[i].red;
        }
        GraphicControlExtension graphicControlExtention = this.getGraphicControlExtension(index);
        if (graphicControlExtention != null && graphicControlExtention.hasTransparentColor()) {
            return new IndexColorModel(bits, usedColor, reds, greens, blues, graphicControlExtention.transparentColorIndex);
        }
        return new IndexColorModel(bits, usedColor, reds, greens, blues);
    }

    public byte[] getPixels(int index) {
        return this.images.get((int)index).tableBasedImageData;
    }

    public ImageDescriptor getImageDescriptor(int index) {
        return this.images.get((int)index).imageDescriptor;
    }

    public int getNumImages() {
        return this.images.size();
    }

    public static GifImage readFrom(InputStream is) throws IOException {
        LittleEndianDataInputStream dis = new LittleEndianDataInputStream(is);
        GifImage gifImage = new GifImage();
        gifImage.header = GifHeader.readFrom(dis);
        int sizeOfGlobalColorTable = gifImage.header.getSizeOfGlobalColorTable();
        if (gifImage.header.hasGlobalColorTable()) {
            gifImage.globalColorTable = GifImage.readColorTable(dis, sizeOfGlobalColorTable);
        }
        while (true) {
            int blockType;
            if ((blockType = dis.read()) == 44) {
                InternalImage image = InternalImage.readFrom(dis, sizeOfGlobalColorTable, gifImage.globalColorTable);
                gifImage.images.add(image);
                continue;
            }
            if (blockType == 33) {
                ExtentionBlock extentionBlock = ExtentionBlock.readFrom(dis);
                if (gifImage.extentionBlocks.size() == gifImage.images.size()) {
                    HashMap<Integer, ExtentionBlock> extentionBlocks = new HashMap<Integer, ExtentionBlock>();
                    extentionBlocks.put(extentionBlock.extentionType, extentionBlock);
                    gifImage.extentionBlocks.add(extentionBlocks);
                    continue;
                }
                gifImage.extentionBlocks.get(gifImage.images.size()).put(extentionBlock.extentionType, extentionBlock);
                continue;
            }
            if (blockType == 59) break;
            if (blockType == -1) {
                Debug.println((Object)"unexpected eof");
                break;
            }
            Debug.println((Object)String.format("%02x: unknown block type", blockType));
        }
        if (gifImage.images.size() == 0) {
            throw new IllegalStateException("no image");
        }
        return gifImage;
    }

    public byte[] loadMonoColor(int index) {
        int width = this.getWidth(index);
        int height = this.getHeight(index);
        byte[] buffer = this.getPixels(index);
        byte[] vram = new byte[width * height];
        int count = 0;
        int skip = (width + 7) / 8 % 4 != 0 ? 4 - (width + 7) / 8 % 4 : 0;
        for (int j = 0; j < height; ++j) {
            int ofs = (height - 1 - j) * width;
            int d = 0;
            for (int i = 0; i < width / 8; ++i) {
                byte b = buffer[count++];
                int mask = 128;
                for (int k = 0; k < 8; ++k) {
                    vram[ofs + d++] = (byte)((b & mask) >> 7 - k);
                    mask >>= 1;
                }
            }
            if (width % 8 != 0) {
                byte b = buffer[count++];
                int mask = 128;
                for (int k = 0; k < width % 8; ++k) {
                    vram[ofs + d++] = (byte)((b & mask) >> 7 - k);
                    mask >>= 1;
                }
            }
            count += skip;
        }
        return vram;
    }

    public byte[] load16Color(int index) {
        int width = this.getWidth(index);
        int height = this.getHeight(index);
        byte[] buffer = this.getPixels(index);
        byte[] vram = new byte[width * height];
        int count = 0;
        int skip = (width + 1) / 2 % 4 != 0 ? 4 - (width + 1) / 2 % 4 : 0;
        for (int j = 0; j < height; ++j) {
            int ofs = (height - 1 - j) * width;
            int d = 0;
            for (int i = 0; i < width / 2; ++i) {
                byte b = buffer[count++];
                vram[ofs + d++] = (byte)((b & 0xF0) >> 4);
                vram[ofs + d++] = (byte)(b & 0xF);
            }
            if (width % 2 != 0) {
                byte b = buffer[count++];
                vram[ofs + d] = (byte)((b & 0xF0) >> 4);
            }
            count += skip;
        }
        return vram;
    }

    public byte[] load256Color(int index) {
        int width = this.getWidth(index);
        int height = this.getHeight(index);
        byte[] buffer = this.getPixels(index);
        byte[] vram = new byte[width * height];
        int count = 0;
        int skip = width % 4 != 0 ? 4 - width % 4 : 0;
        for (int j = 0; j < height; ++j) {
            int ofs = (height - 1 - j) * width;
            for (int i = 0; i < width; ++i) {
                vram[ofs + i] = buffer[count++];
            }
            count += skip;
        }
        return vram;
    }

    private static class GifRGB {
        byte red;
        byte green;
        byte blue;

        private GifRGB() {
        }

        static GifRGB readFrom(LittleEndianDataInputStream dis) throws IOException {
            GifRGB rgb = new GifRGB();
            rgb.red = (byte)dis.read();
            rgb.green = (byte)dis.read();
            rgb.blue = (byte)dis.read();
            return rgb;
        }
    }

    static class ExtentionBlock {
        int extentionType;
        List<byte[]> subBlocks = new ArrayList<byte[]>();

        ExtentionBlock() {
        }

        static ExtentionBlock readFrom(LittleEndianDataInputStream dis) throws IOException {
            int subBlockSize;
            ExtentionBlock block = new ExtentionBlock();
            block.extentionType = dis.readUnsignedByte();
            while ((subBlockSize = dis.readUnsignedByte()) != 0) {
                byte[] subBlockData = new byte[subBlockSize];
                dis.readFully(subBlockData, 0, subBlockSize);
                block.subBlocks.add(subBlockData);
            }
            return block;
        }

        public String toString() {
            return String.format("21: extentionType: %02x", this.extentionType);
        }
    }

    public static class GraphicControlExtension {
        int packedFields;
        public int delayTime;
        int transparentColorIndex;

        boolean hasTransparentColor() {
            return (this.packedFields & 1) != 0;
        }

        public int getDisposalMethod() {
            return this.packedFields >> 2 & 7;
        }
    }

    private static class InternalImage {
        ImageDescriptor imageDescriptor;
        int sizeOfColorTable;
        GifRGB[] localColorTable;
        byte[] tableBasedImageData;

        private InternalImage() {
        }

        static InternalImage readFrom(LittleEndianDataInputStream dis, int sizeOfGlobalColorTable, GifRGB[] globalColorTable) throws IOException {
            int subBlockSize;
            InternalImage image = new InternalImage();
            image.imageDescriptor = ImageDescriptor.readFrom(dis);
            boolean interlaced = image.imageDescriptor.isInteraced();
            if (image.imageDescriptor.hasLocalColorTable()) {
                image.sizeOfColorTable = image.imageDescriptor.getSizeOfColorTable();
                image.localColorTable = GifImage.readColorTable(dis, image.sizeOfColorTable);
            } else {
                image.sizeOfColorTable = sizeOfGlobalColorTable;
                image.localColorTable = globalColorTable;
            }
            int bytesParLine = image.imageDescriptor.width;
            int dibColorDepth = -1;
            if (image.sizeOfColorTable == 0) {
                bytesParLine = (image.imageDescriptor.width + 7 >> 3) + 3 & 0xFFFFFFFC;
                dibColorDepth = 1;
            } else if (image.sizeOfColorTable < 4) {
                bytesParLine = (image.imageDescriptor.width + 1 >> 1) + 3 & 0xFFFFFFFC;
                dibColorDepth = 4;
            } else if (image.sizeOfColorTable < 8) {
                bytesParLine = image.imageDescriptor.width + 3 & 0xFFFFFFFC;
                dibColorDepth = 8;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int lzwMinimumCodeSize = dis.readUnsignedByte();
            baos.write(lzwMinimumCodeSize);
            while ((subBlockSize = dis.readUnsignedByte()) != 0) {
                baos.write(subBlockSize);
                byte[] subBlockData = new byte[subBlockSize];
                dis.readFully(subBlockData, 0, subBlockSize);
                baos.write(subBlockData);
            }
            byte[] data = baos.toByteArray();
            image.tableBasedImageData = decoder.decode(data, image.imageDescriptor.width, image.imageDescriptor.height, bytesParLine, interlaced, dibColorDepth, data.length);
            return image;
        }
    }

    public static class ImageDescriptor {
        public int left;
        public int top;
        public int width;
        public int height;
        int packedFields;

        static ImageDescriptor readFrom(LittleEndianDataInputStream dis) throws IOException {
            ImageDescriptor id = new ImageDescriptor();
            id.left = dis.readUnsignedShort();
            id.top = dis.readUnsignedShort();
            id.width = dis.readUnsignedShort();
            id.height = dis.readUnsignedShort();
            id.packedFields = dis.readUnsignedByte();
            return id;
        }

        boolean isInteraced() {
            return (this.packedFields & 0x40) != 0;
        }

        boolean hasLocalColorTable() {
            return (this.packedFields & 0x80) != 0;
        }

        int getSizeOfColorTable() {
            return this.packedFields & 7;
        }
    }

    private static class GifHeader {
        byte[] signature = new byte[3];
        byte[] version = new byte[3];
        int logicalScreenWidth;
        int logicalScreenHeight;
        int packedFields;
        int backgroundColorIndex;
        int pixelAspectRatio;

        private GifHeader() {
        }

        static GifHeader readFrom(LittleEndianDataInputStream dis) throws IOException {
            GifHeader gh = new GifHeader();
            dis.readFully(gh.signature);
            if (gh.signature[0] != 71 || gh.signature[1] != 73 || gh.signature[2] != 70) {
                throw new IllegalArgumentException("not gif file");
            }
            dis.readFully(gh.version);
            gh.logicalScreenWidth = dis.readUnsignedShort();
            gh.logicalScreenHeight = dis.readUnsignedShort();
            gh.packedFields = dis.readUnsignedByte();
            gh.backgroundColorIndex = dis.readUnsignedByte();
            gh.pixelAspectRatio = dis.readUnsignedByte();
            return gh;
        }

        boolean hasGlobalColorTable() {
            return (this.packedFields & 0x80) != 0;
        }

        int getSizeOfGlobalColorTable() {
            return this.packedFields & 7;
        }
    }
}

