/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio.ppm;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import vavi.imageio.WrappedImageInputStream;
import vavi.imageio.ppm.Ppm;

public class PpmImageReader
extends ImageReader {
    private IIOMetadata metadata = null;
    private Ppm ppm;

    public PpmImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IIOException {
        return 1;
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("bad index");
        }
    }

    @Override
    public int getWidth(int imageIndex) throws IIOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.ppm.getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IIOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.ppm.getHeight();
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IIOException {
        WritableRaster rowRas;
        DataBufferByte rowDB;
        this.readMetadata();
        int sourceXSubsampling = 1;
        int sourceYSubsampling = 1;
        int[] sourceBands = null;
        int[] destinationBands = null;
        Point destinationOffset = new Point(0, 0);
        Rectangle sourceRegion = new Rectangle(0, 0, this.ppm.getWidth(), this.ppm.getHeight());
        if (param != null) {
            sourceXSubsampling = param.getSourceXSubsampling();
            sourceYSubsampling = param.getSourceYSubsampling();
            sourceBands = param.getSourceBands();
            destinationBands = param.getDestinationBands();
            destinationOffset = param.getDestinationOffset();
            sourceRegion = ImageReader.getSourceRegion(param, this.ppm.getWidth(), this.ppm.getHeight());
        }
        BufferedImage dst = ImageReader.getDestination(param, this.getImageTypes(0), this.ppm.getWidth(), this.ppm.getHeight());
        int inputBands = this.ppm.getImageType() != 6 ? 1 : 3;
        ImageReader.checkReadParamBandSettings(param, inputBands, dst.getSampleModel().getNumBands());
        int[] bandOffsets = new int[inputBands];
        for (int i = 0; i < inputBands; ++i) {
            bandOffsets[i] = i;
        }
        int bytesPerRow = this.ppm.getWidth() * inputBands;
        if (this.ppm.getImageType() != 4) {
            rowDB = new DataBufferByte(bytesPerRow);
            rowRas = Raster.createInterleavedRaster(rowDB, this.ppm.getWidth(), 1, bytesPerRow, inputBands, bandOffsets, new Point(0, 0));
        } else {
            rowDB = new DataBufferByte(bytesPerRow / 8);
            rowRas = Raster.createPackedRaster(rowDB, this.ppm.getWidth(), 1, 1, new Point(0, 0));
        }
        byte[] rowBuf = rowDB.getData();
        int[] pixel = rowRas.getPixel(0, 0, (int[])null);
        WritableRaster imRas = dst.getWritableTile(0, 0);
        int dstMinX = imRas.getMinX();
        int dstMaxX = dstMinX + imRas.getWidth() - 1;
        int dstMinY = imRas.getMinY();
        int dstMaxY = dstMinY + imRas.getHeight() - 1;
        if (sourceBands != null) {
            rowRas = rowRas.createWritableChild(0, 0, this.ppm.getWidth(), 1, 0, 0, sourceBands);
        }
        if (destinationBands != null) {
            imRas = imRas.createWritableChild(0, 0, imRas.getWidth(), imRas.getHeight(), 0, 0, destinationBands);
        }
        block3: for (int srcY = 0; srcY < this.ppm.getHeight(); ++srcY) {
            int dstY;
            try {
                ((ImageInputStream)this.input).readFully(rowBuf);
            }
            catch (IOException e) {
                throw new IIOException("Error reading line " + srcY, e);
            }
            if (srcY < sourceRegion.y || srcY >= sourceRegion.y + sourceRegion.height || (srcY - sourceRegion.y) % sourceYSubsampling != 0 || (dstY = destinationOffset.y + (srcY - sourceRegion.y) / sourceYSubsampling) < dstMinY) continue;
            if (dstY > dstMaxY) break;
            for (int srcX = sourceRegion.x; srcX < sourceRegion.x + sourceRegion.width; ++srcX) {
                int dstX;
                if ((srcX - sourceRegion.x) % sourceXSubsampling != 0 || (dstX = destinationOffset.x + (srcX - sourceRegion.x) / sourceXSubsampling) < dstMinX) continue;
                if (dstX > dstMaxX) continue block3;
                rowRas.getPixel(srcX, 0, pixel);
                imRas.setPixel(dstX, dstY, pixel);
            }
        }
        return dst;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IIOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IIOException {
        this.checkIndex(imageIndex);
        this.readMetadata();
        return this.metadata;
    }

    private IIOMetadata readMetadata() throws IIOException {
        if (this.metadata != null) {
            return null;
        }
        this.readHeader();
        return null;
    }

    private void readHeader() throws IIOException {
        if (this.input == null) {
            throw new IllegalStateException("No input stream");
        }
        try {
            if (this.ppm == null) {
                this.ppm = new Ppm();
            }
            this.ppm.readHeader(new WrappedImageInputStream((ImageInputStream)this.input));
        }
        catch (IOException e) {
            throw new IIOException("Error reading header", e);
        }
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IIOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        ImageTypeSpecifier specifier = null;
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        switch (this.ppm.getImageType()) {
            case 4: {
                specifier = ImageTypeSpecifier.createGrayscale(1, 0, false);
                break;
            }
            case 5: {
                specifier = ImageTypeSpecifier.createGrayscale(8, 0, false);
                break;
            }
            case 6: {
                ColorSpace rgb = ColorSpace.getInstance(1000);
                int[] bandOffsets = new int[]{0, 1, 2};
                specifier = ImageTypeSpecifier.createInterleaved(rgb, bandOffsets, 0, false, false);
            }
        }
        l.add(specifier);
        return l.iterator();
    }
}

