/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio.ppm;

import java.io.IOException;
import java.io.InputStream;

public class Ppm {
    public static final int BINARY_PBM = 4;
    public static final int BINARY_PGM = 5;
    public static final int BINARY_PPM = 6;
    private int imageType;
    private int width;
    private int height;
    private int colorType;
    private boolean gotHeader = false;

    public int getImageType() {
        return this.imageType;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void readHeader(InputStream is) throws IOException {
        if (this.gotHeader) {
            return;
        }
        byte[] signature = new byte[2];
        is.read(signature, 0, 2);
        if (signature[0] == 80) {
            this.imageType = signature[1] - 48;
            if (this.imageType < 4 || this.imageType > 6) {
                throw new IOException("Bad PBM/PGM/PPM signature!");
            }
        } else {
            throw new IOException("Bad PBM/PGM/PPM signature!");
        }
        this.width = Ppm.readInt(is);
        this.height = Ppm.readInt(is);
        if (this.imageType != 4) {
            this.colorType = Ppm.readInt(is);
        }
        this.gotHeader = true;
    }

    private static char readChar(InputStream is) throws IOException {
        char c = (char)is.read();
        if (c == '#') {
            while ((c = (char)is.read()) != '\n' && c != '\r') {
            }
        }
        return c;
    }

    private static char readNonwhiteChar(InputStream is) throws IOException {
        char c;
        while ((c = Ppm.readChar(is)) == ' ' || c == '\t' || c == '\n' || c == '\r') {
        }
        return c;
    }

    private static int readInt(InputStream is) throws IOException {
        char c = Ppm.readNonwhiteChar(is);
        if (c < '0' || c > '9') {
            throw new IOException("junk in file where integer should be");
        }
        int i = 0;
        do {
            i = i * 10 + c - 48;
        } while ((c = Ppm.readChar(is)) >= '0' && c <= '9');
        return i;
    }
}

