/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio.mag;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import vavi.awt.image.mag.RetroMag;
import vavi.imageio.WrappedImageInputStream;
import vavi.util.Debug;

public class RetroMagImageReader
extends ImageReader {
    private IIOMetadata metadata;
    private BufferedImage image;

    public RetroMagImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IIOException {
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IIOException {
        return this.image.getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IIOException {
        return this.image.getHeight();
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IIOException {
        try {
            ImageInputStream iis;
            if (this.input instanceof ImageInputStream) {
                iis = (ImageInputStream)this.input;
            } else if (this.input instanceof InputStream) {
                iis = ImageIO.createImageInputStream(this.input);
            } else {
                throw new UnsupportedOperationException(this.input.getClass().getName());
            }
            this.image = new RetroMag().mainProcess(new WrappedImageInputStream(iis));
            return this.image;
        }
        catch (IOException e) {
            throw new IIOException(e.getMessage(), e);
        }
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IIOException {
        return this.metadata;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IIOException {
        return this.metadata;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IIOException {
        Debug.println((Level)Level.FINE, (Object)"here");
        Object specifier = null;
        ArrayList l = new ArrayList();
        l.add(specifier);
        return l.iterator();
    }
}

