/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio.gif;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Node;
import vavi.awt.image.gif.GifImage;
import vavi.imageio.WrappedImageInputStream;
import vavi.util.Debug;

public class NonLzwGifImageReader
extends ImageReader {
    private GifImage gifImage;

    public NonLzwGifImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IIOException {
        return this.gifImage.getNumImages();
    }

    @Override
    public int getWidth(int imageIndex) throws IIOException {
        return this.gifImage.getWidth(imageIndex);
    }

    @Override
    public int getHeight(int imageIndex) throws IIOException {
        return this.gifImage.getHeight(imageIndex);
    }

    public BufferedImage readImage(int imageIndex, InputStream is) throws IOException {
        byte[] vram;
        ColorModel cm = this.gifImage.getColorModel(imageIndex);
        int width = this.gifImage.getWidth(imageIndex);
        int height = this.gifImage.getHeight(imageIndex);
        int pixelSize = cm.getPixelSize();
        switch (pixelSize) {
            case 1: {
                vram = this.gifImage.loadMonoColor(imageIndex);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                vram = this.gifImage.load16Color(imageIndex);
                break;
            }
            default: {
                vram = this.gifImage.load256Color(imageIndex);
            }
        }
        BufferedImage image = new BufferedImage(width, height, 13, (IndexColorModel)cm);
        image.getRaster().setDataElements(0, 0, width, height, vram);
        return image;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IIOException {
        InputStream is = null;
        if (this.input instanceof ImageInputStream) {
            is = new WrappedImageInputStream((ImageInputStream)this.input);
        } else if (this.input instanceof InputStream) {
            is = (InputStream)this.input;
        } else {
            Debug.println((Object)("unsupported input: " + this.input));
        }
        try {
            if (this.gifImage == null) {
                this.gifImage = GifImage.readFrom(is);
            }
            return this.readImage(imageIndex, is);
        }
        catch (IOException e) {
            throw new IIOException(e.getMessage(), e);
        }
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IIOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IIOMetadata getImageMetadata(final int imageIndex) throws IIOException {
        return new IIOMetadata(){

            @Override
            public void reset() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }

            @Override
            public Node getAsTree(String formatName) {
                IIOMetadataNode rootNode = new IIOMetadataNode("javax_imageio_gif_image_1.0");
                GifImage.ImageDescriptor imageDescriptor = NonLzwGifImageReader.this.gifImage.getImageDescriptor(imageIndex);
                IIOMetadataNode imageDescriptorNode = new IIOMetadataNode("ImageDescriptor");
                imageDescriptorNode.setAttribute("imageLeftPosition", String.valueOf(imageDescriptor.left));
                imageDescriptorNode.setAttribute("imageTopPosition", String.valueOf(imageDescriptor.top));
                imageDescriptorNode.setAttribute("imageWidth", String.valueOf(imageDescriptor.width));
                imageDescriptorNode.setAttribute("imageHeight", String.valueOf(imageDescriptor.height));
                GifImage.GraphicControlExtension graphicControlExtension = NonLzwGifImageReader.this.gifImage.getGraphicControlExtension(imageIndex);
                IIOMetadataNode graphicControlExtensionNode = new IIOMetadataNode("GraphicControlExtension");
                graphicControlExtensionNode.setAttribute("disposalMethod", this.getDisposalMethod(graphicControlExtension.getDisposalMethod()));
                graphicControlExtensionNode.setAttribute("delayTime", String.valueOf(graphicControlExtension.delayTime));
                rootNode.appendChild(imageDescriptorNode);
                rootNode.appendChild(graphicControlExtensionNode);
                return rootNode;
            }

            @Override
            public String getNativeMetadataFormatName() {
                return "javax_imageio_gif_image_1.0";
            }

            String getDisposalMethod(int disposalMethod) {
                switch (disposalMethod) {
                    case 0: {
                        return "none";
                    }
                    case 1: {
                        return "doNotDispose";
                    }
                    case 2: {
                        return "restoreToBackgroundColor";
                    }
                    case 3: {
                        return "restoreToPrevious";
                    }
                }
                return "notSpecified";
            }
        };
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IIOException {
        Object specifier = null;
        ArrayList l = new ArrayList();
        l.add(specifier);
        return l.iterator();
    }
}

