/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio.am88;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import vavi.imageio.am88.ArtMasterImageReader;
import vavi.util.Debug;

public class ArtMasterImageReaderSpi
extends ImageReaderSpi {
    private static final String VendorName = "http://www.vavi.com";
    private static final String Version = "1.0.10";
    private static final String ReaderClassName = "vavi.imageio.am88.ArtMasterImageReader";
    private static final String[] Names = new String[]{"AM88"};
    private static final String[] Suffixes = new String[]{"img", "IMG"};
    private static final String[] mimeTypes = new String[]{"image/x-am88"};
    static final String[] WriterSpiNames = new String[0];
    private static final boolean SupportsStandardStreamMetadataFormat = false;
    private static final String NativeStreamMetadataFormatName = null;
    private static final String NativeStreamMetadataFormatClassName = null;
    private static final String[] ExtraStreamMetadataFormatNames = null;
    private static final String[] ExtraStreamMetadataFormatClassNames = null;
    private static final boolean SupportsStandardImageMetadataFormat = false;
    private static final String NativeImageMetadataFormatName = "am88";
    private static final String NativeImageMetadataFormatClassName = null;
    private static final String[] ExtraImageMetadataFormatNames = null;
    private static final String[] ExtraImageMetadataFormatClassNames = null;

    public ArtMasterImageReaderSpi() {
        super(VendorName, Version, Names, Suffixes, mimeTypes, ReaderClassName, new Class[]{ImageInputStream.class, InputStream.class}, WriterSpiNames, false, NativeStreamMetadataFormatName, NativeStreamMetadataFormatClassName, ExtraStreamMetadataFormatNames, ExtraStreamMetadataFormatClassNames, false, NativeImageMetadataFormatName, NativeImageMetadataFormatClassName, ExtraImageMetadataFormatNames, ExtraImageMetadataFormatClassNames);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Art Master 88 Image";
    }

    @Override
    public boolean canDecodeInput(Object obj) throws IOException {
        byte[] header = new byte[]{83, 83, 95, 83, 73, 70, 32, 32, 32, 32, 48, 46, 48, 48, 26, 0};
        if (obj instanceof ImageInputStream) {
            ImageInputStream is = (ImageInputStream)obj;
            byte[] bytes = new byte[header.length];
            try {
                is.mark();
                is.readFully(bytes);
                is.reset();
            }
            catch (IOException e) {
                Debug.println((Object)e);
                return false;
            }
            return Arrays.equals(header, bytes);
        }
        Debug.println((Object)obj);
        return false;
    }

    @Override
    public ImageReader createReaderInstance(Object obj) {
        return new ArtMasterImageReader(this);
    }
}

