/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio.am88;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import vavi.awt.image.am88.ArtMasterImageSource;
import vavi.imageio.ImageConverter;
import vavi.imageio.WrappedImageInputStream;
import vavi.util.Debug;

public class ArtMasterImageReader
extends ImageReader {
    private IIOMetadata metadata;
    private ArtMasterImageSource imageSource;

    public ArtMasterImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IIOException {
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IIOException {
        return 640;
    }

    @Override
    public int getHeight(int imageIndex) throws IIOException {
        return 200;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IIOException {
        InputStream is = null;
        if (this.input instanceof ImageInputStream) {
            is = new WrappedImageInputStream((ImageInputStream)this.input);
        } else if (this.input instanceof InputStream) {
            is = (InputStream)this.input;
        } else {
            Debug.println((Object)this.input);
        }
        Toolkit t = Toolkit.getDefaultToolkit();
        try {
            this.imageSource = new ArtMasterImageSource(is);
            Image image = t.createImage(this.imageSource);
            return ImageConverter.getInstance().toBufferedImage(image);
        }
        catch (IOException e) {
            throw new IIOException(e.getMessage(), e);
        }
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IIOException {
        return this.metadata;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IIOException {
        return this.metadata;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IIOException {
        Debug.println((Level)Level.FINE, (Object)"here");
        Object specifier = null;
        ArrayList l = new ArrayList();
        l.add(specifier);
        return l.iterator();
    }
}

