/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.zim;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.Arrays;
import vavi.awt.image.zim.ZimStream;
import vavi.io.SeekableDataInput;
import vavi.util.ByteUtil;
import vavi.util.Debug;

public class Zim {
    static final int MaxPixelsLength = 2854278;

    private Zim() {
    }

    static int getZxColor(int c) {
        return 0xFF000000 | (c >> 1 & 1) * 0xFF0000 | (c >> 2 & 1) * 65280 | (c & 1) * 255;
    }

    public static BufferedImage decode(SeekableDataInput<?> content) throws IOException {
        int c;
        byte[] b0 = new byte[8];
        content.readFully(b0);
        if (!Arrays.equals(b0, "FORMAT-A".getBytes())) {
            throw new IllegalArgumentException("not zim image");
        }
        content.position(506L);
        int v_5_6 = content.readUnsignedShort();
        int v_3_4 = content.readUnsignedShort();
        int v_1_2 = content.readUnsignedShort();
        int contentOffset = 512 + (v_5_6 << 1);
        content.position((long)contentOffset);
        Debug.printf((String)"pos: %1$d, %1$08x", (Object[])new Object[]{content.position()});
        byte[] b1 = new byte[22];
        content.readFully(b1);
        if (b1[0] != 0 || b1[1] != 0 || b1[2] != 0 || b1[3] != 0 || b1[20] != 1 || b1[21] != 0) {
            throw new IllegalArgumentException("wrong zim");
        }
        int width = ByteUtil.readLeShort((byte[])b1, (int)4) + 1;
        int height = ByteUtil.readLeShort((byte[])b1, (int)6) + 1;
        Debug.println((Object)("size: " + width + "x" + height));
        if (width * height > 2854278) {
            throw new IllegalArgumentException("too large " + width + "x" + height);
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        contentOffset += 24;
        int v_2 = content.readUnsignedByte();
        int v_1 = content.readUnsignedByte();
        Debug.printf((String)"pos: %1$d, %1$08x", (Object[])new Object[]{content.position()});
        int[] contentPalette = new int[256];
        if (v_2 != 0 || v_1 != 0) {
            Debug.println((Object)"user palette");
            for (c = 0; c < 16; ++c) {
                int v0 = content.readUnsignedByte();
                int v1 = content.readUnsignedByte();
                int v2 = content.readUnsignedByte();
                int v_ = content.readUnsignedByte();
                contentPalette[c] = 0xFF000000 | v1 << 16 | v2 << 8 | v0;
                contentOffset += 4;
            }
        } else {
            Debug.println((Object)"default palette");
            for (c = 0; c < 16; ++c) {
                contentPalette[c] = Zim.getZxColor(c);
            }
            contentPalette[8] = -1;
        }
        Debug.printf((String)"pos: %1$d, %1$08x", (Object[])new Object[]{content.position()});
        int pixelsLength = width * height;
        for (int pixelsOffset = 0; pixelsOffset < pixelsLength; ++pixelsOffset) {
            pixels[pixelsOffset] = contentPalette[0];
        }
        byte[] flags3 = new byte[64];
        byte[] data = new byte[512];
        Debug.printf((String)"pos: %1$d, %1$08x", (Object[])new Object[]{content.position()});
        ZimStream stream = new ZimStream(content);
        int skip = stream.readUnsignedShort();
        Debug.println((Object)("skip: " + (skip << 1)));
        stream.skipBytes(skip << 1);
        Debug.printf((String)"pos: %1$d, %1$08x", (Object[])new Object[]{content.position()});
        block7: while (true) {
            int i;
            int dot = stream.readUnsignedShort();
            switch (dot) {
                case -1: {
                    throw new IllegalArgumentException("wrong zim");
                }
                case 0: {
                    return image;
                }
            }
            int x = stream.readUnsignedShort();
            if (x < 0 || x >= width) {
                throw new IllegalArgumentException("wrong zim: " + x);
            }
            int y = stream.readUnsignedShort();
            if (y < 0 || y >= height) {
                throw new IllegalArgumentException("wrong zim: " + y);
            }
            int len = stream.readUnsignedShort();
            if (len < 0) {
                throw new IllegalArgumentException("wrong zim: " + len);
            }
            int size = stream.readUnsignedShort();
            if (size > 512 || (size & 3) != 0 || size << 1 < dot) {
                throw new IllegalArgumentException("wrong zim: " + size);
            }
            int pixelsOffset = y * width + x;
            if (pixelsOffset + dot > pixelsLength) {
                throw new IllegalArgumentException("wrong zim: " + dot);
            }
            stream.unpackFlags2();
            stream.unpack(stream.flags2, flags3, 64);
            stream.unpack(flags3, data, size);
            for (i = 1; i < size; ++i) {
                int n = i;
                data[n] = (byte)(data[n] ^ data[i - 1] & 0xFF);
            }
            for (i = 2; i < size; ++i) {
                int n = i;
                data[n] = (byte)(data[n] ^ data[i - 2] & 0xFF);
            }
            size >>= 2;
            i = 0;
            while (true) {
                if (i >= dot) continue block7;
                int bit = ~i & 7;
                int c2 = ((data[i >> 3] & 0xFF) >> bit & 1) << 3 | ((data[size + (i >> 3)] & 0xFF) >> bit & 1) << 2 | ((data[2 * size + (i >> 3)] & 0xFF) >> bit & 1) << 1 | (data[3 * size + (i >> 3)] & 0xFF) >> bit & 1;
                pixels[pixelsOffset + i] = contentPalette[c2];
                ++i;
            }
            break;
        }
    }
}

