/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.quantization;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.io.IOException;
import vavi.awt.image.quantization.NeuralNetQuantizer;

public class NeuralNetQuantizeOp
implements BufferedImageOp {
    private int colors;

    public NeuralNetQuantizeOp(int colors) {
        this.colors = colors;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        try {
            NeuralNetQuantizer quantizer = new NeuralNetQuantizer(src, src.getWidth(), src.getHeight(), this.colors);
            if (dest == null) {
                dest = this.createCompatibleDestImage(src, null);
            }
            int width = src.getWidth();
            int height = src.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    dest.setRGB(x, y, quantizer.convert(src.getRGB(x, y)));
                }
            }
            return dest;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return src.getRaster().getBounds();
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        int width = src.getWidth();
        int height = src.getHeight();
        return new BufferedImage(destCM, destCM.createCompatibleWritableRaster(width, height), destCM.isAlphaPremultiplied(), null);
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Float();
        }
        dstPt.setLocation(srcPt.getX(), srcPt.getY());
        return dstPt;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }
}

