/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.mag;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Level;
import vavi.util.ByteUtil;
import vavi.util.Debug;

public class RetroMag {
    private Color[][] pixels;
    private int width;
    private int height;
    private String comment;
    private float xScale;
    private float yScale;

    public BufferedImage mainProcess(InputStream is) throws IOException {
        int b;
        StringBuilder sb = new StringBuilder();
        while ((b = is.read()) != -1) {
            String s = "00000000" + Integer.toBinaryString(b);
            sb.append(s.substring(s.length() - 8));
        }
        this.comment = "";
        this.xScale = 1.0f;
        this.yScale = 1.0f;
        if (!RetroMag.isMag(sb.substring(0, 64))) {
            throw new IllegalArgumentException("unsupported type");
        }
        this.loadMag(sb.toString());
        return this.drawImage();
    }

    private static String comment(byte[] ba) {
        int p = ByteUtil.indexOf((byte[])ba, (byte)0);
        return new String(ba, 0, p == -1 ? ba.length : p, Charset.forName("Shift_JIS"));
    }

    private void loadMag(String data) {
        int flagB;
        String b;
        int[] pos = new int[]{56};
        ArrayList<Byte> commentBufS = new ArrayList<Byte>();
        ArrayList<Byte> commentBufC = new ArrayList<Byte>();
        int len = data.length();
        while ((pos[0] = pos[0] + 8) <= len && !(b = data.substring(pos[0], pos[0] + 8)).equals("00011010")) {
            if (pos[0] < 256) {
                commentBufS.add((byte)Integer.parseInt(b, 2));
                continue;
            }
            commentBufC.add((byte)Integer.parseInt(b, 2));
        }
        if (commentBufS.size() != 0) {
            this.comment = RetroMag.comment(ByteUtil.toByteArray(commentBufS));
            Debug.println((Level)Level.FINE, (Object)("SAVER/USER:\n" + this.comment));
        }
        if (commentBufC.size() != 0) {
            this.comment = RetroMag.comment(ByteUtil.toByteArray(commentBufC));
            Debug.println((Level)Level.FINE, (Object)("COMMENT:\n" + this.comment));
        }
        int commentSize = pos[0] + 8;
        while ((pos[0] = pos[0] + 8) <= len && !data.startsWith("00000000", pos[0])) {
        }
        pos[0] = pos[0] + 24;
        if (data.charAt(pos[0]) == '1') {
            throw new IllegalStateException("unsupported screen mode: " + data.charAt(pos[0]) + ", " + pos[0]);
        }
        pos[0] = pos[0] + 8;
        int xstart = RetroMag.wordConvert(16, data, pos);
        if (xstart % 8 != 0) {
            xstart -= xstart % 8;
        }
        int ystart = RetroMag.wordConvert(16, data, pos);
        int xend = RetroMag.wordConvert(16, data, pos);
        if (++xend % 8 != 0) {
            xend += 8 - xend % 8;
        }
        int yend = RetroMag.wordConvert(16, data, pos);
        Debug.printf((Level)Level.FINE, (String)"xstart: %d, xend: %d, ystart: %d, yend: %d", (Object[])new Object[]{xstart, ystart, xend, ++yend});
        int flagA = commentSize + RetroMag.wordConvert(32, data, pos) * 8;
        int flgaEnd = flagB = commentSize + RetroMag.wordConvert(32, data, pos) * 8;
        pos[0] = pos[0] + 32;
        int pixel = commentSize + RetroMag.wordConvert(32, data, pos) * 8;
        pos[0] = pos[0] + 32;
        int vtlnsz = xend - xstart;
        this.width = xend;
        this.height = yend;
        Debug.printf((Level)Level.FINE, (String)"width: %d, height: %d", (Object[])new Object[]{this.width, this.height});
        this.ensureBuffer();
        Color[] colorPalette = new Color[16];
        for (int i = 0; i < 16; ++i) {
            int r = Integer.parseInt(data.substring(pos[0] + 8, pos[0] + 12), 2) * 17;
            int g = Integer.parseInt(data.substring(pos[0], pos[0] + 4), 2) * 17;
            int b2 = Integer.parseInt(data.substring(pos[0] + 16, pos[0] + 20), 2) * 17;
            colorPalette[i] = new Color(r, g, b2);
            pos[0] = pos[0] + 24;
        }
        StringBuilder line = new StringBuilder();
        String prevLine = "";
        StringBuilder tempLine = new StringBuilder();
        int x = xstart;
        int y = ystart;
        for (int i = flagA; i < flgaEnd; ++i) {
            int j;
            if (data.charAt(i) == '0') {
                line.append("00000000");
            } else {
                line.append(data, flagB, flagB + 8);
                flagB += 8;
            }
            int length = line.length();
            if (length < vtlnsz) continue;
            if (y != ystart) {
                for (j = 0; j < length; ++j) {
                    tempLine.append(line.charAt(j) ^ prevLine.charAt(j));
                }
                line = new StringBuilder(tempLine.toString());
            }
            for (j = 0; j < length; j += 4) {
                switch (line.substring(j, j + 4)) {
                    case "0000": {
                        String b3 = data.substring(pixel, pixel + 16);
                        pixel += 16;
                        for (int k = 0; k < 4; ++k) {
                            this.pixels[x + k][y] = colorPalette[Integer.parseInt(b3.substring(k * 4, k * 4 + 4), 2)];
                        }
                        break;
                    }
                    case "0001": {
                        RetroMag.copyPixel(this.pixels, 4, 0, x, y);
                        break;
                    }
                    case "0010": {
                        RetroMag.copyPixel(this.pixels, 8, 0, x, y);
                        break;
                    }
                    case "0011": {
                        RetroMag.copyPixel(this.pixels, 16, 0, x, y);
                        break;
                    }
                    case "0100": {
                        RetroMag.copyPixel(this.pixels, 0, 1, x, y);
                        break;
                    }
                    case "0101": {
                        RetroMag.copyPixel(this.pixels, 4, 1, x, y);
                        break;
                    }
                    case "0110": {
                        RetroMag.copyPixel(this.pixels, 0, 2, x, y);
                        break;
                    }
                    case "0111": {
                        RetroMag.copyPixel(this.pixels, 4, 2, x, y);
                        break;
                    }
                    case "1000": {
                        RetroMag.copyPixel(this.pixels, 8, 2, x, y);
                        break;
                    }
                    case "1001": {
                        RetroMag.copyPixel(this.pixels, 0, 4, x, y);
                        break;
                    }
                    case "1010": {
                        RetroMag.copyPixel(this.pixels, 4, 4, x, y);
                        break;
                    }
                    case "1011": {
                        RetroMag.copyPixel(this.pixels, 8, 4, x, y);
                        break;
                    }
                    case "1100": {
                        RetroMag.copyPixel(this.pixels, 0, 8, x, y);
                        break;
                    }
                    case "1101": {
                        RetroMag.copyPixel(this.pixels, 4, 8, x, y);
                        break;
                    }
                    case "1110": {
                        RetroMag.copyPixel(this.pixels, 8, 8, x, y);
                        break;
                    }
                    case "1111": {
                        RetroMag.copyPixel(this.pixels, 0, 16, x, y);
                    }
                }
                x += 4;
            }
            prevLine = line.toString();
            tempLine = new StringBuilder();
            line = new StringBuilder();
            x = xstart;
            ++y;
        }
    }

    private static int wordConvert(int n, String data, int[] pos) {
        String s = data.substring(pos[0], pos[0] + n);
        pos[0] = pos[0] + n;
        StringBuilder sb = new StringBuilder();
        for (int i = s.length(); i > 0; i -= 8) {
            sb.append(s, i - 8, i);
        }
        return Integer.parseInt(sb.toString(), 2);
    }

    private static void copyPixel(Color[][] fieldBuffer, int ox, int oy, int x, int y) {
        for (int i = 0; i < 4; ++i) {
            fieldBuffer[x + i][y] = fieldBuffer[x - ox + i][y - oy];
        }
    }

    private BufferedImage drawImage() {
        BufferedImage image = new BufferedImage((int)((float)this.width * this.xScale), (int)((float)this.height * this.yScale), 1);
        Debug.printf((Level)Level.FINE, (String)"image: %dx%d (%dx%d)", (Object[])new Object[]{this.width, this.height, image.getWidth(), image.getHeight()});
        Graphics2D g2d = image.createGraphics();
        g2d.scale(this.xScale, this.yScale);
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.pixels[x][y] == null) continue;
                g2d.setColor(this.pixels[x][y]);
                g2d.fillRect(x, y, 1, 1);
            }
        }
        return image;
    }

    private void ensureBuffer() {
        this.pixels = new Color[this.width][];
        for (int x = 0; x < this.width; ++x) {
            this.pixels[x] = new Color[this.height];
        }
    }

    private static boolean isMag(String s) {
        if (s.startsWith("01001101") && s.startsWith("01000001010010110100100100110000", 8)) {
            return s.startsWith("001100100010000000100000", 40);
        }
        return false;
    }
}

