/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.gif;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import vavi.awt.image.gif.GifImage;

public class NonLzwGifImageSource
implements ImageProducer {
    private GifImage gifImage;
    private ImageConsumer ic;

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        this.ic = ic;
        if (this.ic != null) {
            this.loadPixel(0);
        }
        this.ic = null;
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        return ic == this.ic;
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        if (this.ic == ic) {
            this.ic = null;
        }
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    public NonLzwGifImageSource(InputStream in) throws IOException {
        this.gifImage = GifImage.readFrom(in);
    }

    public GifImage getGifImage() {
        return this.gifImage;
    }

    private void loadPixel(int index) {
        byte[] vram;
        ColorModel cm = this.gifImage.getColorModel(index);
        int width = this.gifImage.getWidth(index);
        int height = this.gifImage.getHeight(index);
        this.ic.setDimensions(width, height);
        this.ic.setProperties(new Hashtable());
        this.ic.setColorModel(cm);
        this.ic.setHints(30);
        switch (cm.getPixelSize()) {
            case 1: {
                vram = this.gifImage.loadMonoColor(index);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                vram = this.gifImage.load16Color(index);
                break;
            }
            default: {
                vram = this.gifImage.load256Color(index);
            }
        }
        this.ic.setPixels(0, 0, width, height, cm, vram, 0, width);
        this.ic.imageComplete(3);
    }
}

