/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.gif;

import vavi.util.Debug;

public class NonLzwGifDecoder {
    public byte[] decode(byte[] data, int width, int height, int bytesPerLine, boolean interlaced, int colorDepth, int size) {
        int code;
        byte[] vram = new byte[height * bytesPerLine];
        int[] lzw = new int[8192];
        RgbContext rgb = new RgbContext();
        rgb.xPoint = 0;
        rgb.offset = (height - 1) * bytesPerLine;
        rgb.width = width;
        rgb.height = height;
        rgb.bytesPerLine = bytesPerLine;
        rgb.colorDepth = colorDepth;
        rgb.currentLine = 0;
        rgb.interlaceOffset = 8;
        rgb.interlaced = interlaced;
        GifContext gif = new GifContext();
        gif.rgb = rgb;
        gif.codeSize = data[0] & 0xFF;
        gif.bitSize = gif.codeSize + 1;
        gif.clearCode = 1 << gif.codeSize;
        gif.endCode = gif.clearCode + 1;
        gif.entry = gif.endCode + 1;
        gif.bitPoint = 8;
        gif.nextBlock = 1;
        gif.dataSize = size;
        int times = 0;
        int offset = 0;
        while ((code = this.getCode(data, gif)) != gif.endCode) {
            if (code == gif.clearCode) {
                gif.entry = gif.endCode + 1;
                gif.bitSize = gif.codeSize + 1;
                this.decodeLzw(vram, lzw, gif, times, offset);
                times = 0;
                offset = 0;
                continue;
            }
            lzw[times++] = code & 0xFFFF;
            if (times == 8192) {
                this.decodeLzw(vram, lzw, gif, times, offset);
                times = 4096;
                offset = 4096;
            }
            if (gif.entry >= 4095) continue;
            ++gif.entry;
        }
        this.decodeLzw(vram, lzw, gif, times, offset);
        return vram;
    }

    private int getCode(byte[] data, GifContext gif) {
        int code = 0;
        int bytePoint = gif.bitPoint >> 3;
        if (bytePoint + 2 > gif.dataSize) {
            Debug.println((Object)"maybe broken");
            return gif.endCode;
        }
        int i = 0;
        while (gif.bitPoint + gif.bitSize - 1 >> 3 >= bytePoint) {
            if (bytePoint == gif.nextBlock) {
                gif.nextBlock += (data[bytePoint++] & 0xFF) + 1;
                gif.bitPoint += 8;
            }
            code += (data[bytePoint++] & 0xFF) << i;
            i += 8;
        }
        code = code >> (gif.bitPoint & 7) & (1 << gif.bitSize) - 1;
        gif.bitPoint += gif.bitSize;
        if (gif.entry > (1 << gif.bitSize) - 1) {
            ++gif.bitSize;
        }
        return code;
    }

    private void decodeLzw(byte[] vram, int[] lzw, GifContext gif, int times, int offset) {
        for (int i = offset; i < times; ++i) {
            this.getLzwBytes(vram, lzw, gif, i);
        }
    }

    private void getLzwBytes(byte[] vram, int[] lzw, GifContext gif, int offset) {
        int code = lzw[offset];
        if (code < gif.clearCode) {
            this.writeRgb(vram, gif, code);
        } else if (code > gif.endCode + offset--) {
            this.getLzwBytes(vram, lzw, gif, offset);
            this.getLzwByte(vram, lzw, gif, offset);
        } else {
            this.getLzwBytes(vram, lzw, gif, code - gif.endCode - 1);
            this.getLzwByte(vram, lzw, gif, code - gif.endCode);
        }
    }

    private void getLzwByte(byte[] vram, int[] lzw, GifContext gif, int offset) {
        int code;
        while ((code = lzw[offset]) >= gif.clearCode) {
            if (code > gif.endCode + offset) {
                --offset;
                continue;
            }
            offset = code - gif.endCode - 1;
        }
        this.writeRgb(vram, gif, code);
    }

    private void writeRgb(byte[] rgb, GifContext gif, int code) {
        switch (gif.rgb.colorDepth) {
            case 1: {
                int i = gif.rgb.offset + gif.rgb.xPoint / 8;
                int j = 7 - (gif.rgb.xPoint & 7);
                rgb[i] = (byte)(rgb[i] & ~(1 << j) | code << j);
                break;
            }
            case 4: {
                int i = gif.rgb.offset + (gif.rgb.xPoint >> 1);
                int j = (gif.rgb.xPoint & 1) << 2;
                rgb[i] = (byte)(rgb[i] & 15 << j | code << 4 - j);
                break;
            }
            default: {
                rgb[gif.rgb.offset + gif.rgb.xPoint] = (byte)code;
            }
        }
        ++gif.rgb.xPoint;
        if (gif.rgb.xPoint == gif.rgb.width) {
            if (gif.rgb.interlaced) {
                if (gif.rgb.currentLine + gif.rgb.interlaceOffset >= gif.rgb.height) {
                    if ((gif.rgb.currentLine & 7) == 0) {
                        gif.rgb.offset = (gif.rgb.height - 5) * gif.rgb.bytesPerLine;
                        gif.rgb.currentLine = 4;
                    } else if (gif.rgb.interlaceOffset == 8) {
                        gif.rgb.offset = (gif.rgb.height - 3) * gif.rgb.bytesPerLine;
                        gif.rgb.currentLine = 2;
                        gif.rgb.interlaceOffset = 4;
                    } else if (gif.rgb.interlaceOffset == 4) {
                        gif.rgb.offset = (gif.rgb.height - 2) * gif.rgb.bytesPerLine;
                        gif.rgb.currentLine = 1;
                        gif.rgb.interlaceOffset = 2;
                    }
                } else {
                    gif.rgb.offset -= gif.rgb.bytesPerLine * gif.rgb.interlaceOffset;
                    gif.rgb.currentLine += gif.rgb.interlaceOffset;
                }
            } else {
                gif.rgb.offset -= gif.rgb.bytesPerLine;
            }
            gif.rgb.xPoint = 0;
        }
    }

    static class GifContext {
        RgbContext rgb;
        int codeSize;
        int bitSize;
        int clearCode;
        int endCode;
        int entry;
        int bitPoint;
        int nextBlock;
        int dataSize;

        GifContext() {
        }
    }

    static class RgbContext {
        int xPoint;
        int offset;
        int width;
        int height;
        int bytesPerLine;
        int colorDepth;
        int currentLine;
        int interlaceOffset;
        boolean interlaced;

        RgbContext() {
        }
    }
}

