/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.bmp;

import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import vavi.io.LittleEndianDataInputStream;
import vavi.util.Debug;

public class WindowsBitmap {
    private Header header;
    private WindowsBitmapHeader bitmapHeader;
    private byte[] bitmap;
    private static final ColorModel system256IndexColorModel;
    private static final ColorModel systemBWIndexColorModel;
    private static final ColorModel system16IndexColorModel;

    public int getSize() {
        return this.header.bitmapSize;
    }

    public int getOffset() {
        return this.header.bitmapOffset;
    }

    public WindowsBitmapHeader getBitmapHeader() {
        return this.bitmapHeader;
    }

    public byte[] getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(byte[] bitmap) {
        this.bitmap = bitmap;
    }

    public int getHeaderSize() {
        return this.bitmapHeader.headerSize;
    }

    public int getWidth() {
        return this.bitmapHeader.width;
    }

    public int getHeight() {
        return this.bitmapHeader.height;
    }

    public int getBits() {
        return this.bitmapHeader.bits;
    }

    public void setBits(int bits) {
        this.bitmapHeader.bits = bits;
    }

    public int getCompression() {
        return this.bitmapHeader.compression;
    }

    public int getImageSize() {
        return this.bitmapHeader.imageSize;
    }

    public int getUsedColor() {
        return this.bitmapHeader.usedColor;
    }

    public void setUsedColor(int colors) {
        this.bitmapHeader.usedColor = colors;
    }

    public ColorModel getColorModel() {
        return this.bitmapHeader.palette;
    }

    public int[] get24BitColorData() {
        int width = this.getWidth();
        int height = this.getHeight();
        byte[] buffer = this.getBitmap();
        int[] ivram = new int[width * height];
        int count = 0;
        int skip = width * 3 % 4 != 0 ? 4 - width * 3 % 4 : 0;
        for (int j = 0; j < height; ++j) {
            int ofs = (height - 1 - j) * width;
            for (int i = 0; i < width; ++i) {
                int ub = (buffer[count++] & 0xFF) << 16;
                ub |= (buffer[count++] & 0xFF) << 8;
                ivram[ofs + i] = ub |= buffer[count++] & 0xFF;
            }
            count += skip;
        }
        return ivram;
    }

    public int[] get32BitColorData() {
        int width = this.getWidth();
        int height = this.getHeight();
        byte[] buffer = this.getBitmap();
        int[] ivram = new int[width * height];
        int count = 0;
        int skip = width * 4 % 4 != 0 ? 4 - width * 4 % 4 : 0;
        for (int j = 0; j < height; ++j) {
            int ofs = (height - 1 - j) * width;
            for (int i = 0; i < width; ++i) {
                int ub = (buffer[count++] & 0xFF) << 16;
                ub |= (buffer[count++] & 0xFF) << 8;
                ub |= buffer[count++] & 0xFF;
                ivram[ofs + i] = ub |= (buffer[count++] & 0xFF) << 24;
            }
            count += skip;
        }
        return ivram;
    }

    public byte[] getMonoColorData() {
        int width = this.getWidth();
        int height = this.getHeight();
        byte[] buffer = this.getBitmap();
        byte[] vram = new byte[width * height];
        int count = 0;
        int skip = (width + 7) / 8 % 4 != 0 ? 4 - (width + 7) / 8 % 4 : 0;
        for (int j = 0; j < height; ++j) {
            int ofs = (height - 1 - j) * width;
            int d = 0;
            for (int i = 0; i < width / 8; ++i) {
                byte b = buffer[count++];
                int mask = 128;
                for (int k = 0; k < 8; ++k) {
                    vram[ofs + d++] = (byte)((b & mask) >> 7 - k);
                    mask >>= 1;
                }
            }
            if (width % 8 != 0) {
                byte b = buffer[count++];
                int mask = 128;
                for (int k = 0; k < width % 8; ++k) {
                    vram[ofs + d++] = (byte)((b & mask) >> 7 - k);
                    mask >>= 1;
                }
            }
            count += skip;
        }
        return vram;
    }

    public byte[] get16ColorData() {
        int width = this.getWidth();
        int height = this.getHeight();
        byte[] buffer = this.getBitmap();
        byte[] vram = new byte[width * height];
        int count = 0;
        int skip = (width + 1) / 2 % 4 != 0 ? 4 - (width + 1) / 2 % 4 : 0;
        for (int j = 0; j < height; ++j) {
            int ofs = (height - 1 - j) * width;
            int d = 0;
            for (int i = 0; i < width / 2; ++i) {
                byte b = buffer[count++];
                vram[ofs + d++] = (byte)((b & 0xF0) >> 4);
                vram[ofs + d++] = (byte)(b & 0xF);
            }
            if (width % 2 != 0) {
                byte b = buffer[count++];
                vram[ofs + d] = (byte)((b & 0xF0) >> 4);
            }
            count += skip;
        }
        return vram;
    }

    public byte[] get16ColorRleData() {
        int width = this.getWidth();
        int height = this.getHeight();
        byte[] buffer = this.getBitmap();
        byte[] vram = new byte[width * height];
        int count = 0;
        int d = 0;
        int ofs = (height-- - 1) * width;
        while (count < this.getImageSize()) {
            int b3;
            int b1 = buffer[count++] & 0xFF;
            int b2 = buffer[count++] & 0xFF;
            if (b1 > 0) {
                for (int j = 0; j < b1; ++j) {
                    vram[ofs + d++] = j % 2 == 0 ? (byte)((b2 & 0xF0) >> 4) : (byte)(b2 & 0xF);
                }
                continue;
            }
            if (b2 == 0) {
                ofs = (height-- - 1) * width;
                d = 0;
                if (height >= 0) continue;
                break;
            }
            if (b2 == 1) break;
            if (b2 == 2) {
                b3 = buffer[count++] & 0xFF;
                int b4 = buffer[count++] & 0xFF;
                if (b3 > 0) {
                    d += b3 - 1;
                }
                if (b4 <= 0) continue;
                ofs -= width * b4;
                height -= b4;
                continue;
            }
            b3 = 0;
            for (int j = 0; j < b2; ++j) {
                if (j % 2 == 0) {
                    b3 = buffer[count++];
                }
                vram[ofs + d++] = j % 2 == 0 ? (byte)((b3 & 0xF0) >> 4) : (byte)(b3 & 0xF);
            }
            if ((b2 + 1) / 2 % 2 == 0) continue;
            ++count;
        }
        return vram;
    }

    public byte[] get256ColorData() {
        int width = this.getWidth();
        int height = this.getHeight();
        byte[] buffer = this.getBitmap();
        byte[] vram = new byte[width * height];
        int count = 0;
        int skip = width % 4 != 0 ? 4 - width % 4 : 0;
        for (int j = 0; j < height; ++j) {
            int ofs = (height - 1 - j) * width;
            for (int i = 0; i < width; ++i) {
                vram[ofs + i] = buffer[count++];
            }
            count += skip;
        }
        return vram;
    }

    public byte[] get256ColorRleData() {
        int width = this.getWidth();
        int height = this.getHeight();
        byte[] buffer = this.getBitmap();
        byte[] vram = new byte[width * height];
        int count = 0;
        int d = 0;
        int ofs = (height-- - 1) * width;
        while (count < this.getImageSize()) {
            int j;
            int b1 = buffer[count++] & 0xFF;
            int b2 = buffer[count++] & 0xFF;
            if (b1 > 0) {
                for (j = 0; j < b1; ++j) {
                    vram[ofs + d++] = (byte)b2;
                }
                continue;
            }
            if (b2 == 0) {
                ofs = (height-- - 1) * width;
                d = 0;
                if (height >= 0) continue;
                break;
            }
            if (b2 == 1) break;
            if (b2 == 2) {
                int b3 = buffer[count++] & 0xFF;
                int b4 = buffer[count++] & 0xFF;
                if (b3 > 0) {
                    d += b3 - 1;
                }
                if (b4 <= 0) continue;
                ofs -= width * b4;
                height -= b4;
                continue;
            }
            for (j = 0; j < b2; ++j) {
                vram[ofs + d++] = buffer[count++];
            }
            if (b2 % 2 == 0) continue;
            ++count;
        }
        return vram;
    }

    private static byte[] readBitmap(LittleEndianDataInputStream in, int num) throws IOException {
        byte[] buf = new byte[num];
        in.readFully(buf, 0, num);
        return buf;
    }

    public static WindowsBitmap readFrom(InputStream in) throws IOException {
        LittleEndianDataInputStream lin = new LittleEndianDataInputStream(in);
        WindowsBitmap bitmap = new WindowsBitmap();
        bitmap.header = Header.readFrom(lin);
        bitmap.bitmapHeader = WindowsBitmapHeader.readFrom(lin);
        if (bitmap.bitmapHeader.imageSize == 0) {
            bitmap.bitmapHeader.imageSize = bitmap.header.bitmapSize - bitmap.header.bitmapOffset;
        }
        bitmap.bitmap = WindowsBitmap.readBitmap(lin, bitmap.bitmapHeader.imageSize);
        return bitmap;
    }

    public static WindowsBitmap readFrom(LittleEndianDataInputStream lin, int off, int size) throws IOException {
        WindowsBitmap bitmap = new WindowsBitmap();
        bitmap.header = new Header();
        bitmap.header.bitmapSize = size;
        bitmap.bitmapHeader = WindowsBitmapHeader.readFrom(lin);
        bitmap.bitmapHeader.height /= 2;
        bitmap.header.bitmapOffset = bitmap.bitmapHeader.headerSize + 4 * bitmap.bitmapHeader.usedColor;
        bitmap.bitmap = WindowsBitmap.readBitmap(lin, bitmap.header.bitmapSize - bitmap.header.bitmapOffset);
        return bitmap;
    }

    static {
        byte[] reds = new byte[2];
        byte[] greens = new byte[2];
        byte[] blues = new byte[2];
        reds[0] = 0;
        greens[0] = 0;
        blues[1] = 0;
        reds[1] = -1;
        greens[1] = -1;
        blues[1] = -1;
        systemBWIndexColorModel = new IndexColorModel(2, 2, reds, greens, blues);
        reds = new byte[16];
        greens = new byte[16];
        blues = new byte[16];
        reds[0] = 0;
        greens[0] = 0;
        blues[0] = 0;
        reds[1] = 0;
        greens[1] = 0;
        blues[1] = -1;
        reds[2] = -1;
        greens[2] = 0;
        blues[2] = 0;
        reds[3] = -1;
        greens[3] = 0;
        blues[3] = -1;
        reds[4] = 0;
        greens[4] = -1;
        blues[4] = 0;
        reds[5] = 0;
        greens[5] = -1;
        blues[5] = -1;
        reds[6] = -1;
        greens[6] = -1;
        blues[6] = 0;
        reds[7] = -1;
        greens[7] = -1;
        blues[7] = -1;
        reds[8] = 0;
        greens[8] = 0;
        blues[8] = 127;
        reds[9] = 127;
        greens[9] = 0;
        blues[9] = 0;
        reds[10] = 127;
        greens[10] = 0;
        blues[10] = 127;
        reds[11] = 0;
        greens[11] = 0;
        blues[11] = 0;
        reds[12] = 0;
        greens[12] = 127;
        blues[12] = 127;
        reds[13] = 127;
        greens[13] = 127;
        blues[13] = 0;
        reds[14] = 127;
        greens[14] = 127;
        blues[14] = 127;
        reds[15] = 0;
        greens[15] = 127;
        blues[15] = 0;
        system16IndexColorModel = new IndexColorModel(4, 16, reds, greens, blues);
        String colorTablePath = "/vavi/awt/image/resources/WindowsSystem.ACT";
        reds = new byte[256];
        greens = new byte[256];
        blues = new byte[256];
        try {
            for (int i = 0; i < 256; ++i) {
                InputStream is = WindowsBitmap.class.getResourceAsStream(colorTablePath);
                reds[i] = (byte)is.read();
                greens[i] = (byte)is.read();
                blues[i] = (byte)is.read();
            }
        }
        catch (IOException e) {
            Debug.println((Level)Level.SEVERE, (Object)e);
        }
        system256IndexColorModel = new IndexColorModel(8, 256, reds, greens, blues);
    }

    private static final class WindowsBitmapHeader {
        int headerSize;
        int width;
        int height;
        int planes;
        int bits;
        int compression;
        int imageSize;
        int ppmX;
        int ppmY;
        int usedColor;
        int importantColor;
        ColorModel palette;

        private WindowsBitmapHeader() {
        }

        public String toString() {
            return "header size: " + this.headerSize + ", width: " + this.width + ", height: " + this.height + ", planes: " + this.planes + ", bits: " + this.bits + ", compression: " + this.compression + ", image size: " + this.imageSize + ", ppm x: " + this.ppmX + ", ppm y: " + this.ppmY + ", color used: " + this.usedColor + ", color important: " + this.importantColor;
        }

        static WindowsBitmapHeader readFrom(LittleEndianDataInputStream lin) throws IOException {
            WindowsBitmapHeader bh = new WindowsBitmapHeader();
            bh.headerSize = lin.readInt();
            bh.width = lin.readInt();
            bh.height = lin.readInt();
            bh.planes = lin.readShort();
            bh.bits = lin.readShort();
            bh.compression = lin.readInt();
            bh.imageSize = lin.readInt();
            bh.ppmX = lin.readInt();
            bh.ppmY = lin.readInt();
            bh.usedColor = lin.readInt();
            bh.importantColor = lin.readInt();
            if (bh.usedColor == 0) {
                switch (bh.bits) {
                    case 1: {
                        bh.usedColor = 2;
                        break;
                    }
                    case 4: {
                        bh.usedColor = 16;
                        break;
                    }
                    case 8: {
                        bh.usedColor = 256;
                        break;
                    }
                    case 24: 
                    case 32: {
                        break;
                    }
                    default: {
                        Debug.println((Object)("unknown bits: " + bh.bits));
                    }
                }
            }
            if (bh.usedColor != 0) {
                byte[] reds = new byte[bh.usedColor];
                byte[] greens = new byte[bh.usedColor];
                byte[] blues = new byte[bh.usedColor];
                byte[] alphas = new byte[bh.usedColor];
                for (int i = 0; i < bh.usedColor; ++i) {
                    blues[i] = lin.readByte();
                    greens[i] = lin.readByte();
                    reds[i] = lin.readByte();
                    alphas[i] = lin.readByte();
                }
                bh.palette = new IndexColorModel(bh.bits, bh.usedColor, reds, greens, blues);
            } else if (bh.bits == 24) {
                bh.palette = new DirectColorModel(bh.bits, 255, 65280, 0xFF0000);
            } else if (bh.bits == 32) {
                bh.palette = new DirectColorModel(bh.bits, 255, 65280, 0xFF0000, -16777216);
            } else {
                Debug.println((Object)("unknown bits: " + bh.bits));
            }
            if (bh.palette == null) {
                switch (bh.usedColor) {
                    case 2: {
                        bh.palette = systemBWIndexColorModel;
                        break;
                    }
                    case 16: {
                        bh.palette = system16IndexColorModel;
                        break;
                    }
                    case 256: {
                        bh.palette = system256IndexColorModel;
                        break;
                    }
                    default: {
                        Debug.println((Object)("unknown color size: " + bh.usedColor));
                    }
                }
            }
            lin.skipBytes(bh.headerSize - 40);
            if (bh.headerSize - 40 > 0) {
                Debug.println((Object)("skip: " + (bh.headerSize - 40)));
            }
            return bh;
        }
    }

    private static final class Header {
        int bitmapOffset;
        int bitmapSize;

        private Header() {
        }

        static Header readFrom(LittleEndianDataInputStream lin) throws IOException {
            Header header = new Header();
            byte[] signature = new byte[2];
            lin.readFully(signature);
            if (signature[0] != 66 || signature[1] != 77) {
                throw new IllegalArgumentException("not a windows bitmap");
            }
            header.bitmapSize = lin.readInt();
            lin.readShort();
            lin.readShort();
            header.bitmapOffset = lin.readInt();
            return header;
        }

        static int size() {
            return 14;
        }

        public String toString() {
            return "size: " + this.bitmapSize + ", offset: " + this.bitmapOffset;
        }
    }

    public static enum Type {
        RGB,
        RLE8,
        RLE4,
        BITFIELDS;

    }
}

