/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.am88;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.logging.Level;
import vavi.util.Debug;
import vavi.util.StringUtil;

public class ArtMasterImage {
    private static final ColorModel defaultCm = new IndexColorModel(8, 8, new byte[]{0, 0, -1, -1, 0, 0, -1, -1}, new byte[]{0, 0, 0, 0, -1, -1, -1, -1}, new byte[]{0, -1, 0, -1, 0, -1, 0, -1});
    public ColorModel cm = defaultCm;
    public static final int W = 640;
    public static final int H = 200;
    private byte[] R = new byte[16256];
    private byte[] G = new byte[16256];
    private byte[] B = new byte[16256];
    private static final byte[] header = new byte[]{83, 83, 95, 83, 73, 70, 32, 32, 32, 32, 48, 46, 48, 48, 26, 0};

    public ArtMasterImage(InputStream in) throws IOException {
        int l;
        byte[] buf = new byte[40];
        for (l = 0; l < 40; l += in.read(buf, l, 40 - l)) {
        }
        for (int i = 0; i < 16; ++i) {
            if (buf[i] == header[i]) continue;
            throw new IllegalArgumentException("wrong header: " + StringUtil.getDump((byte[])buf, (int)16));
        }
        if (buf[16] == 73) {
            for (l = 0; l < 756; l += (int)in.skip(756 - l)) {
            }
            Debug.println((Level)Level.FINE, (Object)("skip I: " + l));
        }
        if (buf[18] == 66) {
            for (l = 0; l < 2292; l += (int)in.skip(2292 - l)) {
            }
            Debug.println((Level)Level.FINE, (Object)("skip B: " + l));
        }
        PushbackInputStream pin = new PushbackInputStream(in, 2);
        for (int i = 0; i < 3; ++i) {
            int count = 0;
            switch (buf[19 + i]) {
                case 82: {
                    byte[] g = this.R;
                    break;
                }
                case 71: {
                    byte[] g = this.G;
                    break;
                }
                case 66: {
                    byte[] g = this.B;
                    break;
                }
                default: {
                    throw new IOException("wrong color table");
                }
            }
            while (count < 16000) {
                int p1 = pin.read();
                int p2 = pin.read();
                int bl = pin.read();
                if (p1 == p2) {
                    for (int j = 0; j < (bl == 0 ? 256 : bl); ++j) {
                        g[count++] = (byte)p1;
                    }
                    continue;
                }
                g[count++] = (byte)p1;
                pin.unread(bl);
                pin.unread(p2);
            }
        }
    }

    public byte[] getPixels() {
        byte[] result = new byte[128000];
        for (int y = 0; y < 200; ++y) {
            for (int x = 0; x < 640; ++x) {
                int pos = y * 80 + x / 8;
                int mask = 128 >> x % 8;
                int r = (this.R[pos] & mask) != 0 ? 2 : 0;
                int g = (this.G[pos] & mask) != 0 ? 4 : 0;
                int b = (this.B[pos] & mask) != 0 ? 1 : 0;
                result[y * 640 + x] = (byte)(r + g + b);
            }
        }
        return result;
    }
}

