/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.Serializable;
import vavi.awt.image.AbstractBufferedImageOp;

public abstract class BasicBufferedImageOp
extends AbstractBufferedImageOp
implements Serializable {
    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int[] inPixels = this.getRGB(src, 0, 0, width, height, null);
        inPixels = this.filterPixels(width, height, inPixels);
        this.setRGB(dst, 0, 0, dst.getWidth(), dst.getHeight(), inPixels);
        return dst;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        Rectangle2D destBounds = this.getBounds2D(src);
        if (destCM != null) {
            return new BufferedImage(destCM, destCM.createCompatibleWritableRaster((int)destBounds.getWidth(), (int)destBounds.getHeight()), destCM.isAlphaPremultiplied(), null);
        }
        return new BufferedImage((int)destBounds.getWidth(), (int)destBounds.getHeight(), src.getType());
    }

    @Override
    public abstract Rectangle2D getBounds2D(BufferedImage var1);

    protected abstract int[] filterPixels(int var1, int var2, int[] var3);
}

