/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio.avif;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.logging.Level;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import vavi.awt.image.avif.jna.Avif;
import vavi.imageio.avif.AvifImageReader;
import vavi.util.Debug;

public class AvifImageReaderSpi
extends ImageReaderSpi {
    private static final String VendorName = "https://github.com/umjammer/vavi-image-avif";
    private static final String Version = "0.0.4";
    private static final String ReaderClassName = "vavi.imageio.avif.AvifImageReader";
    private static final String[] Names = new String[]{"avif", "AVIF"};
    private static final String[] Suffixes = new String[]{"avif"};
    private static final String[] mimeTypes = new String[]{"image/avif"};
    static final String[] WriterSpiNames = new String[]{"vavi.imageio.avif.AvifImageWriter"};
    private static final boolean SupportsStandardStreamMetadataFormat = false;
    private static final String NativeStreamMetadataFormatName = null;
    private static final String NativeStreamMetadataFormatClassName = null;
    private static final String[] ExtraStreamMetadataFormatNames = null;
    private static final String[] ExtraStreamMetadataFormatClassNames = null;
    private static final boolean SupportsStandardImageMetadataFormat = false;
    private static final String NativeImageMetadataFormatName = "avif";
    private static final String NativeImageMetadataFormatClassName = null;
    private static final String[] ExtraImageMetadataFormatNames = null;
    private static final String[] ExtraImageMetadataFormatClassNames = null;

    public AvifImageReaderSpi() {
        super(VendorName, Version, Names, Suffixes, mimeTypes, ReaderClassName, new Class[]{ImageInputStream.class}, WriterSpiNames, false, NativeStreamMetadataFormatName, NativeStreamMetadataFormatClassName, ExtraStreamMetadataFormatNames, ExtraStreamMetadataFormatClassNames, false, NativeImageMetadataFormatName, NativeImageMetadataFormatClassName, ExtraImageMetadataFormatNames, ExtraImageMetadataFormatClassNames);
    }

    @Override
    public String getDescription(Locale locale) {
        return "AVIF Image decoder via libavif";
    }

    @Override
    public boolean canDecodeInput(Object obj) throws IOException {
        Debug.println((Level)Level.FINE, (Object)("input: " + obj));
        if (obj instanceof ImageInputStream) {
            int r;
            ImageInputStream stream = (ImageInputStream)obj;
            stream.mark();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] b = new byte[8192];
            while ((r = stream.read(b, 0, b.length)) >= 0) {
                baos.write(b, 0, r);
            }
            int l = baos.size();
            Debug.println((Level)Level.FINE, (Object)("size: " + l));
            ByteBuffer bb = ByteBuffer.allocateDirect(l);
            bb.put(baos.toByteArray(), 0, l);
            stream.reset();
            return Avif.isAvifImage(bb, l);
        }
        return false;
    }

    @Override
    public ImageReader createReaderInstance(Object extension) {
        return new AvifImageReader(this);
    }
}

