/*
 * Decompiled with CFR 0.152.
 */
package vavi.awt.image.avif.jna;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import vavi.awt.image.jna.avif.AvifLibrary;
import vavi.awt.image.jna.avif.avifDecoder;
import vavi.awt.image.jna.avif.avifEncoder;
import vavi.awt.image.jna.avif.avifImage;
import vavi.awt.image.jna.avif.avifRGBImage;
import vavi.awt.image.jna.avif.avifROData;
import vavi.awt.image.jna.avif.avifRWData;
import vavi.util.Debug;

public class Avif {
    private static final Avif avif = new Avif();

    private Avif() {
        String version = AvifLibrary.INSTANCE.avifVersion();
        if (!version.startsWith("1.0.3")) {
            Debug.println((Level)Level.SEVERE, (Object)("wrong version: " + version));
        }
    }

    public static Avif getInstance() {
        return avif;
    }

    public static boolean isAvifImage(ByteBuffer encoded, int length) {
        avifROData data = new avifROData();
        data.data = Native.getDirectBufferPointer((Buffer)encoded);
        data.size.setValue((long)length);
        return AvifLibrary.INSTANCE.avifPeekCompatibleFileType(data) == 1;
    }

    public BufferedImage getCompatibleImage(ByteBuffer encoded, int length) {
        Pointer buffer = Native.getDirectBufferPointer((Buffer)encoded);
        avifDecoder decoder = this.createDecoderAndParse(buffer, length, Runtime.getRuntime().availableProcessors());
        BufferedImage image = new BufferedImage(decoder.image.width, decoder.image.height, 6);
        Debug.println((Level)Level.FINER, (Object)("image depth: " + decoder.image.depth));
        return image;
    }

    private avifDecoder createDecoderAndParse(Pointer buffer, int length, int threads) {
        avifDecoder decoder = AvifLibrary.INSTANCE.avifDecoderCreate();
        if (decoder == null) {
            throw new IllegalStateException("Failed to create AVIF Decoder.");
        }
        decoder.maxThreads = threads;
        decoder.ignoreXMP = 1;
        decoder.ignoreExif = 1;
        decoder.strictFlags &= 0xFFFFFFFD;
        decoder.strictFlags &= 0xFFFFFFFE;
        int res = AvifLibrary.INSTANCE.avifDecoderSetIOMemory(decoder, buffer, new NativeLong((long)length));
        if (res != 0) {
            throw new IllegalStateException("Failed to set AVIF IO to a memory reader.");
        }
        res = AvifLibrary.INSTANCE.avifDecoderParse(decoder);
        if (res != 0) {
            throw new IllegalStateException(String.format("Failed to parse AVIF image: %s.", AvifLibrary.INSTANCE.avifResultToString(res)));
        }
        return decoder;
    }

    public BufferedImage decode(ByteBuffer encoded, int length, BufferedImage bitmap) {
        int bytes;
        Pointer buffer = Native.getDirectBufferPointer((Buffer)encoded);
        avifDecoder decoder = this.createDecoderAndParse(buffer, length, Runtime.getRuntime().availableProcessors());
        int res = AvifLibrary.INSTANCE.avifDecoderNextImage(decoder);
        if (res != 0) {
            throw new IllegalStateException(String.format("Failed to decode AVIF image. Status: %d", res));
        }
        if (bitmap.getWidth() < decoder.image.width || bitmap.getHeight() < decoder.image.height) {
            throw new IllegalStateException(String.format("Bitmap is not large enough to fit the image. Bitmap %dx%d Image %dx%d.", bitmap.getWidth(), bitmap.getHeight(), decoder.image.width, decoder.image.height));
        }
        if (bitmap.getType() != 6 && bitmap.getType() != 8) {
            throw new IllegalStateException(String.format("Bitmap format (%d) is not supported.", bitmap.getType()));
        }
        avifRGBImage rgb_image = new avifRGBImage();
        AvifLibrary.INSTANCE.avifRGBImageSetDefaults(rgb_image, decoder.image);
        if (bitmap.getType() == 8) {
            rgb_image.format = 0;
            rgb_image.depth = 8;
            bytes = 2;
        } else {
            rgb_image.depth = 8;
            bytes = 4;
        }
        ByteBuffer nativeBuffer = ByteBuffer.allocateDirect(bitmap.getWidth() * bitmap.getHeight() * bytes);
        rgb_image.pixels = Native.getDirectBufferPointer((Buffer)nativeBuffer);
        rgb_image.rowBytes = bitmap.getWidth() * bytes;
        res = AvifLibrary.INSTANCE.avifImageYUVToRGB(decoder.image, rgb_image);
        if (res != 0) {
            throw new IllegalStateException(String.format("Failed to convert YUV Pixels to RGB. Status: %d", res));
        }
        ByteBuffer localBuffer = ByteBuffer.allocate(nativeBuffer.capacity());
        localBuffer.put(nativeBuffer);
        bitmap.getRaster().setDataElements(0, 0, bitmap.getWidth(), bitmap.getHeight(), localBuffer.array());
        AvifLibrary.INSTANCE.avifDecoderDestroy(decoder);
        return bitmap;
    }

    public ByteBuffer encode(BufferedImage bitmap, int quality) {
        Debug.println((Level)Level.FINE, (Object)("depth: " + bitmap.getColorModel().getPixelSize() / bitmap.getColorModel().getNumComponents()));
        avifImage image = AvifLibrary.INSTANCE.avifImageCreate(bitmap.getWidth(), bitmap.getHeight(), bitmap.getColorModel().getPixelSize() / bitmap.getColorModel().getNumComponents(), 1);
        if (image == null) {
            throw new OutOfMemoryError("avifImageCreate");
        }
        Debug.printf((Level)Level.FINE, (String)"Encoding from converted RGBA", (Object[])new Object[0]);
        if (bitmap.getType() != 6) {
            throw new IllegalStateException(String.format("Bitmap format (%d) is not supported.", bitmap.getType()));
        }
        avifRGBImage rgb = new avifRGBImage();
        AvifLibrary.INSTANCE.avifRGBImageSetDefaults(rgb, image);
        rgb.format = 5;
        AvifLibrary.INSTANCE.avifRGBImageAllocatePixels(rgb);
        ByteBuffer nativeBuffer = rgb.pixels.getByteBuffer(0L, (long)rgb.rowBytes * (long)rgb.height);
        nativeBuffer.put(((DataBufferByte)bitmap.getRaster().getDataBuffer()).getData());
        int convertResult = AvifLibrary.INSTANCE.avifImageRGBToYUV(image, rgb);
        if (convertResult != 0) {
            throw new IllegalStateException(String.format("Failed to convert to YUV(A): %s", AvifLibrary.INSTANCE.avifResultToString(convertResult)));
        }
        avifEncoder encoder = AvifLibrary.INSTANCE.avifEncoderCreate();
        if (encoder == null) {
            throw new OutOfMemoryError("avifEncoderCreate");
        }
        encoder.maxThreads = Runtime.getRuntime().availableProcessors();
        int addImageResult = AvifLibrary.INSTANCE.avifEncoderAddImage(encoder, image, 1L, 2);
        if (addImageResult != 0) {
            throw new IllegalStateException(String.format("Failed to add image to encoder: %s", AvifLibrary.INSTANCE.avifResultToString(addImageResult)));
        }
        avifRWData avifOutput = new avifRWData();
        int finishResult = AvifLibrary.INSTANCE.avifEncoderFinish(encoder, avifOutput);
        if (finishResult != 0) {
            throw new IllegalStateException(String.format("Failed to finish encode: %s", AvifLibrary.INSTANCE.avifResultToString(finishResult)));
        }
        Debug.printf((Level)Level.FINE, (String)"Encode success: %d total bytes", (Object[])new Object[]{avifOutput.size.longValue()});
        AvifLibrary.INSTANCE.avifRGBImageFreePixels(rgb);
        AvifLibrary.INSTANCE.avifEncoderDestroy(encoder);
        return avifOutput.data.getByteBuffer(0L, avifOutput.size.longValue());
    }
}

