/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio.avif;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import vavi.awt.image.avif.jna.Avif;
import vavi.imageio.WrappedImageInputStream;
import vavi.util.Debug;

public class AvifImageReader
extends ImageReader {
    private BufferedImage image;

    public AvifImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IIOException {
        return 1;
    }

    private static void checkIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("bad index");
        }
    }

    @Override
    public int getWidth(int imageIndex) throws IIOException {
        AvifImageReader.checkIndex(imageIndex);
        return this.image.getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IIOException {
        AvifImageReader.checkIndex(imageIndex);
        return this.image.getHeight();
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IIOException {
        Debug.println((Level)Level.FINE, (Object)"decode start");
        long t = System.currentTimeMillis();
        WrappedImageInputStream stream = new WrappedImageInputStream((ImageInputStream)this.input);
        try {
            int r;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] b = new byte[8192];
            while ((r = stream.read(b, 0, b.length)) >= 0) {
                baos.write(b, 0, r);
            }
            int l = baos.size();
            Debug.println((Level)Level.FINE, (Object)("size: " + l));
            ByteBuffer bb = ByteBuffer.allocateDirect(l);
            bb.put(baos.toByteArray(), 0, l);
            Avif avif = Avif.getInstance();
            this.image = avif.getCompatibleImage(bb, l);
            BufferedImage bufferedImage = avif.decode(bb, l, this.image);
            return bufferedImage;
        }
        catch (IOException e) {
            throw new IIOException(e.getMessage(), e);
        }
        finally {
            Debug.println((Level)Level.FINE, (Object)("time: " + (System.currentTimeMillis() - t)));
        }
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IIOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IIOException {
        AvifImageReader.checkIndex(imageIndex);
        return null;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IIOException {
        AvifImageReader.checkIndex(imageIndex);
        Object specifier = null;
        ArrayList l = new ArrayList();
        l.add(specifier);
        return l.iterator();
    }
}

