package vavi.awt.image.jna.avif;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

/**
 * <i>native declaration : avif/avif.h</i><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class avifRGBImage extends Structure {
	/** must match associated avifImage */
	public int width;
	/** must match associated avifImage */
	public int height;
	/** legal depths [8, 10, 12, 16]. if depth>8, pixels must be uint16_t internally */
	public int depth;
	/**
	 * @see AvifLibrary.avifRGBFormat
	 * all channels are always full range<br>
	 * C type : avifRGBFormat
	 */
	public int format;
	/**
	 * @see AvifLibrary.avifChromaUpsampling
	 * Defaults to AVIF_CHROMA_UPSAMPLING_AUTOMATIC: How to upsample non-4:4:4 UV (ignored for 444) when converting to RGB.<br>
	 * C type : avifChromaUpsampling
	 */
	public int chromaUpsampling;
	/**
	 * @see AvifLibrary.avifChromaDownsampling
	 * How to downsample to 4:2:0 or 4:2:2 UV when converting from RGB (ignored for 4:4:4 and 4:0:0).
	 * Ignored when converting to RGB. Defaults to AVIF_CHROMA_DOWNSAMPLING_AUTOMATIC.
	 */
	public int chromaDownsampling;
	/**
	 * If AVIF_FALSE and libyuv conversion between RGB and YUV (including upsampling or downsampling if any)
	 * is available for the avifImage/avifRGBImage combination, then libyuv is used. Default is AVIF_FALSE.
	 */
	public int avoidLibYUV;
	/**
	 * Used for XRGB formats, treats formats containing alpha (such as ARGB) as if they were<br>
	 * C type : avifBool
	 */
	public int ignoreAlpha;
	/**
	 * indicates if RGB value is pre-multiplied by alpha. Default: false<br>
	 * C type : avifBool
	 */
	public int alphaPremultiplied;
	/**
	 * indicates if RGBA values are in half float (f16) format. Valid only when depth == 16. Default: false<br>
	 * C type : avifBool
	 */
	public int isFloat;
	/**
	 * Number of threads to be used for the YUV to RGB conversion. Note that this value is ignored for RGB to YUV
	 * conversion. Setting this to zero has the same effect as setting it to one. Negative values are invalid.
	 * Default: 1.
	 */
//	public int maxThreads;
	/** C type : uint8_t* */
	public Pointer pixels;
	public int rowBytes;
	public avifRGBImage() {
		super();
	}
	protected List<String> getFieldOrder() {
		return Arrays.asList("width", "height", "depth", "format", "chromaUpsampling", "chromaDownsampling", "avoidLibYUV", "ignoreAlpha", "alphaPremultiplied", "isFloat", /*"maxThreads", */"pixels", "rowBytes");
	}
	public avifRGBImage(Pointer peer) {
		super(peer);
	}
	public static class ByReference extends avifRGBImage implements Structure.ByReference {
	}
	public static class ByValue extends avifRGBImage implements Structure.ByValue {
	}
}
