/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.util;

import net.sourceforge.jiu.util.ComparatorInterface;

public class Sort {
    private Sort() {
    }

    public static void sort(Object[] a, int from, int to, ComparatorInterface c) {
        if (a == null) {
            throw new IllegalArgumentException("The object array to be sorted must be non-null.");
        }
        if (from > to) {
            throw new IllegalArgumentException("The from parameter (" + from + ") must be smaller than or equal to the to parameter (" + to + ").");
        }
        if (to >= a.length) {
            throw new IllegalArgumentException("The to parameter (" + to + ") must be smaller than the array length (" + a.length + ").");
        }
        if (c == null) {
            throw new IllegalArgumentException("The comparator parameter must be non-null.");
        }
        for (int chunk = from; chunk < to; chunk += 6) {
            int end = Math.min(chunk + 6, to);
            for (int i = chunk + 1; i < end; ++i) {
                if (c.compare(a[i - 1], a[i]) <= 0) continue;
                int j = i;
                Object elem = a[j];
                do {
                    a[j] = a[j - 1];
                } while (--j > chunk && c.compare(a[j - 1], elem) > 0);
                a[j] = elem;
            }
        }
        int len = to - from;
        if (len <= 6) {
            return;
        }
        Object[] src = a;
        Object[] dest = new Object[len];
        Object[] t = null;
        int srcDestDiff = -from;
        for (int size = 6; size < len; size <<= 1) {
            for (int start = from; start < to; start += size << 1) {
                int mid = start + size;
                int end = Math.min(to, mid + size);
                if (mid >= end || c.compare(src[mid - 1], src[mid]) <= 0) {
                    System.arraycopy(src, start, dest, start + srcDestDiff, end - start);
                    continue;
                }
                if (c.compare(src[start], src[end - 1]) > 0) {
                    System.arraycopy(src, start, dest, end - size + srcDestDiff, size);
                    System.arraycopy(src, mid, dest, start + srcDestDiff, end - mid);
                    continue;
                }
                int p1 = start;
                int p2 = mid;
                int i = start + srcDestDiff;
                while (p1 < mid && p2 < end) {
                    dest[i++] = src[c.compare(src[p1], src[p2]) <= 0 ? p1++ : p2++];
                }
                if (p1 < mid) {
                    System.arraycopy(src, p1, dest, i, mid - p1);
                    continue;
                }
                System.arraycopy(src, p2, dest, i, end - p2);
            }
            t = src;
            src = dest;
            dest = t;
            from += srcDestDiff;
            to += srcDestDiff;
            srcDestDiff = -srcDestDiff;
        }
        if (src != a) {
            System.arraycopy(src, 0, a, srcDestDiff, to);
        }
    }

    public static void sort(Object[] a, ComparatorInterface comparator) {
        Sort.sort(a, 0, a.length - 1, comparator);
    }
}

