/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.util;

public class ArrayScaling {
    private ArrayScaling() {
    }

    public static final void scaleUp200Percent(byte[] data, int width, int height) throws IllegalArgumentException {
        int offset2;
        int offset1;
        if (data == null) {
            throw new IllegalArgumentException("Error -- data must be non-null.");
        }
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Error -- both width and height must be larger than zero (width=" + width + ", height=" + height + ").");
        }
        if (width * height * 4 > data.length) {
            throw new IllegalArgumentException("Error -- data array must hold at least width times height times 4 values.");
        }
        int newWidth = width * 2;
        int newHeight = height * 2;
        int y1 = height - 1;
        int y2 = newHeight - 1;
        while (y1 >= 0) {
            offset1 = (y1 + 1) * width - 1;
            offset2 = (y2 + 1) * newWidth - 1;
            for (int x = width - 1; x > 0; --x) {
                int v1 = data[offset1--] & 0xFF;
                int v2 = data[offset1] & 0xFF;
                data[offset2--] = (byte)v1;
                data[offset2--] = (byte)(v1 + v2 >> 1);
            }
            byte v = data[offset1];
            data[offset2--] = v;
            data[offset2] = v;
            --y1;
            y2 -= 2;
        }
        for (int y = newHeight - 1; y > 1; y -= 2) {
            offset1 = (y - 2) * newWidth;
            offset2 = offset1 + newWidth;
            int offset3 = offset2 + newWidth;
            for (int x = 0; x < newWidth; ++x) {
                int v1 = data[offset1++] & 0xFF;
                int v2 = data[offset3++] & 0xFF;
                data[offset2++] = (byte)(v1 + v2 >> 1);
            }
        }
        int x1 = 0;
        int x2 = newWidth;
        while (x1 < newWidth) {
            data[x1++] = data[x2++];
        }
    }
}

