/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.util;

public class ArrayRotation {
    private ArrayRotation() {
    }

    public static void checkPixelArray(int[] pixels, int width, int height) {
        if (pixels == null) {
            throw new IllegalArgumentException("Error -- the pixel array must be initialized.");
        }
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Error -- width and height must be >= 1 (width=" + width + ", height=" + height + ").");
        }
        if (pixels.length < width * height) {
            throw new IllegalArgumentException("Error -- pixel array must have at least width * height pixels, has only " + pixels.length + " pixels.");
        }
    }

    private static final void flipInPlace(int[] pixels, int width, int height) {
        ArrayRotation.checkPixelArray(pixels, width, height);
        int y1 = 0;
        int y2 = height - 1;
        while (y1 < y2) {
            int offset1 = y1 * width;
            int offset2 = y2 * width;
            for (int x = 0; x < width; ++x) {
                int temp = pixels[offset1];
                pixels[offset1++] = pixels[offset2];
                pixels[offset2++] = temp;
            }
        }
    }

    private static final int[] flip(int[] pixels, int width, int height) {
        ArrayRotation.checkPixelArray(pixels, width, height);
        int[] result = new int[width * height];
        int y1 = 0;
        int y2 = height - 1;
        while (y1 < height) {
            int offset1 = y1 * width;
            int offset2 = y2 * width;
            for (int x = 0; x < width; ++x) {
                result[offset2++] = pixels[offset1++];
            }
            ++y1;
            --y2;
        }
        return result;
    }

    public static final int[] flip(boolean inPlace, int[] pixels, int width, int height) {
        if (inPlace) {
            ArrayRotation.flipInPlace(pixels, width, height);
            return pixels;
        }
        return ArrayRotation.flip(pixels, width, height);
    }

    public static int[] rotate180(boolean inPlace, int[] pixels, int width, int height) {
        if (inPlace) {
            ArrayRotation.rotateInPlace180(pixels, width, height);
            return pixels;
        }
        return pixels;
    }

    private static void rotateInPlace180(int[] pixels, int width, int height) {
        ArrayRotation.checkPixelArray(pixels, width, height);
        int x1 = 0;
        int x2 = width * height - 1;
        while (x1 < x2) {
            int temp = pixels[x1];
            pixels[x1++] = pixels[x2];
            pixels[x2--] = temp;
        }
    }

    public static void rotate90Left(int width, int height, byte[] src, int srcOffset, byte[] dest, int destOffset) {
        int offset = srcOffset;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                dest[destOffset + (width - x - 1) * height + y] = src[offset++];
            }
        }
    }

    public static void rotate90Right(int width, int height, byte[] src, int srcOffset, byte[] dest, int destOffset) {
        int offset = srcOffset;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                dest[destOffset + x * height + (height - 1 - y)] = src[offset++];
            }
        }
    }

    public static void rotate180(int width, int height, byte[] src, int srcOffset, byte[] dest, int destOffset) {
        int n = width * height;
        destOffset = destOffset + n - 1;
        while (n-- > 0) {
            dest[destOffset--] = src[srcOffset++];
        }
    }

    private static void rotateInPlace90Right(int[] pixels, int width, int height) {
        throw new IllegalArgumentException("This method not implemented yet.");
    }

    private static int[] rotate90Right(int[] pixels, int width, int height) {
        int[] result = new int[width * height];
        int offset = 0;
        for (int y = 0; y < height; ++y) {
            int srcOffset = height - 1 - y;
            for (int x = 0; x < width; ++x) {
                result[srcOffset] = pixels[offset++];
                srcOffset += height;
            }
        }
        return result;
    }

    public static int[] rotate90Right(boolean inPlace, int[] pixels, int width, int height) {
        if (inPlace) {
            ArrayRotation.rotateInPlace90Right(pixels, width, height);
            return pixels;
        }
        return ArrayRotation.rotate90Right(pixels, width, height);
    }
}

