/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.ops;

import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public abstract class LookupTableOperation
extends ImageToImageOperation {
    private int[][] intTables;
    private int numTables;

    public LookupTableOperation() {
        this(1);
    }

    public LookupTableOperation(int numTables) {
        super(null, null);
        if (numTables < 1) {
            throw new IllegalArgumentException("The number of tables must be at least 1; got " + numTables);
        }
        this.intTables = new int[numTables][];
        this.numTables = numTables;
    }

    public int getNumTables() {
        return this.numTables;
    }

    public int[] getTable(int channelIndex) {
        return this.intTables[channelIndex];
    }

    public void prepareImages() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        PixelImage in = this.getInputImage();
        if (!(in instanceof IntegerImage)) {
            throw new WrongParameterException("Input image must be of type IntegerImage.");
        }
        PixelImage out = this.getOutputImage();
        if (out == null) {
            out = in.createCompatibleImage(in.getWidth(), in.getHeight());
            this.setOutputImage(out);
        } else {
            if (in.getNumChannels() != out.getNumChannels()) {
                throw new WrongParameterException("Output image must have same number of channels as input image.");
            }
            this.ensureImagesHaveSameResolution();
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.prepareImages();
        this.process((IntegerImage)this.getInputImage(), (IntegerImage)this.getOutputImage());
    }

    private void process(IntegerImage in, IntegerImage out) {
        boolean useFirstTableOnly = this.getNumTables() < in.getNumChannels();
        int TOTAL_ITEMS = in.getHeight() * in.getNumChannels();
        int processedItems = 0;
        for (int channelIndex = 0; channelIndex < in.getNumChannels(); ++channelIndex) {
            int tableIndex = useFirstTableOnly ? 0 : channelIndex;
            this.process(in, out, channelIndex, tableIndex, processedItems, TOTAL_ITEMS);
            processedItems += in.getHeight();
        }
    }

    private void process(IntegerImage in, IntegerImage out, int CHANNEL_INDEX, int tableIndex, int processedItems, int TOTAL_ITEMS) {
        int[] TABLE = this.getTable(tableIndex);
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        for (int y = 0; y < HEIGHT; ++y) {
            for (int x = 0; x < WIDTH; ++x) {
                out.putSample(CHANNEL_INDEX, x, y, TABLE[in.getSample(CHANNEL_INDEX, x, y)]);
            }
            this.setProgress(processedItems++, TOTAL_ITEMS);
        }
    }

    public void setNumTables(int numberOfTables) {
        if (numberOfTables < 1) {
            throw new IllegalArgumentException("Number of tables argument must be larger than zero.");
        }
        this.numTables = numberOfTables;
        this.intTables = new int[this.numTables][];
    }

    public void setTable(int channelIndex, int[] tableData) {
        if (channelIndex < 0) {
            throw new IllegalArgumentException("The channelIndex argument must be at least 0; got " + channelIndex);
        }
        if (channelIndex >= this.getNumTables()) {
            throw new IllegalArgumentException("The channelIndex argument must be smaller than the number of tables " + this.getNumTables() + "; got " + channelIndex);
        }
        this.intTables[channelIndex] = tableData;
    }

    public void setTables(int[] tableData) {
        for (int i = 0; i < this.getNumTables(); ++i) {
            this.setTable(i, tableData);
        }
    }
}

