/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.ops;

import java.util.Vector;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.Operation;
import net.sourceforge.jiu.ops.WrongParameterException;

public abstract class ImagesToImageOperation
extends Operation {
    private Vector inputImages = new Vector();
    private PixelImage outputImage;

    public ImagesToImageOperation() {
        this(null, null);
    }

    public ImagesToImageOperation(Vector in, PixelImage out) {
        if (in != null) {
            for (int i = 0; i < in.size(); ++i) {
                this.addInputImage((PixelImage)in.elementAt(i));
            }
        }
        this.setOutputImage(out);
    }

    public void addInputImage(PixelImage in) {
        this.inputImages.addElement(in);
    }

    public void ensureImagesHaveSameResolution() throws WrongParameterException {
        if (this.inputImages == null || this.inputImages.size() < 1) {
            return;
        }
        PixelImage in = this.getInputImage(0);
        int width = in.getWidth();
        int height = in.getHeight();
        for (int index = 1; index < this.inputImages.size(); ++index) {
            in = this.getInputImage(index);
            if (in.getWidth() != width) {
                throw new WrongParameterException("Width of images #0 and #" + index + " are not equal.");
            }
            if (in.getHeight() == height) continue;
            throw new WrongParameterException("Height of images #0 and #" + index + " are not equal.");
        }
        PixelImage out = this.getOutputImage();
        if (out != null) {
            if (out.getWidth() != width) {
                throw new WrongParameterException("Width of input images #0 and output image are not equal.");
            }
            if (out.getHeight() != height) {
                throw new WrongParameterException("Height of input images #0 and output image are not equal.");
            }
        }
    }

    public void ensureOutputImageResolution(int width, int height) throws WrongParameterException {
        PixelImage out = this.getOutputImage();
        if (out != null) {
            if (out.getWidth() != width) {
                throw new WrongParameterException("Output image must have width " + width + " (got: " + out.getWidth() + ").");
            }
            if (out.getHeight() != height) {
                throw new WrongParameterException("Output image must have height " + height + " (got: " + out.getHeight() + ").");
            }
        }
    }

    public PixelImage getInputImage(int index) {
        return (PixelImage)this.inputImages.elementAt(index);
    }

    public int getNumInputImages() {
        return this.inputImages.size();
    }

    public PixelImage getOutputImage() {
        return this.outputImage;
    }

    public void setOutputImage(PixelImage out) {
        this.outputImage = out;
    }
}

