/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.ops;

import java.io.File;
import java.util.Vector;
import net.sourceforge.jiu.ops.DirectoryTree;
import net.sourceforge.jiu.ops.Operation;

public abstract class BatchProcessorOperation
extends Operation {
    private boolean collectErrors;
    private Vector directoryTrees = new Vector();
    private Vector errorMessages = new Vector();
    private Vector inputFileNames = new Vector();
    private String outputDirectory;
    private boolean overwrite;

    public void addDirectoryTree(String rootDirectoryName) {
        this.addDirectoryTree(rootDirectoryName, null);
    }

    public void addDirectoryTree(String rootDirectoryName, String outputRootDirectoryName) {
        DirectoryTree tree = new DirectoryTree();
        tree.input = rootDirectoryName;
        tree.output = outputRootDirectoryName;
        this.directoryTrees.addElement(tree);
    }

    public void addInputFileName(String fileName) {
        this.inputFileNames.addElement(fileName);
    }

    public void addInputFileNames(Vector fileNameList) {
        int index = 0;
        while (index < fileNameList.size()) {
            String fileName = (String)fileNameList.elementAt(index++);
            this.inputFileNames.addElement(fileName);
        }
    }

    public Vector getErrorMessages() {
        return this.errorMessages;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public void process() {
        int index = 0;
        while (index < this.directoryTrees.size()) {
            DirectoryTree tree = (DirectoryTree)this.directoryTrees.elementAt(index++);
            String output = tree.output;
            if (output == null) {
                output = this.outputDirectory;
            }
            this.processDirectoryTree(tree.input, output);
        }
        index = 0;
        while (index < this.inputFileNames.size()) {
            String fileName;
            File file;
            if (!(file = new File(fileName = (String)this.inputFileNames.elementAt(index++))).isFile() && this.collectErrors) {
                this.errorMessages.addElement("Cannot process \"" + fileName + "\" (not a file).");
            }
            String inDir = file.getParent();
            String outDir = this.outputDirectory;
            if (outDir == null) {
                outDir = inDir;
            }
            this.processFile(inDir, file.getName(), outDir);
        }
    }

    private void processDirectoryTree(String fromDir, String toDir) {
        File fromDirFile = new File(fromDir);
        String[] entries = fromDirFile.list();
        for (int i = 0; i < entries.length; ++i) {
            String name = entries[i];
            File entry = new File(fromDir, name);
            if (entry.isFile()) {
                this.processFile(fromDir, name, toDir);
                continue;
            }
            if (!entry.isDirectory()) continue;
            File inSubDir = new File(fromDir, name);
            File outSubDir = new File(toDir, name);
            if (outSubDir.exists()) {
                if (outSubDir.isFile()) {
                    if (!this.collectErrors) continue;
                    this.errorMessages.addElement("Cannot create output directory \"" + outSubDir.getAbsolutePath() + "\" because a file of that name already exists.");
                    continue;
                }
            } else if (!outSubDir.mkdir()) {
                if (!this.collectErrors) continue;
                this.errorMessages.addElement("Could not create output directory \"" + outSubDir.getAbsolutePath() + "\".");
                continue;
            }
            this.processDirectoryTree(inSubDir.getAbsolutePath(), outSubDir.getAbsolutePath());
        }
    }

    public abstract void processFile(String var1, String var2, String var3);

    public void setCollectErrorMessages(boolean collectErrorMessages) {
        this.collectErrors = collectErrorMessages;
    }

    public void setOutputDirectory(String outputDirectoryName) {
        this.outputDirectory = outputDirectoryName;
    }

    public void setOverwrite(boolean newValue) {
        this.overwrite = newValue;
    }
}

