/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt.dialogs;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.sourceforge.jiu.apps.Strings;
import net.sourceforge.jiu.gui.awt.dialogs.Dialogs;

public class HueSaturationValueDialog
extends Dialog
implements ActionListener,
ItemListener,
KeyListener {
    private Button ok;
    private Button cancel;
    private Panel colorPanel;
    private TextField hue;
    private TextField saturation;
    private TextField value;
    private Checkbox setHue;
    private boolean pressedOk = false;

    public HueSaturationValueDialog(Frame owner, Strings strings, boolean initialSetHue, int h, int s, int v) {
        super(owner, strings.get(142), true);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2));
        this.setHue = new Checkbox(strings.get(143), initialSetHue);
        this.setHue.addItemListener(this);
        panel.add(this.setHue);
        this.colorPanel = new Panel();
        panel.add(this.colorPanel);
        panel.add(new Label(strings.get(144)));
        this.hue = new TextField(Integer.toString(h));
        this.hue.addKeyListener(this);
        panel.add(this.hue);
        panel.add(new Label(strings.get(145)));
        this.saturation = new TextField(Integer.toString(s));
        this.saturation.addKeyListener(this);
        panel.add(this.saturation);
        panel.add(new Label(strings.get(146)));
        this.value = new TextField(Integer.toString(v));
        this.value.addKeyListener(this);
        panel.add(this.value);
        this.add((Component)panel, "Center");
        this.ok = new Button(strings.get(64));
        this.ok.addActionListener(this);
        this.cancel = new Button(strings.get(65));
        this.cancel.addActionListener(this);
        panel = new Panel();
        panel.add(this.ok);
        panel.add(this.cancel);
        this.add((Component)panel, "South");
        this.updateTextFields();
        this.pack();
        Dialogs.center(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.pressedOk = true;
            this.setVisible(false);
        } else if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
    }

    public int getHue() {
        return this.getValue(this.hue);
    }

    public int getSaturation() {
        return this.getValue(this.saturation);
    }

    public int getValue() {
        return this.getValue(this.value);
    }

    private int getValue(TextComponent textField) {
        try {
            return Integer.parseInt(textField.getText());
        }
        catch (NumberFormatException nfe) {
            return -1000;
        }
    }

    public boolean hasPressedOk() {
        return this.pressedOk;
    }

    public void itemStateChanged(ItemEvent e) {
        this.updateTextFields();
    }

    public boolean isHueSet() {
        return this.setHue.getState();
    }

    private void updateTextFields() {
        boolean enabled;
        this.hue.setEnabled(this.setHue.getState());
        int h = this.getValue(this.hue);
        int s = this.getValue(this.saturation);
        int v = this.getValue(this.value);
        boolean bl = enabled = s >= -100 && s <= 100 && v >= -100 && v <= 100;
        if (this.setHue.getState()) {
            enabled = enabled && h >= 0 && h <= 359;
        }
        this.ok.setEnabled(enabled);
        Color color = new Color(Color.HSBtoRGB((float)h / 360.0f, 1.0f, 1.0f));
        this.colorPanel.setBackground(color);
    }

    public void keyPressed(KeyEvent e) {
        this.updateTextFields();
    }

    public void keyReleased(KeyEvent e) {
        this.updateTextFields();
    }

    public void keyTyped(KeyEvent e) {
        this.updateTextFields();
    }
}

