/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import net.sourceforge.jiu.apps.EditorState;
import net.sourceforge.jiu.apps.OperationProcessor;
import net.sourceforge.jiu.apps.Strings;
import net.sourceforge.jiu.codecs.BMPCodec;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.GIFCodec;
import net.sourceforge.jiu.codecs.ImageLoader;
import net.sourceforge.jiu.codecs.PNGCodec;
import net.sourceforge.jiu.codecs.PNMCodec;
import net.sourceforge.jiu.codecs.PalmCodec;
import net.sourceforge.jiu.codecs.RASCodec;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.color.Invert;
import net.sourceforge.jiu.color.WebsafePaletteCreator;
import net.sourceforge.jiu.color.adjustment.Brightness;
import net.sourceforge.jiu.color.adjustment.Contrast;
import net.sourceforge.jiu.color.adjustment.EqualizeHistogram;
import net.sourceforge.jiu.color.adjustment.GammaCorrection;
import net.sourceforge.jiu.color.adjustment.HueSaturationValue;
import net.sourceforge.jiu.color.adjustment.NormalizeHistogram;
import net.sourceforge.jiu.color.analysis.Histogram1DCreator;
import net.sourceforge.jiu.color.analysis.Histogram3DCreator;
import net.sourceforge.jiu.color.analysis.MatrixCreator;
import net.sourceforge.jiu.color.analysis.TextureAnalysis;
import net.sourceforge.jiu.color.data.CoOccurrenceFrequencyMatrix;
import net.sourceforge.jiu.color.data.CoOccurrenceMatrix;
import net.sourceforge.jiu.color.data.Histogram1D;
import net.sourceforge.jiu.color.data.Histogram3D;
import net.sourceforge.jiu.color.dithering.ErrorDiffusionDithering;
import net.sourceforge.jiu.color.dithering.OrderedDither;
import net.sourceforge.jiu.color.io.HistogramSerialization;
import net.sourceforge.jiu.color.io.MatrixSerialization;
import net.sourceforge.jiu.color.io.PaletteSerialization;
import net.sourceforge.jiu.color.promotion.PromotionGray16;
import net.sourceforge.jiu.color.promotion.PromotionGray8;
import net.sourceforge.jiu.color.promotion.PromotionPaletted8;
import net.sourceforge.jiu.color.promotion.PromotionRGB24;
import net.sourceforge.jiu.color.promotion.PromotionRGB48;
import net.sourceforge.jiu.color.quantization.ArbitraryPaletteQuantizer;
import net.sourceforge.jiu.color.quantization.MedianCutContourRemoval;
import net.sourceforge.jiu.color.quantization.MedianCutQuantizer;
import net.sourceforge.jiu.color.quantization.OctreeColorQuantizer;
import net.sourceforge.jiu.color.quantization.UniformPaletteQuantizer;
import net.sourceforge.jiu.color.reduction.AutoDetectColorType;
import net.sourceforge.jiu.color.reduction.RGBToGrayConversion;
import net.sourceforge.jiu.color.reduction.ReduceShadesOfGray;
import net.sourceforge.jiu.color.reduction.ReduceToBilevelThreshold;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.PalettedImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGBIntegerImage;
import net.sourceforge.jiu.filters.ConvolutionKernelFilter;
import net.sourceforge.jiu.filters.MaximumFilter;
import net.sourceforge.jiu.filters.MeanFilter;
import net.sourceforge.jiu.filters.MedianFilter;
import net.sourceforge.jiu.filters.MinimumFilter;
import net.sourceforge.jiu.filters.OilFilter;
import net.sourceforge.jiu.geometry.Crop;
import net.sourceforge.jiu.geometry.Flip;
import net.sourceforge.jiu.geometry.Mirror;
import net.sourceforge.jiu.geometry.Resample;
import net.sourceforge.jiu.geometry.ResampleFilter;
import net.sourceforge.jiu.geometry.Rotate180;
import net.sourceforge.jiu.geometry.Rotate90Left;
import net.sourceforge.jiu.geometry.Rotate90Right;
import net.sourceforge.jiu.geometry.ScaleReplication;
import net.sourceforge.jiu.geometry.Shear;
import net.sourceforge.jiu.gui.awt.AwtInfo;
import net.sourceforge.jiu.gui.awt.JiuAwtFrame;
import net.sourceforge.jiu.gui.awt.ToolkitLoader;
import net.sourceforge.jiu.gui.awt.dialogs.CropDialog;
import net.sourceforge.jiu.gui.awt.dialogs.Dialogs;
import net.sourceforge.jiu.gui.awt.dialogs.GammaCorrectionDialog;
import net.sourceforge.jiu.gui.awt.dialogs.HueSaturationValueDialog;
import net.sourceforge.jiu.gui.awt.dialogs.MapToArbitraryPaletteDialog;
import net.sourceforge.jiu.gui.awt.dialogs.MedianCutDialog;
import net.sourceforge.jiu.gui.awt.dialogs.OctreeDialog;
import net.sourceforge.jiu.gui.awt.dialogs.ReduceGrayscaleDialog;
import net.sourceforge.jiu.gui.awt.dialogs.ScaleDialog;
import net.sourceforge.jiu.gui.awt.dialogs.ShearDialog;
import net.sourceforge.jiu.gui.awt.dialogs.UniformPaletteQuantizerDialog;
import net.sourceforge.jiu.gui.awt.dialogs.WindowSizeDialog;
import net.sourceforge.jiu.gui.awt.dialogs.YesNoDialog;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.WrongParameterException;
import net.sourceforge.jiu.util.SystemInfo;

public class AwtOperationProcessor
extends OperationProcessor {
    private JiuAwtFrame frame;

    public AwtOperationProcessor(EditorState editorState, JiuAwtFrame awtFrame) {
        super(editorState);
        this.frame = awtFrame;
    }

    public void colorAdjustBrightness() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        Integer value = Dialogs.getInteger(this.frame, strings.get(110), strings.get(111), -100, 0, 100, strings.get(64), strings.get(65));
        if (value == null || value == 0) {
            return;
        }
        Brightness brightness = new Brightness();
        brightness.setBrightness(value);
        this.process(brightness);
    }

    public void colorAdjustContrast() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        Integer value = Dialogs.getInteger(this.frame, strings.get(108), strings.get(109), -100, 0, 100, strings.get(64), strings.get(65));
        if (value == null || value == 0) {
            return;
        }
        Contrast contrast = new Contrast();
        contrast.setContrast(value);
        this.process(contrast);
    }

    public void colorAdjustGamma() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        GammaCorrectionDialog gcd = new GammaCorrectionDialog((Frame)this.frame, strings, 2.2, 10.0);
        gcd.setVisible(true);
        Double result = gcd.getValue();
        if (result == null) {
            return;
        }
        GammaCorrection gc = new GammaCorrection();
        gc.setGamma(result);
        this.process(gc);
    }

    public void colorAdjustHueSaturationValue() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        HueSaturationValueDialog hsvDialog = new HueSaturationValueDialog(this.frame, strings, false, 0, 0, 0);
        hsvDialog.setVisible(true);
        if (!hsvDialog.hasPressedOk()) {
            return;
        }
        boolean setHue = hsvDialog.isHueSet();
        int hue = hsvDialog.getHue();
        int saturation = hsvDialog.getSaturation();
        int value = hsvDialog.getValue();
        HueSaturationValue hsv = new HueSaturationValue();
        if (setHue) {
            hsv.setHueSaturationValue(hue, saturation, value);
        } else {
            hsv.setSaturationValue(saturation, value);
        }
        this.process(hsv);
    }

    public void colorHistogramCountColorsUsed() {
        int numColors;
        Strings strings;
        block4: {
            EditorState state = this.getEditorState();
            strings = state.getStrings();
            PixelImage image = state.getImage();
            numColors = 0;
            this.frame.setWaitCursor();
            try {
                if (image instanceof RGBIntegerImage) {
                    Histogram3DCreator hc = new Histogram3DCreator();
                    hc.setImage((RGBIntegerImage)image);
                    hc.addProgressListeners(state.getProgressListeners());
                    hc.process();
                    Histogram3D hist = hc.getHistogram();
                    numColors = hist.getNumUsedEntries();
                    break block4;
                }
                if (image instanceof IntegerImage && image.getNumChannels() == 1) {
                    Histogram1DCreator hc = new Histogram1DCreator();
                    hc.setImage((IntegerImage)image);
                    hc.addProgressListeners(state.getProgressListeners());
                    hc.process();
                    Histogram1D hist = hc.getHistogram();
                    numColors = hist.getNumUsedEntries();
                    break block4;
                }
                throw new UnsupportedTypeException("Not a supported image type for counting colors: " + image.getImageType().getName());
            }
            catch (OperationFailedException ofe) {
                this.frame.setDefaultCursor();
                this.frame.updateStatusBar();
                this.frame.showError(ofe.toString());
                return;
            }
        }
        this.frame.setDefaultCursor();
        this.frame.updateStatusBar();
        this.frame.showInfo(strings.get(6), strings.get(5) + ": " + numColors);
    }

    public void colorHistogramEqualize() {
        EditorState state = this.getEditorState();
        try {
            this.process(new EqualizeHistogram((IntegerImage)state.getImage()));
        }
        catch (OperationFailedException ofe) {
            this.frame.showError(ofe.toString());
        }
    }

    public void colorHistogramNormalize() {
        EditorState state = this.getEditorState();
        try {
            this.process(new NormalizeHistogram((IntegerImage)state.getImage()));
        }
        catch (OperationFailedException ofe) {
            this.frame.showError(ofe.toString());
        }
    }

    public void colorHistogramTextureProperties() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        PixelImage img = state.getImage();
        if (img == null || !(img instanceof Gray8Image)) {
            return;
        }
        Gray8Image image = (Gray8Image)img;
        this.frame.setWaitCursor();
        CoOccurrenceMatrix matrix = MatrixCreator.createCoOccurrenceMatrix(image, 0);
        TextureAnalysis ta = new TextureAnalysis();
        ta.setMatrix(matrix);
        ta.addProgressListeners(state.getProgressListeners());
        try {
            ta.process();
        }
        catch (MissingParameterException missingParameterException) {
            // empty catch block
        }
        StringBuffer text = new StringBuffer();
        text.append(strings.get(190) + "=" + ta.getContrast() + "\n");
        text.append(strings.get(195) + "=" + ta.getCorrelation() + "\n");
        text.append(strings.get(196) + "=" + ta.getDissimilarity() + "\n");
        text.append(strings.get(192) + "=" + ta.getEntropy() + "\n");
        text.append(strings.get(191) + "=" + ta.getEnergy() + "\n");
        text.append(strings.get(193) + "=" + ta.getHomogeneity());
        this.frame.setDefaultCursor();
        this.frame.updateStatusBar();
        this.frame.showInfo(strings.get(194), text.toString());
    }

    public void colorHistogramSaveHistogramAs() {
        EditorState state = this.getEditorState();
        PixelImage pi = state.getImage();
        if (pi == null || !(pi instanceof IntegerImage)) {
            return;
        }
        String textFileName = this.getUserSaveAsFileName(".txt", 185);
        if (textFileName == null) {
            return;
        }
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(textFileName)), false);
        }
        catch (IOException ioe) {
            this.frame.showError(ioe.toString());
            return;
        }
        IntegerImage image = (IntegerImage)pi;
        this.frame.setWaitCursor();
        int numChannels = image.getNumChannels();
        if (numChannels == 1) {
            Histogram1D hist = null;
            try {
                Histogram1DCreator hc = new Histogram1DCreator();
                hc.setImage(image);
                hc.addProgressListeners(state.getProgressListeners());
                hc.process();
                hist = hc.getHistogram();
            }
            catch (OperationFailedException ofe) {
                this.frame.showError(ofe.toString());
                this.frame.updateStatusBar();
                return;
            }
            HistogramSerialization.save(hist, out);
        } else if (numChannels == 3) {
            Histogram3D hist = null;
            try {
                Histogram3DCreator hc = new Histogram3DCreator();
                hc.setImage(image, 0, 1, 2);
                hc.addProgressListeners(state.getProgressListeners());
                hc.process();
                hist = hc.getHistogram();
            }
            catch (OperationFailedException ofe) {
                this.frame.showError(ofe.toString());
                this.frame.updateStatusBar();
                return;
            }
            HistogramSerialization.save(hist, out);
        }
        out.close();
        this.frame.setDefaultCursor();
        this.frame.updateStatusBar();
    }

    public void colorHistogramSaveCoOccurrenceMatrixAs() {
        EditorState state = this.getEditorState();
        PixelImage image = state.getImage();
        String textFileName = this.getUserSaveAsFileName(".txt", 172);
        if (textFileName == null) {
            return;
        }
        CoOccurrenceMatrix matrix = MatrixCreator.createCoOccurrenceMatrix((IntegerImage)image, 0);
        File textFile = new File(textFileName);
        try {
            PrintStream out = new PrintStream(new FileOutputStream(textFile));
            MatrixSerialization.save(matrix, out);
            out.close();
        }
        catch (IOException ioe) {
            this.frame.showError(ioe.toString());
        }
    }

    public void colorHistogramSaveCoOccurrenceFrequencyMatrixAs() {
        EditorState state = this.getEditorState();
        PixelImage image = state.getImage();
        String textFileName = this.getUserSaveAsFileName(".txt", 174);
        if (textFileName == null) {
            return;
        }
        CoOccurrenceMatrix com = MatrixCreator.createCoOccurrenceMatrix((IntegerImage)image, 0);
        CoOccurrenceFrequencyMatrix matrix = MatrixCreator.createCoOccurrenceFrequencyMatrix(com);
        File textFile = new File(textFileName);
        try {
            PrintStream out = new PrintStream(new FileOutputStream(textFile));
            MatrixSerialization.save(matrix, out);
            out.close();
        }
        catch (IOException ioe) {
            this.frame.showError(ioe.toString());
        }
    }

    public void colorPaletteSaveAs() {
        EditorState state = this.getEditorState();
        PalettedImage image = (PalettedImage)((Object)state.getImage());
        Palette palette = image.getPalette();
        String paletteFileName = this.getUserSaveAsFileName(".ppm", 161);
        if (paletteFileName == null) {
            return;
        }
        File paletteFile = new File(paletteFileName);
        try {
            PaletteSerialization.save(palette, paletteFile);
        }
        catch (IOException ioe) {
            this.frame.showError(ioe.toString());
        }
    }

    public void colorPromotePromoteToPaletted() {
        this.process(new PromotionPaletted8());
    }

    public void colorPromotePromoteToGray8() {
        this.process(new PromotionGray8());
    }

    public void colorPromotePromoteToGray16() {
        this.process(new PromotionGray16());
    }

    public void colorPromotePromoteToRgb24() {
        this.process(new PromotionRGB24());
    }

    public void colorPromotePromoteToRgb48() {
        this.process(new PromotionRGB48());
    }

    public void colorReduceReduceNumberOfShadesOfGray() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        PixelImage image = state.getImage();
        int maxBits = image.getBitsPerPixel() - 1;
        ReduceGrayscaleDialog rgd = new ReduceGrayscaleDialog(this.frame, strings, 1, maxBits, 2);
        rgd.setVisible(true);
        if (!rgd.hasPressedOk()) {
            return;
        }
        int numBits = rgd.getNumBits();
        ImageToImageOperation op = null;
        switch (rgd.getDitheringMethod()) {
            case 0: {
                ReduceShadesOfGray rsog = new ReduceShadesOfGray();
                rsog.setBits(numBits);
                op = rsog;
                break;
            }
            case 1: {
                OrderedDither od = new OrderedDither();
                od.setOutputBits(numBits);
                op = od;
                break;
            }
            case 2: {
                ErrorDiffusionDithering ed = new ErrorDiffusionDithering();
                ed.setTemplateType(0);
                ed.setGrayscaleOutputBits(numBits);
                op = ed;
                break;
            }
            case 3: {
                ErrorDiffusionDithering ed = new ErrorDiffusionDithering();
                ed.setTemplateType(1);
                ed.setGrayscaleOutputBits(numBits);
                op = ed;
                break;
            }
            case 4: {
                ErrorDiffusionDithering ed = new ErrorDiffusionDithering();
                ed.setTemplateType(2);
                ed.setGrayscaleOutputBits(numBits);
                op = ed;
                break;
            }
            case 5: {
                ErrorDiffusionDithering ed = new ErrorDiffusionDithering();
                ed.setTemplateType(3);
                ed.setGrayscaleOutputBits(numBits);
                op = ed;
                break;
            }
            case 6: {
                ErrorDiffusionDithering ed = new ErrorDiffusionDithering();
                ed.setTemplateType(4);
                ed.setGrayscaleOutputBits(numBits);
                op = ed;
                break;
            }
            case 7: {
                ErrorDiffusionDithering ed = new ErrorDiffusionDithering();
                ed.setTemplateType(5);
                ed.setGrayscaleOutputBits(numBits);
                op = ed;
                break;
            }
            default: {
                return;
            }
        }
        op.setInputImage(image);
        op.addProgressListeners(state.getProgressListeners());
        this.process(op);
    }

    public void colorReduceConvertToGrayscale() {
        this.process(new RGBToGrayConversion());
    }

    public void colorReduceMedianCut() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        PixelImage image = state.getImage();
        MedianCutDialog mcd = new MedianCutDialog(this.frame, strings, 256, 1, true, 8, 12.0);
        mcd.setVisible(true);
        if (!mcd.hasPressedOk()) {
            return;
        }
        int numColors = mcd.getNumColors();
        int method = mcd.getReprColorMethod();
        boolean palettedOutput = mcd.isOutputTypePaletted();
        ImageToImageOperation op = null;
        if (mcd.useContourRemoval()) {
            MedianCutQuantizer quantizer = new MedianCutQuantizer();
            quantizer.setInputImage(image);
            quantizer.setPaletteSize(numColors);
            quantizer.setMethodToDetermineRepresentativeColors(method);
            MedianCutContourRemoval removal = new MedianCutContourRemoval();
            removal.setQuantizer(quantizer);
            removal.setTau(mcd.getTau());
            removal.setNumPasses(mcd.getNumPasses());
            op = removal;
        } else if (mcd.useErrorDiffusion()) {
            MedianCutQuantizer medianCut = new MedianCutQuantizer();
            medianCut.setInputImage(image);
            medianCut.setPaletteSize(numColors);
            medianCut.setMethodToDetermineRepresentativeColors(method);
            medianCut.setMapping(false);
            try {
                medianCut.process();
            }
            catch (OperationFailedException ofe) {
                this.frame.showError(ofe.toString());
                return;
            }
            ErrorDiffusionDithering ed = new ErrorDiffusionDithering();
            ed.setTemplateType(mcd.getErrorDiffusion());
            ed.setQuantizer(medianCut);
            op = ed;
        } else {
            MedianCutQuantizer medianCut = new MedianCutQuantizer();
            medianCut.setInputImage(image);
            medianCut.setPaletteSize(numColors);
            medianCut.setTruecolorOutput(!palettedOutput);
            medianCut.setMethodToDetermineRepresentativeColors(method);
            op = medianCut;
        }
        this.process(op);
    }

    public void colorInvert() {
        this.process(new Invert());
    }

    public void colorConvertToMinimumColorType() {
        EditorState state = this.getEditorState();
        PixelImage image = state.getImage();
        AutoDetectColorType adct = new AutoDetectColorType();
        adct.setInputImage(image);
        adct.addProgressListeners(state.getProgressListeners());
        try {
            this.frame.setWaitCursor();
            adct.process();
        }
        catch (MissingParameterException mpe) {
            this.frame.setDefaultCursor();
            return;
        }
        catch (WrongParameterException mpe) {
            this.frame.setDefaultCursor();
            return;
        }
        if (!adct.isReducible()) {
            this.frame.setDefaultCursor();
            return;
        }
        this.frame.setDefaultCursor();
        this.setImage(adct.getOutputImage(), true);
        this.frame.updateImage();
    }

    public void colorReduceOctree() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        PixelImage image = state.getImage();
        OctreeDialog od = new OctreeDialog((Frame)this.frame, strings, 256, true);
        od.setVisible(true);
        if (!od.hasPressedOk()) {
            return;
        }
        OctreeColorQuantizer quantizer = new OctreeColorQuantizer();
        quantizer.setPaletteSize(od.getNumColors());
        quantizer.setInputImage(image);
        if (od.useNoDithering()) {
            quantizer.addProgressListeners(state.getProgressListeners());
            try {
                quantizer.process();
            }
            catch (WrongParameterException wrongParameterException) {
            }
            catch (MissingParameterException missingParameterException) {
                // empty catch block
            }
            image = quantizer.getOutputImage();
        } else if (od.useErrorDiffusion()) {
            try {
                quantizer.init();
            }
            catch (WrongParameterException wrongParameterException) {
            }
            catch (MissingParameterException missingParameterException) {
                // empty catch block
            }
            ErrorDiffusionDithering ed = new ErrorDiffusionDithering();
            ed.setTemplateType(od.getErrorDiffusion());
            ed.setQuantizer(quantizer);
            this.process(ed);
            return;
        }
        this.setImage(image, true);
        this.frame.updateImage();
    }

    public void colorReduceReduceToBilevelThreshold() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        IntegerImage image = (IntegerImage)state.getImage();
        int MAX = image.getMaxSample(0);
        Integer value = Dialogs.getInteger(this.frame, strings.get(122), strings.get(123), 0, MAX / 2, MAX, strings.get(64), strings.get(65));
        if (value == null) {
            return;
        }
        ReduceToBilevelThreshold red = new ReduceToBilevelThreshold();
        red.setThreshold(value);
        this.process(red);
    }

    private int convertUniformToErrorDiffusion(int utype) {
        switch (utype) {
            case 2: {
                return 0;
            }
            case 4: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
        }
        return -1;
    }

    public void colorReduceUniformPalette() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        UniformPaletteQuantizerDialog upqd = new UniformPaletteQuantizerDialog(this.frame, strings, 3, 3, 2, 2);
        upqd.setVisible(true);
        if (!upqd.hasPressedOk()) {
            return;
        }
        int redBits = upqd.getRedBits();
        int greenBits = upqd.getGreenBits();
        int blueBits = upqd.getBlueBits();
        int sum = redBits + greenBits + blueBits;
        switch (upqd.getDitheringMethod()) {
            case 0: {
                UniformPaletteQuantizer upq = new UniformPaletteQuantizer(redBits, greenBits, blueBits);
                this.process(upq);
                return;
            }
            case 1: {
                OrderedDither od = new OrderedDither();
                od.setRgbBits(redBits, greenBits, blueBits);
                this.process(od);
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ErrorDiffusionDithering ed = new ErrorDiffusionDithering();
                ed.setTemplateType(this.convertUniformToErrorDiffusion(upqd.getDitheringMethod()));
                UniformPaletteQuantizer upq = new UniformPaletteQuantizer(redBits, greenBits, blueBits);
                ed.setQuantizer(upq);
                ed.setTruecolorOutput(sum > 8);
                this.process(ed);
                return;
            }
        }
    }

    public void colorReduceMapToArbitraryPalette() {
        Palette palette;
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        PixelImage image = state.getImage();
        MapToArbitraryPaletteDialog d = new MapToArbitraryPaletteDialog((Frame)this.frame, strings);
        d.setVisible(true);
        if (!d.hasPressedOk()) {
            return;
        }
        int paletteType = d.getPaletteType();
        if (paletteType < 0) {
            return;
        }
        switch (paletteType) {
            case 0: {
                String name = this.getUserFileName(null, 162, 0);
                if (name == null) {
                    return;
                }
                File file = new File(name);
                palette = PaletteSerialization.load(file);
                break;
            }
            case 1: {
                palette = WebsafePaletteCreator.create();
                break;
            }
            case 2: {
                palette = PalmCodec.createSystem8BitPalette();
                break;
            }
            case 3: {
                palette = PalmCodec.createSystem4BitColorPalette();
                break;
            }
            case 4: {
                palette = PalmCodec.createSystem4BitGrayscalePalette();
                break;
            }
            case 5: {
                palette = PalmCodec.createSystem2BitGrayscalePalette();
                break;
            }
            default: {
                return;
            }
        }
        ArbitraryPaletteQuantizer apq = new ArbitraryPaletteQuantizer(palette);
        if (palette == null) {
            return;
        }
        if (d.useErrorDiffusion()) {
            ErrorDiffusionDithering ed = new ErrorDiffusionDithering();
            ed.setTemplateType(d.getErrorDiffusionType());
            ed.setQuantizer(apq);
            this.process(ed);
            return;
        }
        apq.setInputImage(image);
        apq.addProgressListeners(state.getProgressListeners());
        try {
            apq.process();
        }
        catch (OperationFailedException ofe) {
            return;
        }
        image = apq.getOutputImage();
        this.setImage(image, true);
        this.frame.updateImage();
    }

    public void editRedo() {
        EditorState state = this.getEditorState();
        if (!state.canRedo()) {
            return;
        }
        state.redo();
        this.frame.updateImage();
    }

    public void editUndo() {
        EditorState state = this.getEditorState();
        if (!state.canUndo()) {
            return;
        }
        state.undo();
        this.frame.updateImage();
    }

    public void fileClose() {
        EditorState state = this.getEditorState();
        if (state.getModified()) {
            YesNoDialog dialog = new YesNoDialog(this.frame, state.getStrings(), 219, 218, false);
            dialog.setVisible(true);
            if (dialog.getResult() == 1) {
                return;
            }
        }
        this.setImage(null, false);
        state.resetZoomFactors();
        state.setFileName("");
        state.clearRedo();
        state.clearUndo();
        this.frame.updateImage();
    }

    public void fileExit() {
        EditorState state = this.getEditorState();
        if (state.getModified()) {
            YesNoDialog dialog = new YesNoDialog(this.frame, state.getStrings(), 215, 214, false);
            dialog.setVisible(true);
            if (dialog.getResult() == 1) {
                return;
            }
        }
        this.frame.setVisible(false);
        System.exit(0);
    }

    public void fileOpen(String uri) {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        if (state.getModified()) {
            YesNoDialog dialog = new YesNoDialog(this.frame, state.getStrings(), 219, 218, false);
            dialog.setVisible(true);
            if (dialog.getResult() == 1) {
                return;
            }
        }
        File file = null;
        if (uri == null) {
            if (state.getStartupImageName() != null) {
                file = new File(state.getStartupImageName());
                state.setStartupImageName(null);
            } else {
                FileDialog fd = new FileDialog((Frame)this.frame, strings.get(2), 0);
                String dir = state.getCurrentDirectory();
                if (dir != null) {
                    fd.setDirectory(dir);
                }
                fd.setVisible(true);
                fd.setMode(0);
                String fn = fd.getFile();
                String dn = fd.getDirectory();
                if (fn == null || dn == null) {
                    return;
                }
                state.setCurrentDirectory(dn);
                file = new File(dn, fn);
            }
        }
        PixelImage image = null;
        String fullName = uri;
        try {
            image = uri != null ? ImageLoader.loadToolkitImageUri(uri) : ImageLoader.load(file, state.getProgressListeners());
        }
        catch (Exception e) {
            this.frame.showInfo("Error loading image", e.toString());
            e.printStackTrace();
            return;
        }
        if (file != null) {
            fullName = file.getAbsolutePath();
            if (image == null) {
                image = ToolkitLoader.loadAsRgb24Image(fullName);
            }
        }
        if (image == null) {
            this.frame.showInfo(strings.get(0), strings.get(1));
            return;
        }
        this.setImage(image, false);
        state.setFileName(fullName);
        this.frame.updateImage();
    }

    public void fileSaveAsBmp() {
        EditorState editor = this.getEditorState();
        PixelImage image = editor.getImage();
        if (image == null) {
            return;
        }
        BMPCodec codec = new BMPCodec();
        String name = this.getUserSaveAsFileName(codec.suggestFileExtension(image), 95);
        if (name == null) {
            return;
        }
        codec.addProgressListeners(editor.getProgressListeners());
        try {
            codec.setOutputStream(new BufferedOutputStream(new FileOutputStream(name)));
            codec.setImage(image);
            codec.process();
        }
        catch (Exception e) {
            this.frame.showError(e.toString());
            return;
        }
        editor.setFileName(name);
        this.setImage(image, false);
        this.frame.updateImage();
    }

    public void fileSaveAsGif() {
        EditorState editor = this.getEditorState();
        PixelImage image = editor.getImage();
        if (image == null) {
            return;
        }
        GIFCodec codec = new GIFCodec();
        String name = this.getUserSaveAsFileName(codec.suggestFileExtension(image), 95);
        if (name == null) {
            return;
        }
        codec.addProgressListeners(editor.getProgressListeners());
        try {
            codec.setFile(name, CodecMode.SAVE);
            codec.setImage(image);
            codec.process();
        }
        catch (Exception e) {
            this.frame.showError(e.toString());
            return;
        }
        editor.setFileName(name);
        this.setImage(image, false);
        this.frame.updateImage();
    }

    public void fileSaveAsPalm() {
        EditorState editor = this.getEditorState();
        PixelImage image = editor.getImage();
        if (image == null) {
            return;
        }
        PalmCodec codec = new PalmCodec();
        String name = this.getUserSaveAsFileName(codec.suggestFileExtension(image), 95);
        if (name == null) {
            return;
        }
        codec.setCompression(0);
        codec.addProgressListeners(editor.getProgressListeners());
        try {
            codec.setFile(name, CodecMode.SAVE);
            codec.setImage(image);
            codec.process();
        }
        catch (Exception e) {
            this.frame.showError(e.toString());
            return;
        }
        editor.setFileName(name);
        this.setImage(image, false);
        this.frame.updateImage();
    }

    public void fileSaveAsPbm() {
        this.fileSaveAsPnm();
    }

    public void fileSaveAsPgm() {
        this.fileSaveAsPnm();
    }

    public void fileSaveAsPng() {
        EditorState editor = this.getEditorState();
        PixelImage image = editor.getImage();
        if (image == null) {
            return;
        }
        PNGCodec codec = new PNGCodec();
        String name = this.getUserSaveAsFileName(codec.suggestFileExtension(image), 95);
        if (name == null) {
            return;
        }
        codec.addProgressListeners(editor.getProgressListeners());
        try {
            codec.setFile(name, CodecMode.SAVE);
            codec.setImage(image);
            codec.process();
        }
        catch (Exception e) {
            this.frame.showError(e.toString());
            return;
        }
        editor.setFileName(name);
        this.setImage(image, false);
        this.frame.updateImage();
    }

    private void fileSaveAsPnm() {
        EditorState editor = this.getEditorState();
        PixelImage image = editor.getImage();
        if (image == null) {
            return;
        }
        PNMCodec codec = new PNMCodec();
        String name = this.getUserSaveAsFileName(codec.suggestFileExtension(image), 95);
        if (name == null) {
            return;
        }
        codec.addProgressListeners(editor.getProgressListeners());
        try {
            codec.setOutputStream(new BufferedOutputStream(new FileOutputStream(name)));
            codec.setImage(image);
            codec.process();
        }
        catch (Exception e) {
            this.frame.showError(e.toString());
            return;
        }
        editor.setFileName(name);
        this.setImage(image, false);
        this.frame.updateImage();
    }

    public void fileSaveAsPpm() {
        this.fileSaveAsPnm();
    }

    public void fileSaveAsRas() {
        EditorState editor = this.getEditorState();
        PixelImage image = editor.getImage();
        if (image == null) {
            return;
        }
        RASCodec codec = new RASCodec();
        String name = this.getUserSaveAsFileName(codec.suggestFileExtension(image), 95);
        if (name == null) {
            return;
        }
        codec.addProgressListeners(editor.getProgressListeners());
        try {
            codec.setOutputStream(new BufferedOutputStream(new FileOutputStream(name)));
            codec.setImage(image);
            codec.process();
        }
        catch (Exception e) {
            this.frame.showError(e.toString());
            return;
        }
        editor.setFileName(name);
        this.setImage(image, false);
        this.frame.updateImage();
    }

    public void filterConvolutionFilter(int type) {
        ConvolutionKernelFilter ckf = new ConvolutionKernelFilter();
        ckf.setKernel(type);
        this.process(ckf);
    }

    public void filtersBlur() {
        this.filterConvolutionFilter(0);
    }

    public void filtersSharpen() {
        this.filterConvolutionFilter(1);
    }

    public void filtersEdgeDetection() {
        this.filterConvolutionFilter(2);
    }

    public void filtersEmboss() {
        this.filterConvolutionFilter(3);
    }

    public void filtersPsychedelicDistillation() {
        this.filterConvolutionFilter(4);
    }

    public void filtersLithograph() {
        this.filterConvolutionFilter(5);
    }

    public void filtersHorizontalSobel() {
        this.filterConvolutionFilter(6);
    }

    public void filtersVerticalSobel() {
        this.filterConvolutionFilter(7);
    }

    public void filtersHorizontalPrewitt() {
        this.filterConvolutionFilter(8);
    }

    public void filtersVerticalPrewitt() {
        this.filterConvolutionFilter(9);
    }

    public void filtersMaximum() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        WindowSizeDialog wsd = new WindowSizeDialog(this.frame, strings, 200, 3, 3);
        wsd.setVisible(true);
        if (!wsd.hasPressedOk()) {
            return;
        }
        MaximumFilter mf = new MaximumFilter();
        mf.setArea(wsd.getWidthValue(), wsd.getHeightValue());
        this.process(mf);
    }

    public void filtersMedian() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        WindowSizeDialog wsd = new WindowSizeDialog(this.frame, strings, 151, 3, 3);
        wsd.setVisible(true);
        if (!wsd.hasPressedOk()) {
            return;
        }
        MedianFilter mf = new MedianFilter();
        mf.setArea(wsd.getWidthValue(), wsd.getHeightValue());
        this.process(mf);
    }

    public void filtersMean() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        WindowSizeDialog wsd = new WindowSizeDialog(this.frame, strings, 150, 3, 3);
        wsd.setVisible(true);
        if (!wsd.hasPressedOk()) {
            return;
        }
        MeanFilter mf = new MeanFilter();
        mf.setArea(wsd.getWidthValue(), wsd.getHeightValue());
        this.process(mf);
    }

    public void filtersMinimum() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        WindowSizeDialog wsd = new WindowSizeDialog(this.frame, strings, 199, 3, 3);
        wsd.setVisible(true);
        if (!wsd.hasPressedOk()) {
            return;
        }
        MinimumFilter mf = new MinimumFilter();
        mf.setArea(wsd.getWidthValue(), wsd.getHeightValue());
        this.process(mf);
    }

    public void filtersOil() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        WindowSizeDialog wsd = new WindowSizeDialog(this.frame, strings, 152, 3, 3);
        wsd.setVisible(true);
        if (!wsd.hasPressedOk()) {
            return;
        }
        OilFilter of = new OilFilter();
        of.setArea(wsd.getWidthValue(), wsd.getHeightValue());
        this.process(of);
    }

    public String getUserFileName(String extension, int titleIndex, int fileDialogType) {
        EditorState editor = this.getEditorState();
        Strings strings = editor.getStrings();
        FileDialog fd = new FileDialog((Frame)this.frame, strings.get(titleIndex), fileDialogType);
        String currentDirectory = editor.getCurrentDirectory();
        if (currentDirectory != null) {
            fd.setDirectory(currentDirectory);
        }
        String fileName = editor.getFileName();
        if (fileDialogType == 1 && fileName != null && extension != null) {
            int dotIndex;
            File existingFile = new File(fileName);
            String name = existingFile.getName();
            if (name != null && (dotIndex = name.lastIndexOf(".")) != -1) {
                name = name.substring(0, dotIndex);
                name = name + extension;
            }
            fd.setFile(name);
        }
        fd.setVisible(true);
        String fn = fd.getFile();
        String dn = fd.getDirectory();
        if (fn == null || dn == null) {
            return null;
        }
        File file = new File(dn, fn);
        return file.getAbsolutePath();
    }

    public String getUserSaveAsFileName(String extension, int titleIndex) {
        return this.getUserFileName(extension, titleIndex, 1);
    }

    public void helpAbout() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        String message = JiuAwtFrame.APP_NAME + "\n" + strings.get(37) + "=" + "http://jiu.sourceforge.net/" + "\n" + strings.get(38) + "=" + "http://sourceforge.net/forum/forum.php?forum_id=51534";
        this.frame.showInfo(strings.get(9), message);
    }

    public void helpSystemInformation() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        this.frame.showInfo(strings.get(11), SystemInfo.getSystemInfo(strings) + "\n" + AwtInfo.getAwtInfo(strings) + "\n" + SystemInfo.getMemoryInfo(strings));
    }

    public void process(ImageToImageOperation op) {
        EditorState state = this.getEditorState();
        PixelImage image = state.getImage();
        if (image == null) {
            return;
        }
        this.frame.setWaitCursor();
        op.setInputImage(image);
        op.addProgressListeners(state.getProgressListeners());
        try {
            op.process();
            this.frame.setDefaultCursor();
        }
        catch (OperationFailedException ofe) {
            this.frame.setDefaultCursor();
            this.frame.showError(ofe.toString());
            return;
        }
        this.setImage(op.getOutputImage(), true);
        this.frame.updateImage();
    }

    public void setImage(PixelImage newImage, boolean newModified) {
        EditorState state = this.getEditorState();
        state.setImage(newImage, newModified);
    }

    public void transformationsFlip() {
        this.process(new Flip());
    }

    public void transformationsMirror() {
        this.process(new Mirror());
    }

    public void transformationsRotate90Left() {
        this.process(new Rotate90Left());
    }

    public void transformationsRotate90Right() {
        this.process(new Rotate90Right());
    }

    public void transformationsRotate180() {
        Rotate180 rot = new Rotate180();
        EditorState state = this.getEditorState();
        rot.setInputImage(state.getImage());
        this.process(rot);
    }

    public void transformationsCrop() {
        EditorState state = this.getEditorState();
        Strings strings = state.getStrings();
        PixelImage image = state.getImage();
        CropDialog cd = new CropDialog((Frame)this.frame, strings, image.getWidth(), image.getHeight());
        cd.setVisible(true);
        if (!cd.hasPressedOk()) {
            return;
        }
        int x1 = cd.getX1();
        int x2 = cd.getX2();
        int y1 = cd.getY1();
        int y2 = cd.getY2();
        Crop crop = new Crop();
        crop.setBounds(x1, y1, x2, y2);
        this.process(crop);
    }

    public void transformationsShear() {
        EditorState state = this.getEditorState();
        PixelImage image = state.getImage();
        Strings strings = state.getStrings();
        ShearDialog sd = new ShearDialog(this.frame, strings, 45.0, image.getWidth(), image.getHeight());
        sd.setVisible(true);
        if (!sd.hasPressedOk()) {
            return;
        }
        Double angle = sd.getValue();
        if (angle == null || angle == 0.0) {
            return;
        }
        Shear shear = new Shear();
        shear.setAngle(angle);
        this.process(shear);
    }

    public void transformationsScale() {
        EditorState state = this.getEditorState();
        PixelImage image = state.getImage();
        Strings strings = state.getStrings();
        boolean pickType = image instanceof RGB24Image || image instanceof Gray8Image;
        int initialType = pickType ? 4 : 0;
        ScaleDialog sd = new ScaleDialog(this.frame, strings, image.getWidth(), image.getHeight(), pickType, Resample.getFilterNames(), initialType);
        sd.setVisible(true);
        if (sd.hasPressedOk()) {
            int newWidth = sd.getWidthValue();
            int newHeight = sd.getHeightValue();
            if (newWidth < 1 || newHeight < 1 || newWidth == image.getWidth() && newHeight == image.getHeight()) {
                return;
            }
            if (pickType) {
                Resample resample = new Resample();
                resample.setFilter(sd.getType_());
                ResampleFilter filter = resample.getFilter();
                filter.setSamplingRadius(filter.getRecommendedSamplingRadius() * 50.0f);
                resample.setSize(newWidth, newHeight);
                this.process(resample);
            } else {
                ScaleReplication sc = new ScaleReplication();
                sc.setSize(newWidth, newHeight);
                this.process(sc);
            }
        }
    }

    public void updateFrame(PixelImage image) {
        EditorState state = this.getEditorState();
        state.setImage(image, true);
        this.frame.setDefaultCursor();
        this.frame.updateImage();
    }

    public void viewInterpolationTypeBicubic() {
        EditorState state = this.getEditorState();
        state.setInterpolation(2);
        this.frame.updateCanvas();
    }

    public void viewInterpolationTypeBilinear() {
        EditorState state = this.getEditorState();
        state.setInterpolation(1);
        this.frame.updateCanvas();
    }

    public void viewInterpolationTypeNearestNeighbor() {
        EditorState state = this.getEditorState();
        state.setInterpolation(0);
        this.frame.updateCanvas();
    }

    public void viewZoomIn() {
        this.frame.zoomIn();
    }

    public void viewZoomOut() {
        this.frame.zoomOut();
    }

    public void viewSetOriginalSize() {
        this.frame.setOriginalSize();
    }
}

