/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt;

import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionListener;
import net.sourceforge.jiu.apps.MenuWrapper;
import net.sourceforge.jiu.apps.OperationProcessor;
import net.sourceforge.jiu.apps.Strings;

public class AwtMenuWrapper
extends MenuWrapper {
    private ActionListener listener;
    private MenuItem[] items = new MenuItem[85];
    private MenuBar menuBar;

    public AwtMenuWrapper(Strings strings, ActionListener actionListener) {
        this.listener = actionListener;
        this.init(strings);
    }

    private Menu createMenu(Strings strings, int stringIndex) {
        String labelText = strings.get(stringIndex);
        Menu result = new Menu(labelText);
        return result;
    }

    private MenuShortcut createMenuShortcut(int menuIndex) {
        switch (menuIndex) {
            case 1: {
                return new MenuShortcut(79);
            }
            case 9: {
                return new MenuShortcut(81);
            }
            case 68: {
                return new MenuShortcut(90);
            }
            case 69: {
                return new MenuShortcut(89);
            }
            case 74: {
                return new MenuShortcut(107);
            }
            case 75: {
                return new MenuShortcut(109);
            }
            case 76: {
                return new MenuShortcut(108);
            }
        }
        return null;
    }

    public int findIndex(Object o) {
        if (o != null && this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                if (o != this.items[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    private void init(Strings strings) {
        for (int i = 0; i < this.items.length; ++i) {
            int stringIndex = this.getStringIndex(i);
            if (stringIndex == -1) continue;
            String labelText = strings.get(stringIndex);
            this.items[i] = new MenuItem(labelText);
        }
        this.menuBar = new MenuBar();
        Menu fileSaveAsMenu = this.createMenu(strings, 17);
        this.items[2] = fileSaveAsMenu;
        fileSaveAsMenu.add(this.items[83]);
        fileSaveAsMenu.add(this.items[81]);
        fileSaveAsMenu.add(this.items[3]);
        fileSaveAsMenu.add(this.items[4]);
        fileSaveAsMenu.add(this.items[82]);
        fileSaveAsMenu.add(this.items[5]);
        fileSaveAsMenu.add(this.items[6]);
        fileSaveAsMenu.add(this.items[7]);
        Menu fileMenu = this.createMenu(strings, 15);
        this.items[0] = fileMenu;
        fileMenu.add(this.items[1]);
        fileMenu.add(fileSaveAsMenu);
        fileMenu.add(this.items[8]);
        fileMenu.addSeparator();
        fileMenu.add(this.items[84]);
        fileMenu.addSeparator();
        fileMenu.add(this.items[9]);
        this.menuBar.add(fileMenu);
        Menu editMenu = this.createMenu(strings, 186);
        this.items[67] = editMenu;
        editMenu.add(this.items[68]);
        editMenu.add(this.items[69]);
        this.menuBar.add(editMenu);
        Menu colorAdjustMenu = this.createMenu(strings, 104);
        this.items[11] = colorAdjustMenu;
        colorAdjustMenu.add(this.items[12]);
        colorAdjustMenu.add(this.items[13]);
        colorAdjustMenu.add(this.items[14]);
        colorAdjustMenu.add(this.items[15]);
        Menu colorHistogramMenu = this.createMenu(strings, 121);
        this.items[16] = colorHistogramMenu;
        colorHistogramMenu.add(this.items[17]);
        colorHistogramMenu.add(this.items[18]);
        colorHistogramMenu.add(this.items[19]);
        colorHistogramMenu.add(this.items[70]);
        colorHistogramMenu.add(this.items[66]);
        colorHistogramMenu.add(this.items[20]);
        colorHistogramMenu.add(this.items[21]);
        Menu colorPaletteMenu = this.createMenu(strings, 158);
        this.items[22] = colorPaletteMenu;
        colorPaletteMenu.add(this.items[23]);
        Menu colorPromoteMenu = this.createMenu(strings, 177);
        this.items[24] = colorPromoteMenu;
        colorPromoteMenu.add(this.items[25]);
        colorPromoteMenu.add(this.items[26]);
        colorPromoteMenu.add(this.items[27]);
        colorPromoteMenu.add(this.items[28]);
        colorPromoteMenu.add(this.items[29]);
        Menu colorReduceMenu = this.createMenu(strings, 183);
        this.items[30] = colorReduceMenu;
        colorReduceMenu.add(this.items[31]);
        colorReduceMenu.add(this.items[32]);
        colorReduceMenu.add(this.items[33]);
        colorReduceMenu.add(this.items[34]);
        colorReduceMenu.add(this.items[35]);
        colorReduceMenu.add(this.items[36]);
        colorReduceMenu.add(this.items[37]);
        Menu colorMenu = this.createMenu(strings, 12);
        this.items[10] = colorMenu;
        colorMenu.add(colorAdjustMenu);
        colorMenu.add(colorHistogramMenu);
        colorMenu.add(colorPaletteMenu);
        colorMenu.add(colorPromoteMenu);
        colorMenu.add(colorReduceMenu);
        colorMenu.add(this.items[38]);
        colorMenu.add(this.items[39]);
        this.menuBar.add(colorMenu);
        Menu transformationsMenu = this.createMenu(strings, 48);
        this.items[40] = transformationsMenu;
        transformationsMenu.add(this.items[42]);
        transformationsMenu.add(this.items[41]);
        transformationsMenu.addSeparator();
        transformationsMenu.add(this.items[43]);
        transformationsMenu.add(this.items[44]);
        transformationsMenu.add(this.items[45]);
        transformationsMenu.addSeparator();
        transformationsMenu.add(this.items[46]);
        transformationsMenu.add(this.items[47]);
        transformationsMenu.add(this.items[48]);
        this.menuBar.add(transformationsMenu);
        Menu filtersMenu = this.createMenu(strings, 77);
        this.items[49] = filtersMenu;
        this.menuBar.add(filtersMenu);
        filtersMenu.add(this.items[50]);
        filtersMenu.add(this.items[51]);
        filtersMenu.add(this.items[52]);
        filtersMenu.add(this.items[53]);
        filtersMenu.add(this.items[54]);
        filtersMenu.add(this.items[55]);
        filtersMenu.add(this.items[56]);
        filtersMenu.add(this.items[57]);
        filtersMenu.add(this.items[58]);
        filtersMenu.add(this.items[59]);
        filtersMenu.addSeparator();
        filtersMenu.add(this.items[71]);
        filtersMenu.add(this.items[72]);
        filtersMenu.add(this.items[60]);
        filtersMenu.add(this.items[61]);
        filtersMenu.add(this.items[62]);
        Menu viewMenu = this.createMenu(strings, 201);
        this.items[73] = viewMenu;
        this.menuBar.add(viewMenu);
        viewMenu.add(this.items[74]);
        viewMenu.add(this.items[75]);
        viewMenu.add(this.items[76]);
        Menu viewInterpolationMenu = this.createMenu(strings, 205);
        this.items[77] = viewInterpolationMenu;
        viewInterpolationMenu.add(this.items[78]);
        viewInterpolationMenu.add(this.items[79]);
        viewInterpolationMenu.add(this.items[80]);
        Menu helpMenu = this.createMenu(strings, 8);
        this.items[63] = helpMenu;
        this.menuBar.add(helpMenu);
        helpMenu.add(this.items[64]);
        helpMenu.add(this.items[65]);
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            MenuShortcut shortcut = this.createMenuShortcut(i);
            if (shortcut != null) {
                this.items[i].setShortcut(shortcut);
            }
            this.items[i].addActionListener(this.listener);
        }
    }

    public void setEnabled(int index, boolean enabled) {
        if (index >= 0 && index < this.items.length && this.items[index] != null) {
            this.items[index].setEnabled(enabled);
        }
    }

    public void setLabel(int index, String text) {
        if (index >= 0 && index < this.items.length && this.items[index] != null) {
            this.items[index].setLabel(text);
        }
    }

    public void updateEnabled(OperationProcessor op) {
        for (int i = 0; i < this.items.length; ++i) {
            this.setEnabled(i, op.isAvailable(i));
        }
    }

    public void updateLabels(Strings strings) {
        for (int i = 0; i < this.items.length; ++i) {
            int stringIndex = this.getStringIndex(i);
            String text = strings.get(stringIndex);
            this.setLabel(i, text);
        }
    }
}

