/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.geometry;

import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class Rotate90Left
extends ImageToImageOperation {
    private void process(IntegerImage in, IntegerImage out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        if (out == null) {
            out = (IntegerImage)in.createCompatibleImage(HEIGHT, WIDTH);
            this.setOutputImage(out);
        }
        int totalItems = in.getNumChannels() * HEIGHT;
        int processedItems = 0;
        for (int c = 0; c < in.getNumChannels(); ++c) {
            for (int y = 0; y < HEIGHT; ++y) {
                for (int x = 0; x < WIDTH; ++x) {
                    out.putSample(c, y, WIDTH - x - 1, in.getSample(c, x, y));
                }
                this.setProgress(processedItems++, totalItems);
            }
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        PixelImage in = this.getInputImage();
        this.ensureOutputImageResolution(in.getHeight(), in.getWidth());
        if (!(in instanceof IntegerImage)) {
            throw new WrongParameterException("Input image must implement IntegerImage.");
        }
        this.process((IntegerImage)in, (IntegerImage)this.getOutputImage());
    }
}

