/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.geometry;

import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.geometry.BSplineFilter;
import net.sourceforge.jiu.geometry.BellFilter;
import net.sourceforge.jiu.geometry.BoxFilter;
import net.sourceforge.jiu.geometry.HermiteFilter;
import net.sourceforge.jiu.geometry.Lanczos3Filter;
import net.sourceforge.jiu.geometry.MitchellFilter;
import net.sourceforge.jiu.geometry.ResampleFilter;
import net.sourceforge.jiu.geometry.TriangleFilter;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class Resample
extends ImageToImageOperation {
    public static final int FILTER_TYPE_BOX = 0;
    public static final int FILTER_TYPE_TRIANGLE = 1;
    public static final int FILTER_TYPE_HERMITE = 2;
    public static final int FILTER_TYPE_BELL = 3;
    public static final int FILTER_TYPE_B_SPLINE = 4;
    public static final int FILTER_TYPE_LANCZOS3 = 5;
    public static final int FILTER_TYPE_MITCHELL = 6;
    private Integer outWidth;
    private Integer outHeight;
    private ResampleFilter filter;

    private static ResampleFilter createFilter(int filterType) {
        switch (filterType) {
            case 0: {
                return new BoxFilter();
            }
            case 1: {
                return new TriangleFilter();
            }
            case 2: {
                return new HermiteFilter();
            }
            case 3: {
                return new BellFilter();
            }
            case 4: {
                return new BSplineFilter();
            }
            case 5: {
                return new Lanczos3Filter();
            }
            case 6: {
                return new MitchellFilter();
            }
        }
        throw new IllegalArgumentException("Unknown filter type in Resample: " + filterType);
    }

    public ResampleFilter getFilter() {
        return this.filter;
    }

    public static String[] getFilterNames() {
        String[] result = new String[Resample.getNumFilters()];
        for (int i = 0; i < Resample.getNumFilters(); ++i) {
            ResampleFilter filter = Resample.createFilter(i);
            result[i] = filter.getName();
        }
        return result;
    }

    public static int getNumFilters() {
        return 7;
    }

    private void process(IntegerImage in, IntegerImage out) {
        int max;
        int k;
        int k2;
        int n;
        int j;
        int right;
        int i;
        if (out == null) {
            out = (IntegerImage)in.createCompatibleImage(this.outWidth, this.outHeight);
            this.setOutputImage(out);
        }
        if (this.filter == null) {
            this.filter = new TriangleFilter();
        }
        float fwidth = this.filter.getSamplingRadius();
        int dstWidth = this.outWidth;
        int dstHeight = this.outHeight;
        int srcWidth = in.getWidth();
        int srcHeight = in.getHeight();
        IntegerImage work = (IntegerImage)in.createCompatibleImage(dstWidth, srcHeight);
        float xscale = srcWidth == 1 ? (float)dstWidth / (float)srcWidth : (float)(dstWidth - 1) / (float)(srcWidth - 1);
        float yscale = srcHeight == 1 ? (float)dstHeight / (float)srcHeight : (float)(dstHeight - 1) / (float)(srcHeight - 1);
        int processedItems = 0;
        int totalItems = srcHeight + dstWidth;
        CList[] contrib = new CList[dstWidth];
        for (int i2 = 0; i2 < contrib.length; ++i2) {
            contrib[i2] = new CList();
        }
        if (xscale < 1.0f) {
            float width = fwidth / xscale;
            float fscale = 1.0f / xscale;
            int numPixels = (int)(width * 2.0f + 1.0f);
            for (i = 0; i < dstWidth; ++i) {
                contrib[i].n = 0;
                contrib[i].p = new Contributor[numPixels];
                for (int j2 = 0; j2 < contrib[i].p.length; ++j2) {
                    contrib[i].p[j2] = new Contributor();
                }
                float center = (float)i / xscale;
                int left = (int)Math.floor(center - width);
                right = (int)Math.ceil(center + width);
                for (j = left; j <= right; ++j) {
                    float weight = this.filter.apply((center - (float)j) / fscale) / fscale;
                    if (weight == 0.0f) continue;
                    n = j < 0 ? -j : (j >= srcWidth ? srcWidth - j + srcWidth - 1 : j);
                    k2 = contrib[i].n++;
                    contrib[i].p[k2].pixel = n;
                    contrib[i].p[k2].weight = weight;
                }
            }
        } else {
            int numPixels = (int)(fwidth * 2.0f + 1.0f);
            for (int i3 = 0; i3 < dstWidth; ++i3) {
                contrib[i3].n = 0;
                contrib[i3].p = new Contributor[numPixels];
                for (int j3 = 0; j3 < contrib[i3].p.length; ++j3) {
                    contrib[i3].p[j3] = new Contributor();
                }
                float center = (float)i3 / xscale;
                int left = (int)Math.floor(center - fwidth);
                int right2 = (int)Math.ceil(center + fwidth);
                for (int j4 = left; j4 <= right2; ++j4) {
                    float weight = this.filter.apply(center - (float)j4);
                    if (weight == 0.0f) continue;
                    int n2 = j4 < 0 ? -j4 : (j4 >= srcWidth ? srcWidth - j4 + srcWidth - 1 : j4);
                    int k3 = contrib[i3].n;
                    if (n2 < 0 || n2 >= srcWidth) {
                        weight = 0.0f;
                    }
                    ++contrib[i3].n;
                    contrib[i3].p[k3].pixel = n2;
                    contrib[i3].p[k3].weight = weight;
                }
            }
        }
        int NUM_CHANNELS = work.getNumChannels();
        int[] MAX = new int[NUM_CHANNELS];
        for (k = 0; k < NUM_CHANNELS; ++k) {
            MAX[k] = work.getMaxSample(k);
        }
        for (k = 0; k < srcHeight; ++k) {
            for (i = 0; i < dstWidth; ++i) {
                for (int channel = 0; channel < NUM_CHANNELS; ++channel) {
                    CList c = contrib[i];
                    float sample = 0.0f;
                    max = c.n;
                    for (int j5 = 0; j5 < max; ++j5) {
                        sample += (float)in.getSample(channel, c.p[j5].pixel, k) * c.p[j5].weight;
                    }
                    int result = (int)sample;
                    if (result < 0) {
                        result = 0;
                    } else if (result > MAX[channel]) {
                        result = MAX[channel];
                    }
                    work.putSample(channel, i, k, result);
                }
            }
            this.setProgress(processedItems++, totalItems);
        }
        contrib = new CList[dstHeight];
        for (int i4 = 0; i4 < contrib.length; ++i4) {
            contrib[i4] = new CList();
        }
        if (yscale < 1.0f) {
            float width = fwidth / yscale;
            float fscale = 1.0f / yscale;
            int numContributors = (int)(width * 2.0f + 1.0f);
            for (int i5 = 0; i5 < dstHeight; ++i5) {
                contrib[i5].n = 0;
                contrib[i5].p = new Contributor[numContributors];
                for (int j6 = 0; j6 < contrib[i5].p.length; ++j6) {
                    contrib[i5].p[j6] = new Contributor();
                }
                float center = (float)i5 / yscale;
                int left = (int)Math.floor(center - width);
                int right3 = (int)Math.ceil(center + width);
                for (int j7 = left; j7 <= right3; ++j7) {
                    float weight = this.filter.apply((center - (float)j7) / fscale) / fscale;
                    if (weight == 0.0f) continue;
                    int n3 = j7 < 0 ? -j7 : (j7 >= srcHeight ? srcHeight - j7 + srcHeight - 1 : j7);
                    int k4 = contrib[i5].n++;
                    if (n3 < 0 || n3 >= srcHeight) {
                        weight = 0.0f;
                    }
                    contrib[i5].p[k4].pixel = n3;
                    contrib[i5].p[k4].weight = weight;
                }
            }
        } else {
            int numContributors = (int)(fwidth * 2.0f + 1.0f);
            for (i = 0; i < dstHeight; ++i) {
                contrib[i].n = 0;
                contrib[i].p = new Contributor[numContributors];
                for (int j8 = 0; j8 < contrib[i].p.length; ++j8) {
                    contrib[i].p[j8] = new Contributor();
                }
                float center = (float)i / yscale;
                int left = (int)Math.floor(center - fwidth);
                right = (int)Math.ceil(center + fwidth);
                for (j = left; j <= right; ++j) {
                    float weight = this.filter.apply(center - (float)j);
                    if (weight == 0.0f) continue;
                    n = j < 0 ? -j : (j >= srcHeight ? srcHeight - j + srcHeight - 1 : j);
                    k2 = contrib[i].n++;
                    if (n < 0 || n >= srcHeight) {
                        weight = 0.0f;
                    }
                    contrib[i].p[k2].pixel = n;
                    contrib[i].p[k2].weight = weight;
                }
            }
        }
        for (int k5 = 0; k5 < dstWidth; ++k5) {
            for (int i6 = 0; i6 < dstHeight; ++i6) {
                for (int channel = 0; channel < NUM_CHANNELS; ++channel) {
                    float sample = 0.0f;
                    CList c = contrib[i6];
                    max = c.n;
                    for (int j9 = 0; j9 < max; ++j9) {
                        sample += (float)work.getSample(channel, k5, c.p[j9].pixel) * c.p[j9].weight;
                    }
                    int result = (int)sample;
                    if (result < 0) {
                        result = 0;
                    } else if (result > MAX[channel]) {
                        result = MAX[channel];
                    }
                    out.putSample(channel, k5, i6, result);
                }
            }
            this.setProgress(processedItems++, totalItems);
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        if (this.outWidth == null && this.outHeight == null && this.getOutputImage() != null) {
            PixelImage out = this.getOutputImage();
            this.outWidth = new Integer(out.getWidth());
            this.outHeight = new Integer(out.getHeight());
        }
        if (this.outWidth == null) {
            throw new MissingParameterException("Output width has not been initialized");
        }
        if (this.outHeight == null) {
            throw new MissingParameterException("Output height has not been initialized");
        }
        PixelImage image = this.getInputImage();
        if (image.getWidth() == this.outWidth.intValue() && image.getHeight() == this.outHeight.intValue()) {
            throw new WrongParameterException("Input image already has the size specified by setSize.");
        }
        this.ensureOutputImageResolution(this.outWidth, this.outHeight);
        if (!(image instanceof IntegerImage)) {
            throw new WrongParameterException("Input image must implement IntegerImage.");
        }
        this.process((IntegerImage)image, (IntegerImage)this.getOutputImage());
    }

    public void setSize(int width, int height) {
        this.outWidth = new Integer(width);
        this.outHeight = new Integer(height);
    }

    public void setFilter(ResampleFilter newFilter) {
        this.filter = newFilter;
    }

    public void setFilter(int filterType) {
        this.setFilter(Resample.createFilter(filterType));
    }

    public void setFilter(int filterType, float samplingRadius) {
        ResampleFilter newFilter = Resample.createFilter(filterType);
        newFilter.setSamplingRadius(samplingRadius);
        this.setFilter(newFilter);
    }

    class CList {
        int n;
        Contributor[] p;

        CList() {
        }
    }

    class Contributor {
        int pixel;
        float weight;

        Contributor() {
        }
    }
}

