/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.geometry;

import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class Mirror
extends ImageToImageOperation {
    private void process(IntegerImage in, IntegerImage out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        if (out == null) {
            out = (IntegerImage)in.createCompatibleImage(WIDTH, HEIGHT);
            this.setOutputImage(out);
        }
        int totalItems = in.getNumChannels() * WIDTH;
        int processedItems = 0;
        for (int c = 0; c < in.getNumChannels(); ++c) {
            int x1 = 0;
            int x2 = WIDTH - 1;
            while (x1 < WIDTH) {
                for (int y = 0; y < HEIGHT; ++y) {
                    out.putSample(c, x2, y, in.getSample(c, x1, y));
                }
                this.setProgress(processedItems++, totalItems);
                ++x1;
                --x2;
            }
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        this.ensureImagesHaveSameResolution();
        PixelImage in = this.getInputImage();
        if (!(in instanceof IntegerImage)) {
            throw new WrongParameterException("Input image must be of type IntegerImage.");
        }
        this.process((IntegerImage)in, (IntegerImage)this.getOutputImage());
    }
}

