/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.geometry;

import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class Crop
extends ImageToImageOperation {
    private int x1;
    private int y1;
    private int x2;
    private int y2;

    private void checkBounds() throws WrongParameterException {
        PixelImage in = this.getInputImage();
        if (this.x1 >= in.getWidth()) {
            throw new WrongParameterException("x1 must be smaller than input image width.");
        }
        if (this.x2 >= in.getWidth()) {
            throw new WrongParameterException("x2 must be smaller than input image width.");
        }
        if (this.y1 >= in.getHeight()) {
            throw new WrongParameterException("y1 must be smaller than input image height.");
        }
        if (this.y2 >= in.getHeight()) {
            throw new WrongParameterException("y2 must be smaller than input image height.");
        }
    }

    private void process(IntegerImage in, IntegerImage out) {
        int OUT_WIDTH = this.x2 - this.x1 + 1;
        int OUT_HEIGHT = this.y2 - this.y1 + 1;
        if (out == null) {
            out = (IntegerImage)in.createCompatibleImage(OUT_WIDTH, OUT_HEIGHT);
            this.setOutputImage(out);
        }
        int totalItems = in.getNumChannels() * OUT_HEIGHT;
        int processedItems = 0;
        for (int c = 0; c < in.getNumChannels(); ++c) {
            int yfrom = this.y1;
            for (int yto = 0; yto < OUT_HEIGHT; ++yto) {
                int xfrom = this.x1;
                for (int xto = 0; xto < OUT_WIDTH; ++xto) {
                    out.putSample(c, xto, yto, in.getSample(c, xfrom, yfrom));
                    ++xfrom;
                }
                this.setProgress(processedItems++, totalItems);
                ++yfrom;
            }
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        this.checkBounds();
        this.ensureOutputImageResolution(this.x2 - this.x1 + 1, this.y2 - this.y1 + 1);
        if (!(this.getInputImage() instanceof IntegerImage)) {
            throw new WrongParameterException("Input image must implement IntegerImage.");
        }
        this.process((IntegerImage)this.getInputImage(), (IntegerImage)this.getOutputImage());
    }

    public void setBounds(int x1, int y1, int x2, int y2) throws IllegalArgumentException {
        if (x1 < 0) {
            throw new IllegalArgumentException("x1 must not be negative.");
        }
        if (y1 < 0) {
            throw new IllegalArgumentException("y1 must not be negative.");
        }
        if (x2 < 0) {
            throw new IllegalArgumentException("x2 must not be negative.");
        }
        if (y2 < 0) {
            throw new IllegalArgumentException("y2 must not be negative.");
        }
        if (x1 > x2) {
            throw new IllegalArgumentException("x1 must not be larger than x2.");
        }
        if (y1 > y2) {
            throw new IllegalArgumentException("y1 must not be larger than y2.");
        }
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }
}

