/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.filters;

import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.filters.AreaFilterOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class OilFilter
extends AreaFilterOperation {
    private int[] hist;
    private int[] zeroes;

    public final int computeSample(int[] samples, int numSamples) {
        System.arraycopy(this.zeroes, 0, this.hist, 0, this.hist.length);
        int index = numSamples;
        do {
            int n = samples[--index];
            this.hist[n] = this.hist[n] + 1;
        } while (index != 0);
        int maxIndex = 0;
        int maxValue = this.hist[0];
        int HIST_LENGTH = this.hist.length;
        for (index = 1; index != HIST_LENGTH; ++index) {
            int value = this.hist[index];
            if (value <= maxValue) continue;
            maxIndex = index;
            maxValue = value;
        }
        return maxIndex;
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        PixelImage image = this.getInputImage();
        if (image instanceof IntegerImage) {
            IntegerImage ii = (IntegerImage)image;
            int max = ii.getMaxSample(0);
            int index = 1;
            while (index < ii.getNumChannels()) {
                int maxSample;
                if ((maxSample = ii.getMaxSample(index++)) <= max) continue;
                max = maxSample;
            }
            this.hist = new int[max + 1];
            this.zeroes = new int[this.hist.length];
            for (int i = 0; i < this.zeroes.length; ++i) {
                this.zeroes[i] = 0;
            }
        }
        super.process();
    }
}

