/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.data;

import net.sourceforge.jiu.data.RGBIndex;

public class Palette
implements RGBIndex {
    private int[][] data;
    private int numEntries;
    private int maxValue;

    public Palette(int numEntries, int maxValue) {
        if (numEntries < 1) {
            throw new IllegalArgumentException("Error -- numEntries must be larger than 0.");
        }
        this.numEntries = numEntries;
        this.maxValue = maxValue;
        this.data = new int[3][];
        for (int i = 0; i < 3; ++i) {
            this.data[i] = new int[numEntries];
        }
    }

    public Palette(int numEntries) {
        this(numEntries, 255);
    }

    public Object clone() {
        Palette result = new Palette(this.getNumEntries(), this.getMaxValue());
        for (int i = 0; i < this.getNumEntries(); ++i) {
            result.putSample(0, i, this.getSample(0, i));
            result.putSample(1, i, this.getSample(1, i));
            result.putSample(2, i, this.getSample(2, i));
        }
        return result;
    }

    public long getAllocatedMemory() {
        long result = 0L;
        if (this.data != null) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == null) continue;
                result += (long)this.data[i].length;
            }
        }
        return result;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public int getSample(int channelIndex, int entryIndex) {
        try {
            return this.data[channelIndex][entryIndex];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("Entry must be from 0 to " + (this.numEntries - 1) + ", channel from 0 to 2.");
        }
    }

    public int[] getSamples(int channelIndex) {
        if (channelIndex < 0 || channelIndex > 2) {
            throw new IllegalArgumentException("Invalid channel index, must be from 0 to 2.");
        }
        int[] result = new int[this.data[channelIndex].length];
        System.arraycopy(this.data[channelIndex], 0, result, 0, result.length);
        return result;
    }

    public boolean isBlackAndWhite() {
        for (int i = 0; i < this.numEntries; ++i) {
            if (this.data[0][i] == this.data[1][i] && this.data[1][i] == this.data[2][i] && (this.data[2][i] == 0 || this.data[2][i] == this.maxValue)) continue;
            return false;
        }
        return true;
    }

    public boolean isGray() {
        for (int i = 0; i < this.numEntries; ++i) {
            if (this.data[0][i] == this.data[1][i] && this.data[1][i] == this.data[2][i]) continue;
            return false;
        }
        return true;
    }

    public void put(int entryIndex, int red, int green, int blue) {
        this.putSample(0, entryIndex, red);
        this.putSample(1, entryIndex, green);
        this.putSample(2, entryIndex, blue);
    }

    public void putSample(int channelIndex, int entryIndex, int newValue) {
        if (newValue < 0 || newValue > this.maxValue) {
            throw new IllegalArgumentException("Value must be from 0 to " + this.maxValue + "; argument is " + newValue + ".");
        }
        try {
            this.data[channelIndex][entryIndex] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("Entry must be from 0 to " + (this.numEntries - 1) + ", channel from 0 to 2.");
        }
    }
}

