/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.data;

import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.ShortChannelImage;

public abstract class MemoryShortChannelImage
implements ShortChannelImage {
    private final short[][] data;
    private final short[] firstChannel;
    private final int numChannels;
    private final int width;
    private final int height;
    private final int numPixels;

    public MemoryShortChannelImage(int numChannels, int width, int height) {
        if (width < 1) {
            throw new IllegalArgumentException("Width must be larger than 0: " + width);
        }
        if (height < 1) {
            throw new IllegalArgumentException("Height must be larger than 0: " + height);
        }
        if (numChannels < 1) {
            throw new IllegalArgumentException("Number of channels must be larger than 0: " + numChannels);
        }
        this.width = width;
        this.height = height;
        this.numChannels = numChannels;
        this.numPixels = width * height;
        this.data = new short[numChannels][];
        for (int i = 0; i < numChannels; ++i) {
            this.data[i] = new short[this.numPixels];
        }
        this.firstChannel = this.data[0];
    }

    protected void checkPositionAndNumber(int channel, int x, int y, int w, int h) {
        if (channel < 0 || channel >= this.numChannels) {
            throw new IllegalArgumentException("Illegal channel index value: " + channel + ". Must be from 0 to " + (this.numChannels - 1) + ".");
        }
        if (x < 0 || x >= this.getWidth()) {
            throw new IllegalArgumentException("The value for x is invalid: " + x + ".");
        }
        if (w < 1) {
            throw new IllegalArgumentException("The value for w is invalid: " + w + ".");
        }
        if (x + w > this.getWidth()) {
            throw new IllegalArgumentException("The values x + w exceed the width of this image; x=" + x + ", w=" + w + ", width=" + this.getWidth());
        }
        if (h < 1) {
            throw new IllegalArgumentException("The value for h is invalid: " + h + ".");
        }
        if (y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("The value for y is invalid: " + y + ".");
        }
        if (y + h > this.getHeight()) {
            throw new IllegalArgumentException("The values y + h exceed the height of this image; y=" + y + ", h=" + h + ", height=" + this.getHeight());
        }
    }

    public void clear(short newValue) {
        this.clear(0, newValue);
    }

    public void clear(int channelIndex, short newValue) {
        this.checkPositionAndNumber(channelIndex, 0, 0, 1, 1);
        short[] CHANNEL = this.data[channelIndex];
        short VALUE = newValue;
        int LENGTH = CHANNEL.length;
        for (int i = 0; i < LENGTH; ++i) {
            CHANNEL[i] = VALUE;
        }
    }

    public void clear(int newValue) {
        this.clear(0, (short)newValue);
    }

    public void clear(int channelIndex, int newValue) {
        this.clear(channelIndex, (short)newValue);
    }

    public abstract PixelImage createCompatibleImage(int var1, int var2);

    public PixelImage createCopy() {
        PixelImage copy = this.createCompatibleImage(this.getWidth(), this.getHeight());
        MemoryShortChannelImage result = (MemoryShortChannelImage)copy;
        for (int channelIndex = 0; channelIndex < this.getNumChannels(); ++channelIndex) {
            System.arraycopy(this.data[channelIndex], 0, result.data[channelIndex], 0, this.data[channelIndex].length);
        }
        return result;
    }

    public long getAllocatedMemory() {
        long result = 0L;
        if (this.data != null) {
            int channelIndex = 0;
            while (channelIndex < this.data.length) {
                short[] array;
                if ((array = this.data[channelIndex++]) == null) continue;
                result += (long)(array.length * 2);
            }
        }
        return result;
    }

    public int getBitsPerPixel() {
        return this.numChannels * 16;
    }

    public short getShortSample(int channel, int x, int y) {
        try {
            return this.data[channel][y * this.width + x];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(channel, x, y, 1, 1);
            return -1;
        }
    }

    public short getShortSample(int x, int y) {
        return this.getShortSample(0, x, y);
    }

    public void getShortSamples(int channel, int x, int y, int w, int h, short[] dest, int destOffset) {
        this.checkPositionAndNumber(channel, x, y, w, h);
        short[] src = this.data[channel];
        try {
            int srcOffset = y * this.width + x;
            while (h-- > 0) {
                System.arraycopy(src, srcOffset, dest, destOffset, w);
                srcOffset += this.width;
                destOffset += w;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public final int getHeight() {
        return this.height;
    }

    public int getMaxSample(int channel) {
        return 65535;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public final int getSample(int x, int y) {
        try {
            return this.firstChannel[y * this.width + x] & 0xFFFF;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(0, x, y, 1, 1);
            return -1;
        }
    }

    public final int getSample(int channel, int x, int y) {
        try {
            return this.data[channel][y * this.width + x] & 0xFFFF;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(channel, x, y, 1, 1);
            return -1;
        }
    }

    public void getSamples(int channel, int x, int y, int w, int h, int[] dest, int destOffs) {
        if (w < 1 || h < 1) {
            return;
        }
        short[] src = this.data[channel];
        int srcOffs = y * this.width + x;
        while (h-- != 0) {
            int loop = w;
            int from = srcOffs;
            while (loop-- != 0) {
                dest[destOffs++] = src[from++] & 0xFFFF;
            }
            srcOffs += this.width;
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final void putShortSample(int channel, int x, int y, short newValue) {
        this.checkPositionAndNumber(channel, x, y, 1, 1);
        try {
            this.data[channel][y * this.width + x] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(channel, x, y, 1, 1);
        }
    }

    public final void putShortSample(int x, int y, short newValue) {
        this.checkPositionAndNumber(0, x, y, 1, 1);
        try {
            this.firstChannel[y * this.width + x] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(0, x, y, 1, 1);
        }
    }

    public void putShortSamples(int channel, int x, int y, int w, int h, short[] src, int srcOffset) {
        this.checkPositionAndNumber(channel, x, y, w, h);
        short[] dest = this.data[channel];
        int destOffset = y * this.width + x;
        while (h-- > 0) {
            System.arraycopy(src, srcOffset, dest, destOffset, w);
            srcOffset += w;
            destOffset += this.width;
        }
    }

    public void putSamples(int channel, int x, int y, int w, int h, int[] src, int srcOffs) {
        this.checkPositionAndNumber(channel, x, y, w, h);
        short[] dest = this.data[channel];
        int destOffs = y * this.width + x;
        while (h-- != 0) {
            int loop = w;
            int to = destOffs;
            while (loop-- != 0) {
                dest[to++] = (short)src[srcOffs++];
            }
            destOffs += this.width;
        }
    }

    public final void putSample(int x, int y, int newValue) {
        this.putShortSample(0, x, y, (short)newValue);
    }

    public final void putSample(int channel, int x, int y, int newValue) {
        this.putShortSample(channel, x, y, (short)newValue);
    }
}

