/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.data;

import net.sourceforge.jiu.data.ByteChannelImage;
import net.sourceforge.jiu.data.PixelImage;

public abstract class MemoryByteChannelImage
implements ByteChannelImage {
    private final byte[][] data;
    private final byte[] firstChannel;
    private final int numChannels;
    private final int width;
    private final int height;
    private final int numPixels;

    public MemoryByteChannelImage(int numChannels, int width, int height) {
        if (width < 1) {
            throw new IllegalArgumentException("Width must be larger than 0: " + width);
        }
        if (height < 1) {
            throw new IllegalArgumentException("Height must be larger than 0: " + height);
        }
        if (numChannels < 1) {
            throw new IllegalArgumentException("Number of channels must be larger than 0: " + numChannels);
        }
        this.width = width;
        this.height = height;
        this.numChannels = numChannels;
        this.numPixels = width * height;
        this.data = new byte[numChannels][];
        for (int i = 0; i < numChannels; ++i) {
            this.data[i] = new byte[this.numPixels];
        }
        this.firstChannel = this.data[0];
    }

    protected void checkPositionAndNumber(int channel, int x, int y, int w, int h) {
        if (channel < 0 || channel >= this.numChannels) {
            throw new IllegalArgumentException("Illegal channel index value: " + channel + ". Must be from 0 to " + (this.numChannels - 1) + ".");
        }
        if (x < 0 || x >= this.getWidth()) {
            throw new IllegalArgumentException("The value for x is invalid: " + x + ".");
        }
        if (w < 1) {
            throw new IllegalArgumentException("The value for w is invalid: " + w + ".");
        }
        if (x + w > this.getWidth()) {
            throw new IllegalArgumentException("The values x + w exceed the width of this image; x=" + x + ", w=" + w + ", width=" + this.getWidth());
        }
        if (h < 1) {
            throw new IllegalArgumentException("The value for h is invalid: " + h + ".");
        }
        if (y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("The value for y is invalid: " + y + ".");
        }
        if (y + h > this.getHeight()) {
            throw new IllegalArgumentException("The values y + h exceed the height of this image; y=" + y + ", h=" + h + ", height=" + this.getHeight());
        }
    }

    public void clear(byte newValue) {
        this.clear(0, newValue);
    }

    public void clear(int channelIndex, byte newValue) {
        this.checkPositionAndNumber(channelIndex, 0, 0, 1, 1);
        byte[] CHANNEL = this.data[channelIndex];
        byte VALUE = newValue;
        int LENGTH = CHANNEL.length;
        for (int i = 0; i < LENGTH; ++i) {
            CHANNEL[i] = VALUE;
        }
    }

    public void clear(int newValue) {
        this.clear(0, (byte)newValue);
    }

    public void clear(int channelIndex, int newValue) {
        this.clear(channelIndex, (byte)newValue);
    }

    public abstract PixelImage createCompatibleImage(int var1, int var2);

    public PixelImage createCopy() {
        PixelImage copy = this.createCompatibleImage(this.getWidth(), this.getHeight());
        MemoryByteChannelImage result = (MemoryByteChannelImage)copy;
        for (int channelIndex = 0; channelIndex < this.getNumChannels(); ++channelIndex) {
            System.arraycopy(this.data[channelIndex], 0, result.data[channelIndex], 0, this.data[channelIndex].length);
        }
        return result;
    }

    public long getAllocatedMemory() {
        long result = 0L;
        if (this.data != null) {
            int channelIndex = 0;
            while (channelIndex < this.data.length) {
                byte[] array;
                if ((array = this.data[channelIndex++]) == null) continue;
                result += (long)array.length;
            }
        }
        return result;
    }

    public int getBitsPerPixel() {
        return this.numChannels * 8;
    }

    public byte getByteSample(int channel, int x, int y) {
        try {
            return this.data[channel][y * this.width + x];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(channel, x, y, 1, 1);
            return -1;
        }
    }

    public byte getByteSample(int x, int y) {
        return this.getByteSample(0, x, y);
    }

    public void getByteSamples(int channel, int x, int y, int w, int h, byte[] dest, int destOffset) {
        this.checkPositionAndNumber(channel, x, y, w, h);
        byte[] src = this.data[channel];
        try {
            int srcOffset = y * this.width + x;
            while (h-- > 0) {
                System.arraycopy(src, srcOffset, dest, destOffset, w);
                srcOffset += this.width;
                destOffset += w;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public final int getHeight() {
        return this.height;
    }

    public int getMaxSample(int channel) {
        return 255;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public final int getSample(int x, int y) {
        try {
            return this.firstChannel[y * this.width + x] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(0, x, y, 1, 1);
            return -1;
        }
    }

    public final int getSample(int channel, int x, int y) {
        try {
            return this.data[channel][y * this.width + x] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(channel, x, y, 1, 1);
            return -1;
        }
    }

    public void getSamples(int channel, int x, int y, int w, int h, int[] dest, int destOffs) {
        if (w < 1 || h < 1) {
            return;
        }
        byte[] src = this.data[channel];
        int srcOffs = y * this.width + x;
        while (h-- != 0) {
            int loop = w;
            int from = srcOffs;
            while (loop-- != 0) {
                dest[destOffs++] = src[from++] & 0xFF;
            }
            srcOffs += this.width;
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final void putByteSample(int channel, int x, int y, byte newValue) {
        this.checkPositionAndNumber(channel, x, y, 1, 1);
        try {
            this.data[channel][y * this.width + x] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(channel, x, y, 1, 1);
        }
    }

    public final void putByteSample(int x, int y, byte newValue) {
        this.checkPositionAndNumber(0, x, y, 1, 1);
        try {
            this.firstChannel[y * this.width + x] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(0, x, y, 1, 1);
        }
    }

    public void putByteSamples(int channel, int x, int y, int w, int h, byte[] src, int srcOffset) {
        this.checkPositionAndNumber(channel, x, y, w, h);
        byte[] dest = this.data[channel];
        int destOffset = y * this.width + x;
        while (h-- > 0) {
            System.arraycopy(src, srcOffset, dest, destOffset, w);
            srcOffset += w;
            destOffset += this.width;
        }
    }

    public void putSamples(int channel, int x, int y, int w, int h, int[] src, int srcOffs) {
        this.checkPositionAndNumber(channel, x, y, w, h);
        byte[] dest = this.data[channel];
        int destOffs = y * this.width + x;
        while (h-- != 0) {
            int loop = w;
            int to = destOffs;
            while (loop-- != 0) {
                dest[to++] = (byte)src[srcOffs++];
            }
            destOffs += this.width;
        }
    }

    public final void putSample(int x, int y, int newValue) {
        this.putByteSample(0, x, y, (byte)newValue);
    }

    public final void putSample(int channel, int x, int y, int newValue) {
        this.putByteSample(channel, x, y, (byte)newValue);
    }
}

